/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.windows;

import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import eu.esa.snap.netbeans.docwin.DocumentTopComponent;
import eu.esa.snap.netbeans.docwin.WindowUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.plaf.LayerUI;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.rcp.util.ContextGlobalExtender;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.awt.UndoRedo;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

public class ProductSceneViewTopComponent
extends DocumentTopComponent<ProductNode, ProductSceneView>
implements UndoRedo.Provider,
SelectionChangeListener {
    private static final Logger LOG = Logger.getLogger(ProductSceneViewTopComponent.class.getName());
    private final ProductSceneView view;
    private final UndoRedo undoRedo;
    private final ProductNodeListenerAdapter nodeRenameHandler;
    private Selection selection;

    public ProductSceneViewTopComponent(ProductSceneView view, UndoRedo undoRedo) {
        super((Object)view.getRaster());
        this.view = view;
        this.undoRedo = undoRedo != null ? undoRedo : UndoRedo.NONE;
        this.nodeRenameHandler = new NodeRenameHandler();
        this.selection = Selection.EMPTY;
        this.setToolTipText(view.getRaster().getDescription());
        this.setIcon(ImageUtilities.loadImage((String)"org/esa/snap/rcp/icons/RsBandAsSwath.gif"));
        this.updateDisplayName();
        this.setName(this.getDisplayName());
        this.setLayout(new BorderLayout());
        this.add(new JLayer<ProductSceneView>(this.view, new ProductSceneViewLayerUI()), "Center");
    }

    public ProductSceneView getView() {
        return this.view;
    }

    public UndoRedo getUndoRedo() {
        return this.undoRedo;
    }

    public void selectionChanged(SelectionChangeEvent event) {
        this.setSelection(event.getSelection());
    }

    public void selectionContextChanged(SelectionChangeEvent event) {
    }

    public void componentOpened() {
        LOG.info(">> componentOpened");
        ((ProductNode)this.getDocument()).getProduct().addProductNodeListener((ProductNodeListener)this.nodeRenameHandler);
    }

    public void componentClosed() {
        LOG.info(">> componentClosed");
        ((ProductNode)this.getDocument()).getProduct().removeProductNodeListener((ProductNodeListener)this.nodeRenameHandler);
    }

    public void componentSelected() {
        LOG.info(">> componentSelected");
        this.updateSelectedState();
        ContextGlobalExtender contextGlobalExtender = (ContextGlobalExtender)Utilities.actionsGlobalContext().lookup(ContextGlobalExtender.class);
        if (contextGlobalExtender != null) {
            contextGlobalExtender.put("view", this.getView());
        }
        this.setSelection(this.getView().getFigureEditor().getSelectionContext().getSelection());
        this.getView().getFigureEditor().getSelectionContext().addSelectionChangeListener((SelectionChangeListener)this);
    }

    public void componentDeselected() {
        LOG.info(">> componentDeselected");
        this.updateSelectedState();
        this.getView().getFigureEditor().getSelectionContext().removeSelectionChangeListener((SelectionChangeListener)this);
        this.setSelection(Selection.EMPTY);
        ContextGlobalExtender contextGlobalExtender = (ContextGlobalExtender)Utilities.actionsGlobalContext().lookup(ContextGlobalExtender.class);
        if (contextGlobalExtender != null) {
            contextGlobalExtender.remove("view");
        }
    }

    public void documentClosing() {
        super.documentClosing();
        this.getView().disposeLayers();
        this.getView().dispose();
    }

    private void updateDisplayName() {
        this.setDisplayName(WindowUtilities.getUniqueTitle((String)this.getView().getSceneName(), ProductSceneViewTopComponent.class));
    }

    private void setSelection(Selection newSelection) {
        Selection oldSelection = this.selection;
        this.getDynamicContent().remove((Object)oldSelection);
        if (!newSelection.isEmpty()) {
            this.selection = newSelection.clone();
            this.getDynamicContent().add((Object)newSelection);
        }
        this.updateActionMap(newSelection);
    }

    private void updateActionMap(Selection newSelection) {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("select-all", new SelectAllAction());
        actionMap.put("paste-from-clipboard", new PasteAction());
        if (!newSelection.isEmpty()) {
            actionMap.put("cut-to-clipboard", new CutAction());
            actionMap.put("copy-to-clipboard", new CopyAction());
            actionMap.put("delete", new DeleteAction());
            actionMap.put("deselect-all", new DeselectAllAction());
        } else {
            actionMap.remove("cut-to-clipboard");
            actionMap.remove("copy-to-clipboard");
            actionMap.remove("delete");
            actionMap.remove("deselect-all");
        }
        this.getDynamicContent().remove((Object)actionMap);
        this.getDynamicContent().add((Object)actionMap);
    }

    private class NodeRenameHandler
    extends ProductNodeListenerAdapter {
        private NodeRenameHandler() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            if (event.getSourceNode() == ProductSceneViewTopComponent.this.getDocument() && event.getPropertyName().equalsIgnoreCase("name")) {
                ProductSceneViewTopComponent.this.updateDisplayName();
            }
        }
    }

    private class DeselectAllAction
    extends AbstractAction {
        private DeselectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProductSceneViewTopComponent.this.getView().getFigureEditor().setSelection(Selection.EMPTY);
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        private SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProductSceneViewTopComponent.this.getView().getFigureEditor().selectAll();
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProductSceneViewTopComponent.this.getView().getFigureEditor().deleteSelection();
        }
    }

    private class PasteAction
    extends AbstractAction {
        private PasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(ProductSceneViewTopComponent.this.getView());
            try {
                ProductSceneViewTopComponent.this.getView().getSelectionContext().insert(contents);
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class CopyAction
    extends AbstractAction {
        private CopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Selection selection = (Selection)ProductSceneViewTopComponent.this.getLookup().lookup(Selection.class);
            if (selection != null && !selection.isEmpty()) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = ProductSceneViewTopComponent.this.getView().getFigureEditor().getFigureSelection().createTransferable(true);
                clipboard.setContents(transferable, (ClipboardOwner)selection);
            }
        }
    }

    private class CutAction
    extends AbstractAction {
        private CutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Selection selection = (Selection)ProductSceneViewTopComponent.this.getLookup().lookup(Selection.class);
            if (selection != null && !selection.isEmpty()) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = ProductSceneViewTopComponent.this.getView().getFigureEditor().getFigureSelection().createTransferable(false);
                clipboard.setContents(transferable, (ClipboardOwner)selection);
                ProductSceneViewTopComponent.this.getView().getFigureEditor().deleteSelection();
            }
        }
    }

    private class ProductSceneViewLayerUI
    extends LayerUI<ProductSceneView> {
        private ProductSceneViewLayerUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            if (ProductSceneViewTopComponent.this.isSelected()) {
                int N = 6;
                int A = 220;
                Color C = new Color(255, 213, 79);
                for (int i = 0; i < 6; ++i) {
                    g.setColor(new Color(C.getRed(), C.getGreen(), C.getBlue(), 220 - i * 220 / 6));
                    g.drawRect(i, i, ProductSceneViewTopComponent.this.getWidth() - 2 * i, ProductSceneViewTopComponent.this.getHeight() - 2 * i);
                }
            }
        }
    }
}

