/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.windows;

import com.bc.ceres.glayer.support.ImageLayer;
import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.pixelinfo.PixelInfoView;
import org.esa.snap.rcp.windows.Bundle;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.ui.PixelPositionListener;
import org.esa.snap.ui.product.ProductSceneView;
import org.locationtech.jts.geom.Point;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="PixelInfoTopComponent", iconBase="org/esa/snap/rcp/icons/PixelInfo.png", persistenceType=0)
public final class PixelInfoTopComponent
extends ToolTopComponent {
    private ProductSceneView currentView;
    private PixelPositionListener pixelPositionListener;
    private final PixelInfoView pixelInfoView;
    private final PinSelectionChangeListener pinSelectionChangeListener;
    private final PinChangedListener pinChangedListener;
    private final JCheckBox pinCheckbox;

    public PixelInfoTopComponent() {
        this.setName(Bundle.CTL_PixelInfoTopComponentName());
        this.setToolTipText(Bundle.CTL_PixelInfoTopComponentDescription());
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.keep_preferred_size_when_slided_in", Boolean.TRUE);
        this.pixelPositionListener = new MyPixelPositionListener();
        this.pinSelectionChangeListener = new PinSelectionChangeListener();
        this.pinChangedListener = new PinChangedListener();
        this.pixelInfoView = new PixelInfoView();
        this.pinCheckbox = new JCheckBox("Snap to selected pin");
        this.pinCheckbox.setName("pinCheckbox");
        this.pinCheckbox.setSelected(false);
        this.pinCheckbox.addActionListener(e -> this.updatePixelInfo());
        this.setLayout(new BorderLayout());
        this.add(this.pixelInfoView, "Center");
        this.add(this.pinCheckbox, "South");
        SnapApp snapApp = SnapApp.getDefault();
        snapApp.getProductManager().addListener((ProductManager.Listener)new PxInfoProductManagerListener());
        this.setCurrentView(snapApp.getSelectedProductSceneView());
    }

    @Override
    protected void productSceneViewSelected(@NonNull ProductSceneView view) {
        this.setCurrentView(view);
        if (this.isSnapToSelectedPin()) {
            this.snapToSelectedPin();
        }
    }

    @Override
    protected void productSceneViewDeselected(@NonNull ProductSceneView view) {
        this.setCurrentView(null);
        if (this.isSnapToSelectedPin()) {
            this.snapToSelectedPin();
        }
    }

    private void setCurrentView(ProductSceneView view) {
        Product product;
        if (this.currentView == view) {
            return;
        }
        if (this.currentView != null) {
            this.currentView.removePixelPositionListener(this.pixelPositionListener);
            this.currentView.removePropertyChangeListener("selectedPin", (PropertyChangeListener)this.pinSelectionChangeListener);
            product = this.currentView.getProduct();
            if (product != null) {
                product.removeProductNodeListener((ProductNodeListener)this.pinChangedListener);
            }
        } else {
            this.pixelInfoView.clearProductNodeRefs();
        }
        this.currentView = view;
        if (this.currentView != null) {
            this.currentView.addPixelPositionListener(this.pixelPositionListener);
            this.currentView.addPropertyChangeListener("selectedPin", (PropertyChangeListener)this.pinSelectionChangeListener);
            product = this.currentView.getProduct();
            if (product != null) {
                product.addProductNodeListener((ProductNodeListener)this.pinChangedListener);
            }
        } else {
            this.pixelInfoView.reset();
        }
    }

    private void updatePixelInfo() {
        if (this.isSnapToSelectedPin()) {
            SwingUtilities.invokeLater(this::snapToSelectedPin);
        } else {
            this.pixelInfoView.updatePixelValues(this.currentView, -1, -1, 0, false);
        }
    }

    private boolean isSnapToSelectedPin() {
        return this.pinCheckbox.isSelected();
    }

    private void snapToSelectedPin() {
        Placemark pin;
        Placemark placemark = pin = this.currentView != null ? this.currentView.getSelectedPin() : null;
        if (pin != null) {
            PixelPos rasterPos = new PixelPos();
            Point pinSceneCoords = (Point)pin.getFeature().getDefaultGeometry();
            Point2D.Double pinSceneCoordsDouble = new Point2D.Double(pinSceneCoords.getX(), pinSceneCoords.getY());
            try {
                this.currentView.getRaster().getImageToModelTransform().createInverse().transform(pinSceneCoordsDouble, (Point2D)rasterPos);
            }
            catch (NoninvertibleTransformException e) {
                rasterPos = pin.getPixelPos();
            }
            int x = MathUtils.floorInt((double)rasterPos.x);
            int y = MathUtils.floorInt((double)rasterPos.y);
            this.pixelInfoView.updatePixelValues(this.currentView, x, y, 0, true);
        } else {
            this.pixelInfoView.updatePixelValues(this.currentView, -1, -1, 0, false);
        }
    }

    private class PxInfoProductManagerListener
    implements ProductManager.Listener {
        private PxInfoProductManagerListener() {
        }

        public void productAdded(ProductManager.Event event) {
        }

        public void productRemoved(ProductManager.Event event) {
            PixelInfoTopComponent.this.pixelInfoView.reset();
        }
    }

    private class MyPixelPositionListener
    implements PixelPositionListener {
        private MyPixelPositionListener() {
        }

        public void pixelPosChanged(ImageLayer baseImageLayer, int pixelX, int pixelY, int currentLevel, boolean pixelPosValid, MouseEvent e) {
            if (this.isActive()) {
                PixelInfoTopComponent.this.pixelInfoView.updatePixelValues(PixelInfoTopComponent.this.currentView, pixelX, pixelY, currentLevel, pixelPosValid);
            }
        }

        public void pixelPosNotAvailable() {
        }

        private boolean isActive() {
            return PixelInfoTopComponent.this.isVisible() && !PixelInfoTopComponent.this.isSnapToSelectedPin();
        }
    }

    private class PinChangedListener
    implements ProductNodeListener {
        private PinChangedListener() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            if ("pixelPos".equals(event.getPropertyName())) {
                this.handlePinEvent(event);
            }
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            this.handlePinEvent(event);
        }

        public void nodeAdded(ProductNodeEvent event) {
            this.handlePinEvent(event);
        }

        public void nodeRemoved(ProductNodeEvent event) {
            this.handlePinEvent(event);
        }

        private void handlePinEvent(ProductNodeEvent event) {
            if (PixelInfoTopComponent.this.currentView != null && event.getSourceNode() == PixelInfoTopComponent.this.currentView.getSelectedPin()) {
                PixelInfoTopComponent.this.updatePixelInfo();
            }
        }
    }

    private class PinSelectionChangeListener
    implements PropertyChangeListener {
        private PinSelectionChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (PixelInfoTopComponent.this.isVisible()) {
                PixelInfoTopComponent.this.updatePixelInfo();
            }
        }
    }
}

