/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.windows;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.core.util.SystemUtils;

public class CommunityPluginVotePanel
extends JPanel {
    private static final long serialVersionUID = -3282916392722244406L;
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String name;
    private String version;
    private JLabel[] stars = new JLabel[]{new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel()};
    private JLabel votesText = new JLabel();
    private JButton vote = new JButton();

    public CommunityPluginVotePanel() {
        this.buildUI();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 1L) != 0L) {
                    if (CommunityPluginVotePanel.this.name == null || CommunityPluginVotePanel.this.version == null) {
                        return;
                    }
                    for (Container p = e.getChangedParent(); p != null; p = p.getParent()) {
                        if (!p.toString().contains("org.netbeans.modules.autoupdate.ui.UnitTab")) continue;
                        try {
                            ExecutorService executor = Executors.newSingleThreadExecutor();
                            Method m = p.getClass().getMethod("getHelpId", new Class[0]);
                            Object result = m.invoke((Object)p, new Object[0]);
                            AsyncPluginReviewRetriever retriever = new AsyncPluginReviewRetriever(CommunityPluginVotePanel.this.name, CommunityPluginVotePanel.this.version, result.toString(), executor);
                            retriever.executeAsync();
                            break;
                        }
                        catch (NoSuchMethodException executor) {
                            continue;
                        }
                        catch (SecurityException ex) {
                            SystemUtils.LOG.severe("Access error");
                            continue;
                        }
                        catch (IllegalAccessException ex) {
                            SystemUtils.LOG.severe("Invokation error");
                            continue;
                        }
                        catch (IllegalArgumentException ex) {
                            SystemUtils.LOG.severe("Invokation error");
                            continue;
                        }
                        catch (InvocationTargetException ex) {
                            SystemUtils.LOG.severe("Invokation error");
                        }
                    }
                }
            }
        });
    }

    void onPluginDataRetrieved(CommunityPluginData plugin, String helpId) {
        if (plugin != null) {
            for (int i = 0; i < 5; ++i) {
                this.stars[i].setVisible(true);
                if ((double)(i + 1) <= plugin.getRate()) {
                    this.stars[i].setIcon(new ImageIcon(this.getClass().getResource("/org/esa/snap/rcp/icons/FullStar.png")));
                    continue;
                }
                if ((double)i < plugin.getRate()) {
                    this.stars[i].setIcon(new ImageIcon(this.getClass().getResource("/org/esa/snap/rcp/icons/HalfStar.png")));
                    continue;
                }
                this.stars[i].setIcon(new ImageIcon(this.getClass().getResource("/org/esa/snap/rcp/icons/NoStar.png")));
            }
            this.votesText.setText(plugin.getRate() + " / 5.0 (" + plugin.getCount() + " reviews)");
            if (helpId.contains("INSTALLED")) {
                this.vote.setVisible(true);
            }
        } else {
            this.votesText.setText("The plugin " + this.name + ", version " + this.version + " is not available online!");
        }
    }

    private void buildUI() {
        this.setSize(350, 40);
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(1, 0, 1, 1);
        for (int i = 0; i < 5; ++i) {
            c.gridx = i;
            this.add((Component)this.stars[i], c);
            this.stars[i].setIcon(new ImageIcon(this.getClass().getResource("/org/esa/snap/rcp/icons/NoStar.png")));
            this.stars[i].setVisible(false);
        }
        c.gridx = 5;
        c.weightx = 1.0;
        this.add((Component)this.votesText, c);
        this.votesText.setText("Loading Plugin Reviews Data ...");
        c.gridx = 6;
        c.weightx = 0.0;
        c.anchor = 13;
        this.add((Component)this.vote, c);
        this.vote.addActionListener(l -> {
            try {
                URI uri = new URI("https://step.esa.int/main/snap-community-plugins/");
                Desktop d = Desktop.getDesktop();
                d.browse(uri);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.vote.setVisible(false);
        this.vote.setText("Add Review");
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class CommunityPluginData {
        @JsonProperty(value="plugin_id")
        private Integer id;
        @JsonProperty(value="plugin_name")
        private String name;
        @JsonProperty(value="plugin_version")
        private String version;
        @JsonProperty(value="avg_rate")
        private Double rate;
        @JsonProperty(value="count_rate")
        private Integer count;

        private CommunityPluginData() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Double getRate() {
            return this.rate;
        }

        public void setRate(Double rate) {
            this.rate = rate;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class CommunityPluginList {
        private List<CommunityPluginData> results;

        private CommunityPluginList() {
        }

        public List<CommunityPluginData> getResults() {
            return this.results;
        }

        public void setResults(List<CommunityPluginData> results) {
            this.results = results;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class CommunityPluginResponse {
        private boolean success;
        private CommunityPluginList plugins;

        private CommunityPluginResponse() {
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public CommunityPluginList getPlugins() {
            return this.plugins;
        }

        public void setPlugins(CommunityPluginList plugins) {
            this.plugins = plugins;
        }
    }

    private class AsyncPluginReviewRetriever {
        private final String pluginName;
        private final String pluginVersion;
        private final String helpId;
        private final ExecutorService executor;

        public AsyncPluginReviewRetriever(String pluginName, String pluginVersion, String helpId, ExecutorService executor) {
            this.pluginName = pluginName;
            this.pluginVersion = pluginVersion;
            this.helpId = helpId;
            this.executor = executor;
        }

        void executeAsync() {
            this.executor.submit(() -> {
                CommunityPluginResponse pluginsData = this.getPluginsInfo();
                if (pluginsData != null && pluginsData.isSuccess()) {
                    for (CommunityPluginData plugin : pluginsData.getPlugins().getResults()) {
                        String pluginName = plugin.getName();
                        String pluginVersion = plugin.getVersion();
                        if (!CommunityPluginVotePanel.this.name.equals(pluginName) || !CommunityPluginVotePanel.this.version.equals(pluginVersion)) continue;
                        CommunityPluginVotePanel.this.onPluginDataRetrieved(plugin, this.helpId);
                        return;
                    }
                }
                CommunityPluginVotePanel.this.onPluginDataRetrieved(null, this.helpId);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CommunityPluginResponse getPluginsInfo() {
            HttpURLConnection c = null;
            CommunityPluginResponse response = null;
            try {
                URL u = new URL("https://step.esa.int/communityplugins/api/plugins/all/");
                c = (HttpsURLConnection)u.openConnection();
                c.setRequestMethod("GET");
                c.setRequestProperty("Content-length", "0");
                c.setUseCaches(false);
                c.setAllowUserInteraction(false);
                c.setConnectTimeout(5000);
                c.setReadTimeout(5000);
                c.connect();
                int status = c.getResponseCode();
                if (status == 200 || status == 201) {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(c.getInputStream()));
                    StringBuilder sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                    br.close();
                    response = (CommunityPluginResponse)OBJECT_MAPPER.readValue(sb.toString(), (TypeReference)new TypeReference<CommunityPluginResponse>(){});
                }
            }
            catch (IOException ex) {
                SystemUtils.LOG.severe("Error reading server data. ");
                SystemUtils.LOG.info("Error message: " + ex.getMessage());
            }
            finally {
                if (c != null) {
                    try {
                        c.disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
            return response;
        }
    }
}

