/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util.internal;

import com.bc.ceres.core.Assert;
import eu.esa.snap.netbeans.docwin.WindowUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;

public class RasterDataNodeDeleter {
    private static final String INDENT = "    ";

    public static void deleteVectorDataNode(VectorDataNode vectorDataNode) {
        String message;
        Assert.notNull((Object)vectorDataNode);
        Product product = vectorDataNode.getProduct();
        ProductNodeGroup maskGroup = product.getMaskGroup();
        Mask vectorMask = null;
        for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
            Mask mask = (Mask)maskGroup.get(i);
            if (mask.getImageType() != Mask.VectorDataType.INSTANCE || Mask.VectorDataType.getVectorData((Mask)mask) != vectorDataNode) continue;
            vectorMask = mask;
            break;
        }
        if (vectorMask != null) {
            List<RasterDataNode> virtualBands = RasterDataNodeDeleter.getReferencedVirtualBands(vectorMask);
            List<RasterDataNode> validMaskNodes = RasterDataNodeDeleter.getReferencedValidMasks(vectorMask);
            List<RasterDataNode> masks = RasterDataNodeDeleter.getReferencedMasks(vectorMask);
            VectorDataNode[] nodes = new VectorDataNode[]{vectorDataNode};
            message = RasterDataNodeDeleter.formatPromptMessage("Geometry", (ProductNode[])nodes, virtualBands, validMaskNodes, masks);
        } else {
            message = MessageFormat.format("Do you really want to delete the geometry ''{0}''?\nThis action cannot be undone.\n\n", vectorDataNode.getName());
        }
        Dialogs.Answer answer = Dialogs.requestDecision("Delete Vector Data", message, true, null);
        if (answer == Dialogs.Answer.YES) {
            product.getVectorDataGroup().remove((ProductNode)vectorDataNode);
        }
    }

    public static void deleteRasterDataNodes(RasterDataNode[] rasterNodes) {
        Assert.notNull((Object)rasterNodes);
        if (rasterNodes.length == 0) {
            return;
        }
        HashSet<RasterDataNode> virtualBandsSet = new HashSet<RasterDataNode>();
        HashSet<RasterDataNode> validMaskNodesSet = new HashSet<RasterDataNode>();
        HashSet<RasterDataNode> masksSet = new HashSet<RasterDataNode>();
        for (RasterDataNode raster : rasterNodes) {
            virtualBandsSet.addAll(RasterDataNodeDeleter.getReferencedVirtualBands(raster));
            validMaskNodesSet.addAll(RasterDataNodeDeleter.getReferencedValidMasks(raster));
            masksSet.addAll(RasterDataNodeDeleter.getReferencedMasks(raster));
        }
        for (RasterDataNode raster : rasterNodes) {
            virtualBandsSet.remove(raster);
            validMaskNodesSet.remove(raster);
            masksSet.remove(raster);
        }
        String typeName = RasterDataNodeDeleter.getTypeName(rasterNodes);
        String message = RasterDataNodeDeleter.formatPromptMessage(typeName, (ProductNode[])rasterNodes, virtualBandsSet, validMaskNodesSet, masksSet);
        RasterDataNodeDeleter.deleteRasterDataNodesImpl(rasterNodes, message);
    }

    public static void deleteRasterDataNode(RasterDataNode raster) {
        Assert.notNull((Object)raster);
        List<RasterDataNode> virtualBands = RasterDataNodeDeleter.getReferencedVirtualBands(raster);
        List<RasterDataNode> validMaskNodes = RasterDataNodeDeleter.getReferencedValidMasks(raster);
        List<RasterDataNode> masks = RasterDataNodeDeleter.getReferencedMasks(raster);
        RasterDataNode[] rasters = new RasterDataNode[]{raster};
        String typeName = RasterDataNodeDeleter.getTypeName(rasters);
        String message = RasterDataNodeDeleter.formatPromptMessage(typeName, (ProductNode[])rasters, virtualBands, validMaskNodes, masks);
        RasterDataNodeDeleter.deleteRasterDataNodesImpl(rasters, message);
    }

    private static void deleteRasterDataNodesImpl(RasterDataNode[] rasters, String message) {
        Dialogs.Answer answer = Dialogs.requestDecision("Delete Raster Data", message, true, null);
        if (answer == Dialogs.Answer.YES) {
            for (RasterDataNode raster : rasters) {
                WindowUtilities.getOpened(ProductSceneViewTopComponent.class).filter(topComponent -> raster == topComponent.getView().getRaster()).forEach(new Consumer<ProductSceneViewTopComponent>(){

                    @Override
                    public void accept(ProductSceneViewTopComponent productSceneViewTopComponent) {
                        productSceneViewTopComponent.close();
                    }
                });
                if (raster.hasRasterData()) {
                    raster.unloadRasterData();
                }
                Product product = raster.getProduct();
                if (raster instanceof Mask) {
                    TiePointGrid[] tiePointGrids;
                    Mask mask = (Mask)raster;
                    product.getMaskGroup().remove((ProductNode)mask);
                    for (Band band : product.getBands()) {
                        RasterDataNodeDeleter.deleteMaskFromGroup((ProductNodeGroup<Mask>)band.getOverlayMaskGroup(), mask);
                    }
                    for (TiePointGrid tiePointGrid : tiePointGrids = product.getTiePointGrids()) {
                        RasterDataNodeDeleter.deleteMaskFromGroup((ProductNodeGroup<Mask>)tiePointGrid.getOverlayMaskGroup(), mask);
                    }
                    Mask.ImageType imageType = mask.getImageType();
                    if (imageType != Mask.VectorDataType.INSTANCE) continue;
                    VectorDataNode vectorDataNode = Mask.VectorDataType.getVectorData((Mask)mask);
                    product.getVectorDataGroup().remove((ProductNode)vectorDataNode);
                    continue;
                }
                if (raster instanceof Band) {
                    product.removeBand((Band)raster);
                    continue;
                }
                if (!(raster instanceof TiePointGrid)) continue;
                product.removeTiePointGrid((TiePointGrid)raster);
            }
        }
    }

    private static String formatPromptMessage(String description, ProductNode[] nodes, Collection<RasterDataNode> virtualBands, Collection<RasterDataNode> validMaskNodes, Collection<RasterDataNode> masks) {
        StringBuilder message = new StringBuilder();
        if (nodes.length > 1) {
            message.append(MessageFormat.format("Do you really want to delete the following {0}:\n", description));
            for (ProductNode node : nodes) {
                message.append(INDENT);
                message.append(node.getName());
                message.append("\n");
            }
        } else {
            String name = nodes[0].getName();
            message.append(MessageFormat.format("Do you really want to delete the {0} ''{1}''?\n", description, name));
        }
        message.append("This action cannot be undone.\n\n");
        if (!(virtualBands.isEmpty() && validMaskNodes.isEmpty() && masks.isEmpty())) {
            if (nodes.length > 1) {
                message.append(MessageFormat.format("The {0} to be deleted are referenced by\n", description));
            } else {
                message.append(MessageFormat.format("The {0} to be deleted is referenced by\n", description));
            }
        }
        if (!virtualBands.isEmpty()) {
            message.append("the expression of virtual band(s):\n");
            for (RasterDataNode virtualBand : virtualBands) {
                message.append(INDENT);
                message.append(virtualBand.getName());
                message.append("\n");
            }
        }
        if (!validMaskNodes.isEmpty()) {
            message.append("the valid-mask expression of band(s) or tie-point grid(s)\n");
            for (RasterDataNode validMaskNode : validMaskNodes) {
                message.append(INDENT);
                message.append(validMaskNode.getName());
                message.append("\n");
            }
        }
        if (!masks.isEmpty()) {
            message.append("the mask(s):\n");
            for (RasterDataNode mask : masks) {
                message.append(INDENT);
                message.append(mask.getName());
                message.append("\n");
            }
        }
        return message.toString();
    }

    private static String getTypeName(RasterDataNode[] rasters) {
        Object description = "";
        if (rasters[0] instanceof Mask) {
            description = "mask";
        } else if (rasters[0] instanceof Band) {
            description = "band";
        } else if (rasters[0] instanceof TiePointGrid) {
            description = "tie-point grid";
        }
        if (rasters.length > 1) {
            description = (String)description + "s";
        }
        return description;
    }

    private static void deleteMaskFromGroup(ProductNodeGroup<Mask> group, Mask mask) {
        if (group.contains((ProductNode)mask)) {
            group.remove((ProductNode)mask);
        }
    }

    private static List<RasterDataNode> getReferencedValidMasks(RasterDataNode node) {
        Product product = node.getProduct();
        ArrayList<RasterDataNode> rasterList = new ArrayList<RasterDataNode>();
        if (product != null) {
            int i;
            for (i = 0; i < product.getNumBands(); ++i) {
                Band band = product.getBandAt(i);
                if (band == node || !RasterDataNodeDeleter.isNodeReferencedByExpression(node, band.getValidPixelExpression())) continue;
                rasterList.add((RasterDataNode)band);
            }
            for (i = 0; i < product.getNumTiePointGrids(); ++i) {
                TiePointGrid tiePointGrid = product.getTiePointGridAt(i);
                if (tiePointGrid == node || !RasterDataNodeDeleter.isNodeReferencedByExpression(node, tiePointGrid.getValidPixelExpression())) continue;
                rasterList.add((RasterDataNode)tiePointGrid);
            }
        }
        return rasterList;
    }

    private static List<RasterDataNode> getReferencedMasks(RasterDataNode node) {
        Product product = node.getProduct();
        ArrayList<RasterDataNode> rasterList = new ArrayList<RasterDataNode>();
        if (product != null) {
            Mask[] masks;
            ProductNodeGroup maskGroup = product.getMaskGroup();
            for (Mask mask : masks = (Mask[])maskGroup.toArray((ProductNode[])new Mask[maskGroup.getNodeCount()])) {
                String expression = mask.getImageType() == Mask.BandMathsType.INSTANCE ? Mask.BandMathsType.getExpression((Mask)mask) : (mask.getImageType() == Mask.RangeType.INSTANCE ? Mask.RangeType.getRasterName((Mask)mask) : null);
                if (!RasterDataNodeDeleter.isNodeReferencedByExpression(node, expression)) continue;
                rasterList.add((RasterDataNode)mask);
            }
        }
        return rasterList;
    }

    private static List<RasterDataNode> getReferencedVirtualBands(RasterDataNode node) {
        Product product = node.getProduct();
        ArrayList<RasterDataNode> rasterList = new ArrayList<RasterDataNode>();
        if (product != null) {
            for (int i = 0; i < product.getNumBands(); ++i) {
                VirtualBand virtualBand;
                Band band = product.getBandAt(i);
                if (!(band instanceof VirtualBand) || !RasterDataNodeDeleter.isNodeReferencedByExpression(node, (virtualBand = (VirtualBand)band).getExpression())) continue;
                rasterList.add((RasterDataNode)virtualBand);
            }
        }
        return rasterList;
    }

    private static boolean isNodeReferencedByExpression(RasterDataNode node, String expression) {
        if (expression == null || expression.trim().isEmpty()) {
            return false;
        }
        return expression.matches(".*\\b" + node.getName() + "\\b.*");
    }
}

