/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Cancellable;

public class ProgressHandleMonitor
implements ProgressMonitor,
Cancellable {
    private static final int F = 100;
    private ProgressHandle progressHandle;
    private Cancellable cancellable;
    private boolean canceled;
    private int totalWorkUnits;
    private int currentWorkUnits;
    private double currentWorkUnitsRational;

    public static ProgressHandleMonitor create(String displayName) {
        return ProgressHandleMonitor.create(displayName, null);
    }

    public static ProgressHandleMonitor create(String displayName, Cancellable cancellable) {
        ProgressHandleMonitor progressMonitor = new ProgressHandleMonitor(cancellable);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)displayName, (Cancellable)progressMonitor);
        progressMonitor.setProgressHandle(progressHandle);
        return progressMonitor;
    }

    public ProgressHandleMonitor(ProgressHandle progressHandle) {
        Assert.notNull((Object)progressHandle);
        this.progressHandle = progressHandle;
    }

    private ProgressHandleMonitor(Cancellable cancellable) {
        this.cancellable = cancellable;
    }

    public ProgressHandle getProgressHandle() {
        return this.progressHandle;
    }

    public void setProgressHandle(ProgressHandle progressHandle) {
        Assert.notNull((Object)progressHandle);
        this.progressHandle = progressHandle;
    }

    public void beginTask(String taskName, int totalWork) {
        this.totalWorkUnits = totalWork < 0 ? 0 : 100 * totalWork;
        this.currentWorkUnits = 0;
        this.currentWorkUnitsRational = 0.0;
        if (this.progressHandle == null) {
            this.progressHandle = ProgressHandleFactory.createHandle((String)taskName, (Cancellable)this);
            this.progressHandle.start(this.totalWorkUnits);
        } else {
            try {
                this.progressHandle.start(this.totalWorkUnits);
            }
            catch (IllegalStateException e) {
                this.progressHandle.switchToDeterminate(this.totalWorkUnits);
            }
            this.progressHandle.setDisplayName(taskName);
        }
    }

    public void done() {
        Assert.notNull((Object)this.progressHandle);
        this.progressHandle.finish();
    }

    public void internalWorked(double work) {
        this.currentWorkUnitsRational += 100.0 * work;
        int i = (int)this.currentWorkUnitsRational;
        if (i > this.currentWorkUnits) {
            this.currentWorkUnits = i;
            this.progressHandle.progress(this.currentWorkUnits);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void setTaskName(String taskName) {
        Assert.notNull((Object)this.progressHandle);
        this.progressHandle.setDisplayName(taskName);
    }

    public void setSubTaskName(String subTaskName) {
        Assert.notNull((Object)this.progressHandle);
        this.progressHandle.progress(subTaskName);
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    public boolean cancel() {
        if (this.cancellable != null) {
            this.setCanceled(this.cancellable.cancel());
        } else {
            this.setCanceled(true);
        }
        return this.isCanceled();
    }
}

