/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util;

import java.awt.Cursor;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.VersionChecker;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.BrowserUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.openide.awt.CheckForUpdatesProvider;
import org.openide.util.Lookup;

public class DesktopVersionCheck {
    private static final String STEP_WEB_PAGE = SystemUtils.getApplicationHomepageUrl();
    private static final String MSG_UPDATE_INFO = "<html>A new SNAP version is available for download!<br>Currently installed %s, available is %s.<br>Please visit the SNAP home page at";
    private static final VersionChecker VERSION_CHECKER = VersionChecker.getInstance();

    private DesktopVersionCheck() {
    }

    public static class OnStartup
    implements Runnable {
        @Override
        public void run() {
            if (!SnapApp.getDefault().getAppContext().getApplicationWindow().isVisible()) {
                return;
            }
            if (VERSION_CHECKER.mustCheck() && VERSION_CHECKER.checkForNewRelease()) {
                VERSION_CHECKER.setChecked();
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 1));
                String localVersion = String.valueOf(VERSION_CHECKER.getLocalVersion());
                String remoteVersion = String.valueOf(VERSION_CHECKER.getRemoteVersion());
                panel.add(new JLabel(String.format(DesktopVersionCheck.MSG_UPDATE_INFO, localVersion, remoteVersion)));
                JLabel LinkLabel = new JLabel("<html><a href=\"" + STEP_WEB_PAGE + "\">" + STEP_WEB_PAGE + "</a>");
                LinkLabel.setCursor(new Cursor(12));
                LinkLabel.addMouseListener(new BrowserUtils.URLClickAdaptor(STEP_WEB_PAGE));
                panel.add(LinkLabel);
                JOptionPane.showMessageDialog(null, panel);
                return;
            }
            String message = "You are running the latest major version " + VERSION_CHECKER.getLocalVersion() + " of SNAP.\nPlease check regularly for new plugin updates (Help -> Check for Updates...) \nto get the best SNAP experience.\n\nPress 'Yes', if you want to check for plugin updates now.\n\n";
            Dialogs.Answer decision = Dialogs.requestDecision("SNAP Update", message, false, "optional.version.check.onstartup");
            if (Dialogs.Answer.YES.equals((Object)decision)) {
                CheckForUpdatesProvider checkForUpdatesProvider = (CheckForUpdatesProvider)Lookup.getDefault().lookup(CheckForUpdatesProvider.class);
                checkForUpdatesProvider.openCheckForUpdatesWizard(true);
            }
        }
    }
}

