/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.esa.snap.rcp.util.ContextGlobalExtender;
import org.netbeans.modules.openide.windows.GlobalActionContextImpl;
import org.openide.util.ContextGlobalProvider;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ContextGlobalExtenderImpl
implements ContextGlobalProvider,
ContextGlobalExtender {
    private static final Logger LOG = Logger.getLogger(ContextGlobalExtenderImpl.class.getName());
    private Lookup proxyLookup;
    private final InstanceContent constantContent = new InstanceContent();
    private final Map<Object, Object> constantInstances = new LinkedHashMap<Object, Object>();

    @Override
    public synchronized Object get(Object key) {
        return this.constantInstances.get(key);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        Object oldValue = this.constantInstances.get(key);
        if (oldValue != value) {
            this.constantInstances.put(key, value);
            if (oldValue != null) {
                this.constantContent.remove(oldValue);
            }
            this.constantContent.add(value);
            LOG.info("added: key = " + key + ", value = " + value + ", oldValue = " + oldValue);
        }
        return oldValue;
    }

    @Override
    public synchronized Object remove(Object key) {
        Object oldValue = this.constantInstances.remove(key);
        if (oldValue != null) {
            this.constantContent.remove(oldValue);
        }
        LOG.info("removed: key = " + key + ", oldValue = " + oldValue);
        return oldValue;
    }

    public Lookup createGlobalContext() {
        if (this.proxyLookup == null) {
            this.proxyLookup = new ProxyLookup(new Lookup[]{new GlobalActionContextImpl().createGlobalContext(), Lookups.singleton((Object)this), new AbstractLookup((AbstractLookup.Content)this.constantContent)});
        }
        return this.proxyLookup;
    }
}

