/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util;

import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;

public class BrowserUtils {
    public static void openInBrowser(URI uri) {
        boolean desktopSupported = Desktop.isDesktopSupported();
        boolean browseSupported = Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
        if (desktopSupported && browseSupported) {
            try {
                Desktop.getDesktop().browse(uri);
            }
            catch (Throwable t) {
                Dialogs.showError(String.format("Failed to open URL:\n%s:\n%s", uri, t.getMessage()));
            }
        } else {
            SystemUtils.copyToClipboard((String)uri.toString());
            Dialogs.showInformation("The URL has been copied to your Clipboard\n");
        }
    }

    public static class URLClickAdaptor
    extends MouseAdapter {
        private final String address;

        public URLClickAdaptor(String address) {
            this.address = address;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            try {
                BrowserUtils.openInBrowser(new URI(this.address));
            }
            catch (URISyntaxException e) {
                SnapApp.getDefault().handleError("Unable to follow link", e);
            }
        }
    }
}

