/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import org.esa.snap.rcp.SnapApp;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class BooleanPreferenceKeyAction
extends AbstractAction
implements PreferenceChangeListener,
Presenter.Toolbar,
Presenter.Menu,
Presenter.Popup {
    private final String preferenceKey;
    private final boolean defaultValue;

    protected BooleanPreferenceKeyAction(String preferenceKey) {
        this(preferenceKey, false);
    }

    protected BooleanPreferenceKeyAction(String preferenceKey, boolean defaultValue) {
        this.preferenceKey = preferenceKey;
        this.defaultValue = defaultValue;
        Preferences preferences = SnapApp.getDefault().getPreferences();
        preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)preferences));
        this.setSelected(this.getPreferenceValue());
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setPreferenceValue(this.isSelected());
    }

    public JMenuItem getMenuPresenter() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this);
        menuItem.setIcon(null);
        return menuItem;
    }

    public JMenuItem getPopupPresenter() {
        return this.getMenuPresenter();
    }

    public Component getToolbarPresenter() {
        JToggleButton toggleButton = new JToggleButton(this);
        toggleButton.setText(null);
        return toggleButton;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (this.getPreferenceKey().equals(evt.getKey())) {
            this.setSelected(this.getPreferenceValue());
        }
    }

    private boolean getPreferenceValue() {
        return SnapApp.getDefault().getPreferences().getBoolean(this.getPreferenceKey(), this.defaultValue);
    }

    private void setPreferenceValue(boolean selected) {
        SnapApp.getDefault().getPreferences().putBoolean(this.getPreferenceKey(), selected);
    }
}

