/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.sync;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.swing.LayerCanvasModel;
import com.bc.ceres.grender.Viewport;
import eu.esa.snap.netbeans.docwin.WindowUtilities;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

public class ImageViewSynchronizer
implements Runnable {
    public static final String PROPERTY_KEY_AUTO_SYNC_VIEWS = "auto_sync_image_views";
    private ProductSceneView lastView;
    private LayerCanvasModelChangeHandler layerCanvasModelChangeHandler;

    @Override
    public void run() {
        this.layerCanvasModelChangeHandler = new LayerCanvasModelChangeHandler();
        Preferences preferences = SnapApp.getDefault().getPreferences();
        preferences.addPreferenceChangeListener(new ImageViewSynchronizerPreferenceChangeListener());
        Lookup.Result lookupResult = Utilities.actionsGlobalContext().lookupResult(ProductSceneView.class);
        lookupResult.addLookupListener((LookupListener)new ImageViewSynchronizerLookupListener());
        this.syncImageViewsWithSelectedView();
    }

    private void syncImageViewsWithSelectedView() {
        ProductSceneView currentSceneView = SnapApp.getDefault().getSelectedProductSceneView();
        if (currentSceneView != null) {
            this.syncImageViews(currentSceneView);
        }
    }

    private void syncImageViews(ProductSceneView currentSceneView) {
        if (this.isActive()) {
            WindowUtilities.getOpened(ProductSceneViewTopComponent.class).forEach(topComponent -> {
                ProductSceneView oldSceneView = topComponent.getView();
                if (oldSceneView != currentSceneView) {
                    currentSceneView.synchronizeViewportIfPossible(oldSceneView);
                }
            });
        }
    }

    private boolean isActive() {
        return SnapApp.getDefault().getPreferences().getBoolean(PROPERTY_KEY_AUTO_SYNC_VIEWS, false);
    }

    private class ImageViewSynchronizerLookupListener
    implements LookupListener {
        private ImageViewSynchronizerLookupListener() {
        }

        public void resultChanged(LookupEvent ev) {
            ProductSceneView newView = SnapApp.getDefault().getSelectedProductSceneView();
            if (ImageViewSynchronizer.this.lastView != newView) {
                ProductSceneView oldView = ImageViewSynchronizer.this.lastView;
                if (oldView != null && oldView.getLayerCanvas() != null) {
                    oldView.getLayerCanvas().getModel().removeChangeListener((LayerCanvasModel.ChangeListener)ImageViewSynchronizer.this.layerCanvasModelChangeHandler);
                }
                ImageViewSynchronizer.this.lastView = newView;
                if (ImageViewSynchronizer.this.lastView != null) {
                    ImageViewSynchronizer.this.syncImageViews(ImageViewSynchronizer.this.lastView);
                    if (ImageViewSynchronizer.this.lastView.getLayerCanvas() != null) {
                        ImageViewSynchronizer.this.lastView.getLayerCanvas().getModel().addChangeListener((LayerCanvasModel.ChangeListener)ImageViewSynchronizer.this.layerCanvasModelChangeHandler);
                    }
                }
            }
        }
    }

    private class ImageViewSynchronizerPreferenceChangeListener
    implements PreferenceChangeListener {
        private ImageViewSynchronizerPreferenceChangeListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            if (ImageViewSynchronizer.PROPERTY_KEY_AUTO_SYNC_VIEWS.equals(evt.getKey())) {
                ImageViewSynchronizer.this.syncImageViewsWithSelectedView();
            }
        }
    }

    private class LayerCanvasModelChangeHandler
    implements LayerCanvasModel.ChangeListener {
        private LayerCanvasModelChangeHandler() {
        }

        public void handleLayerPropertyChanged(Layer layer, PropertyChangeEvent event) {
        }

        public void handleLayerDataChanged(Layer layer, Rectangle2D modelRegion) {
        }

        public void handleLayersAdded(Layer parentLayer, Layer[] childLayers) {
        }

        public void handleLayersRemoved(Layer parentLayer, Layer[] childLayers) {
        }

        public void handleViewportChanged(Viewport viewport, boolean orientationChanged) {
            ImageViewSynchronizer.this.syncImageViewsWithSelectedView();
        }
    }
}

