/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.sync;

import com.bc.ceres.glayer.swing.LayerCanvas;
import eu.esa.snap.netbeans.docwin.WindowUtilities;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.rcp.sync.ImageCursorOverlay;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.ui.product.ProductSceneView;

public class DefaultCursorSynchronizer {
    private Map<ProductSceneView, ImageCursorOverlay> psvOverlayMap = new HashMap<ProductSceneView, ImageCursorOverlay>();
    private boolean enabled = false;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            if (enabled) {
                this.initPsvOverlayMap();
            } else {
                this.clearPsvOverlayMap();
            }
            this.enabled = enabled;
        }
    }

    public void updateCursorOverlays(GeoPos geoPos) {
        if (!this.isEnabled()) {
            return;
        }
        for (Map.Entry<ProductSceneView, ImageCursorOverlay> entry : this.psvOverlayMap.entrySet()) {
            ProductSceneView view = entry.getKey();
            ImageCursorOverlay overlay = entry.getValue();
            if (overlay == null) {
                overlay = new ImageCursorOverlay(view, geoPos);
                this.psvOverlayMap.put(view, overlay);
                view.getLayerCanvas().addOverlay((LayerCanvas.Overlay)overlay);
                continue;
            }
            overlay.setGeoPosition(geoPos);
            view.getLayerCanvas().repaint();
        }
    }

    private void initPsvOverlayMap() {
        WindowUtilities.getOpened(ProductSceneViewTopComponent.class).map(ProductSceneViewTopComponent::getView).forEach(this::addPPL);
    }

    private void clearPsvOverlayMap() {
        for (Map.Entry<ProductSceneView, ImageCursorOverlay> entry : this.psvOverlayMap.entrySet()) {
            ProductSceneView view = entry.getKey();
            view.getLayerCanvas().removeOverlay((LayerCanvas.Overlay)entry.getValue());
        }
        this.psvOverlayMap.clear();
    }

    private void addPPL(ProductSceneView view) {
        GeoCoding geoCoding = view.getProduct().getSceneGeoCoding();
        if (geoCoding != null && geoCoding.canGetPixelPos()) {
            this.psvOverlayMap.put(view, null);
        }
    }
}

