/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.subset;

import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.common.SubsetOp;
import org.esa.snap.core.subset.AbstractSubsetRegion;
import org.esa.snap.core.subset.PixelSubsetRegion;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.subset.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.product.ProductSubsetDialog;

public class CreateSubsetAction
extends AbstractAction {
    static int subsetNumber;
    private final ProductNode sourceNode;

    public CreateSubsetAction(ProductNode sourceNode) {
        this.sourceNode = sourceNode;
    }

    @Override
    public void actionPerformed(ActionEvent ignored) {
        Product product = this.sourceNode.getProduct();
        RasterDataNode rasterDataNode = null;
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        if (view != null && view.getProduct() == product && view.getRaster() != null) {
            rasterDataNode = view.getRaster();
        }
        if (product != null) {
            CreateSubsetAction.createSubset(product, this.getInitialBounds(product), rasterDataNode);
        }
    }

    public static void createSubset(Product sourceProduct, Rectangle bounds, RasterDataNode rdn) {
        String subsetName = "subset_" + subsetNumber + "_of_" + sourceProduct.getName();
        ProductSubsetDef initSubset = new ProductSubsetDef();
        initSubset.setSubsetRegion((AbstractSubsetRegion)new PixelSubsetRegion(bounds, 0));
        if (sourceProduct.isMultiSize() && rdn != null) {
            initSubset.setRegionMap(SubsetOp.computeRegionMap((Rectangle)initSubset.getRegion(), (String)rdn.getName(), (Product)sourceProduct, null));
        } else if (sourceProduct.isMultiSize()) {
            initSubset.setRegionMap(SubsetOp.computeRegionMap((Rectangle)initSubset.getRegion(), (Product)sourceProduct, null));
        }
        initSubset.setNodeNames(sourceProduct.getBandNames());
        initSubset.addNodeNames(sourceProduct.getTiePointGridNames());
        initSubset.setIgnoreMetadata(false);
        ProductSubsetDialog subsetDialog = new ProductSubsetDialog((Window)SnapApp.getDefault().getMainFrame(), sourceProduct, initSubset);
        if (subsetDialog.show() != 1) {
            return;
        }
        ProductSubsetDef subsetDef = subsetDialog.getProductSubsetDef();
        if (subsetDef == null) {
            Dialogs.showInformation(Bundle.CTL_CreateSubsetFromViewAction_Title(), "No product subset created.", null);
            return;
        }
        try {
            Product subset = sourceProduct.createSubset(subsetDef, subsetName, sourceProduct.getDescription());
            SnapApp.getDefault().getProductManager().addProduct(subset);
            ++subsetNumber;
        }
        catch (Exception e) {
            String msg = "An error occurred while creating the product subset:\n" + e.getMessage();
            SnapApp.getDefault().handleError(msg, e);
        }
    }

    public static void createSubset(Product sourceProduct, Rectangle bounds) {
        CreateSubsetAction.createSubset(sourceProduct, bounds, null);
    }

    private Rectangle getInitialBounds(Product product) {
        Rectangle bounds = null;
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        bounds = view != null && view.getProduct() == product ? view.getVisibleImageBounds() : new Rectangle(0, 0, product.getSceneRasterWidth(), product.getSceneRasterHeight());
        return bounds;
    }
}

