/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.status;

import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.swing.LayerCanvas;
import eu.esa.snap.netbeans.docwin.DocumentWindowManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.math.SphericalDistance;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.PixelPositionListener;
import org.esa.snap.ui.product.ProductSceneView;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.openide.awt.StatusLineElementProvider;

public class PixelPosStatusLineElementProvider
implements StatusLineElementProvider,
DocumentWindowManager.Listener<Object, ProductSceneView>,
PixelPositionListener,
PreferenceChangeListener {
    private static final String GEO_POS_FORMAT = "Lat %8s  Lon %8s";
    private static final String PIXEL_POS_FORMAT = "X %6s  Y %6s";
    private static final String ZOOM_LEVEL_FORMAT = "Zoom %s  Level %s";
    private static final String PIXEL_SIZE_FORMAT = "Pixel Spacing: %s m %s m";
    private final JLabel zoomLevelLabel;
    private final JLabel geoPosLabel;
    private final JLabel pixelPosLabel;
    private final JLabel pixelSpacingLabel;
    private final JLabel scaleLabel;
    private final JPanel panel;
    private boolean showPixelOffsetDecimals;
    private boolean showGeoPosOffsetDecimals;
    private final DecimalFormatSymbols formatSymbols;
    private final DecimalFormat decimalFormat;
    private double longitudeResolutionInMeter;
    private double latitudeResolutionInMeter;

    public PixelPosStatusLineElementProvider() {
        DocumentWindowManager.getDefault().addListener(DocumentWindowManager.Predicate.view(ProductSceneView.class), (DocumentWindowManager.Listener)this);
        SnapApp.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.updateSettings();
        this.pixelPosLabel = new JLabel();
        this.pixelPosLabel.setPreferredSize(new Dimension(120, 20));
        this.pixelPosLabel.setHorizontalAlignment(0);
        this.geoPosLabel = new JLabel();
        this.geoPosLabel.setPreferredSize(new Dimension(200, 20));
        this.geoPosLabel.setHorizontalAlignment(0);
        this.zoomLevelLabel = new JLabel();
        this.zoomLevelLabel.setPreferredSize(new Dimension(150, 20));
        this.zoomLevelLabel.setHorizontalAlignment(0);
        this.pixelSpacingLabel = new JLabel();
        this.pixelSpacingLabel.setPreferredSize(new Dimension(230, 20));
        this.pixelSpacingLabel.setHorizontalAlignment(0);
        this.scaleLabel = new JLabel();
        this.scaleLabel.setPreferredSize(new Dimension(180, 20));
        this.scaleLabel.setHorizontalAlignment(0);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 2));
        this.panel.add(Box.createHorizontalGlue());
        this.panel.add(new JSeparator(1));
        this.panel.add(this.pixelPosLabel);
        this.panel.add(new JSeparator(1));
        this.panel.add(this.geoPosLabel);
        this.panel.add(new JSeparator(1));
        this.panel.add(this.zoomLevelLabel);
        this.panel.add(new JSeparator(1));
        this.panel.add(this.pixelSpacingLabel);
        this.panel.add(new JSeparator(1));
        this.panel.add(this.scaleLabel);
        this.formatSymbols = new DecimalFormatSymbols();
        this.formatSymbols.setDecimalSeparator('.');
        this.decimalFormat = new DecimalFormat("#.##", this.formatSymbols);
        this.longitudeResolutionInMeter = Double.NaN;
        this.latitudeResolutionInMeter = Double.NaN;
    }

    private void computeResolution() {
        this.longitudeResolutionInMeter = Double.NaN;
        this.latitudeResolutionInMeter = Double.NaN;
        ProductSceneView productSceneView = SnapApp.getDefault().getSelectedProductSceneView();
        if (productSceneView == null) {
            return;
        }
        RasterDataNode rasterDataNode = productSceneView.getRaster();
        if (rasterDataNode == null) {
            return;
        }
        GeoCoding geoCoding = rasterDataNode.getGeoCoding();
        if (geoCoding == null) {
            return;
        }
        if (geoCoding instanceof CrsGeoCoding) {
            this.longitudeResolutionInMeter = rasterDataNode.getImageToModelTransform().getScaleX();
            this.latitudeResolutionInMeter = Math.abs(rasterDataNode.getImageToModelTransform().getScaleY());
        } else {
            int width = rasterDataNode.getRasterWidth();
            int height = rasterDataNode.getRasterHeight();
            int minWidth = 12;
            if (width > minWidth && height > 2) {
                DefaultGeographicCRS wgs84 = DefaultGeographicCRS.WGS84;
                Ellipsoid ellipsoid = wgs84.getDatum().getEllipsoid();
                double meanEarthRadiusM = (ellipsoid.getSemiMajorAxis() + ellipsoid.getSemiMinorAxis()) * 0.5;
                int x1 = (int)((double)width * 0.5);
                int y1 = (int)((double)height * 0.5);
                GeoPos geoPos = geoCoding.getGeoPos(new PixelPos((double)x1, (double)y1), null);
                double resLon = geoPos.getLon();
                double resLat = geoPos.getLat();
                SphericalDistance spherDist = new SphericalDistance(resLon, resLat);
                GeoPos geoPosY = geoCoding.getGeoPos(new PixelPos((double)x1, (double)(y1 + 1)), null);
                double resLonY = geoPosY.getLon();
                double resLatY = geoPosY.getLat();
                double latitudeDistance = spherDist.distance(resLonY, resLatY);
                this.latitudeResolutionInMeter = latitudeDistance * meanEarthRadiusM;
                this.longitudeResolutionInMeter = this.computeGeocodingAccordingDuplicatedValue(geoCoding, width, x1, y1, resLon, spherDist, meanEarthRadiusM);
            }
        }
    }

    private double computeGeocodingAccordingDuplicatedValue(GeoCoding geoCoding, int width, int xRef, int yRef, double resLon, SphericalDistance spherDist, double meanEarthRadiusM) {
        double resLonX;
        GeoPos geoPosX;
        int step = 5;
        int distanceMax = 20;
        int diffPix = step;
        boolean haveAResolution = false;
        while (!haveAResolution && diffPix < distanceMax && xRef + diffPix < width - 1) {
            geoPosX = geoCoding.getGeoPos(new PixelPos((double)(xRef + diffPix), (double)yRef), null);
            resLonX = geoPosX.getLon();
            if (resLon != resLonX) {
                haveAResolution = true;
                continue;
            }
            diffPix += step;
        }
        geoPosX = geoCoding.getGeoPos(new PixelPos((double)(xRef + diffPix), (double)yRef), null);
        resLonX = geoPosX.getLon();
        double resLatX = geoPosX.getLat();
        double longitudeDistance = spherDist.distance(resLonX, resLatX);
        return longitudeDistance * meanEarthRadiusM / (double)diffPix;
    }

    public Component getStatusLineElement() {
        return this.panel;
    }

    public void pixelPosChanged(ImageLayer imageLayer, int pixelX, int pixelY, int currentLevel, boolean pixelPosValid, MouseEvent e) {
        if (pixelPosValid) {
            double v;
            AffineTransform i2mTransform = imageLayer.getImageToModelTransform(currentLevel);
            Point2D modelP = i2mTransform.transform(new Point2D.Double((double)pixelX + 0.5, (double)pixelY + 0.5), null);
            AffineTransform m2iTransform = imageLayer.getModelToImageTransform();
            Point2D imageP = m2iTransform.transform(modelP, null);
            PixelPos pixelPos = new PixelPos(imageP.getX(), imageP.getY());
            ProductSceneView productSceneView = SnapApp.getDefault().getSelectedProductSceneView();
            if (productSceneView == null) {
                this.setDefault();
                return;
            }
            RasterDataNode rasterDataNode = productSceneView.getRaster();
            if (rasterDataNode == null) {
                this.setDefault();
                return;
            }
            GeoCoding geoCoding = rasterDataNode.getGeoCoding();
            if (geoCoding == null) {
                this.setDefault();
                return;
            }
            GeoPos geoPos = geoCoding.getGeoPos(pixelPos, null);
            if (this.showGeoPosOffsetDecimals) {
                this.geoPosLabel.setText(String.format("Lat %.5f  Lon %.5f", geoPos.getLat(), geoPos.getLon()));
            } else {
                this.geoPosLabel.setText(String.format(GEO_POS_FORMAT, geoPos.getLatString(), geoPos.getLonString()));
            }
            if (this.showPixelOffsetDecimals) {
                this.pixelPosLabel.setText(String.format(PIXEL_POS_FORMAT, imageP.getX(), imageP.getY()));
            } else {
                this.pixelPosLabel.setText(String.format(PIXEL_POS_FORMAT, (int)Math.floor(imageP.getX()), (int)Math.floor(imageP.getY())));
            }
            LayerCanvas layerCanvas = (LayerCanvas)e.getSource();
            double zoomFactor = layerCanvas.getViewport().getZoomFactor();
            String scaleStr = zoomFactor > 1.0 ? ((double)((int)(v = (double)Math.round(10.0 * zoomFactor) / 10.0)) == v ? (double)((int)v) : v) + ":1" : "1:" + ((double)((int)(v = (double)Math.round(10.0 / zoomFactor) / 10.0)) == v ? (double)((int)v) : v);
            this.zoomLevelLabel.setText(String.format(ZOOM_LEVEL_FORMAT, scaleStr, currentLevel));
            if (this.longitudeResolutionInMeter != Double.NaN && this.latitudeResolutionInMeter != Double.NaN) {
                this.pixelSpacingLabel.setText(String.format(PIXEL_SIZE_FORMAT, this.decimalFormat.format(this.latitudeResolutionInMeter), this.decimalFormat.format(this.longitudeResolutionInMeter)));
            }
        } else {
            this.setDefault();
        }
    }

    private void setDefault() {
        this.geoPosLabel.setText(String.format(GEO_POS_FORMAT, "--", "--"));
        this.pixelPosLabel.setText(String.format(PIXEL_POS_FORMAT, "--", "--"));
        this.zoomLevelLabel.setText(String.format(ZOOM_LEVEL_FORMAT, "--", "--"));
        this.pixelSpacingLabel.setText(String.format(PIXEL_SIZE_FORMAT, "--", "--"));
    }

    public void pixelPosNotAvailable() {
        this.setDefault();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        String propertyName = evt.getKey();
        if ("pixelview.showPixelPosDecimals".equals(propertyName) || "pixelview.showGeoPosDecimals".equals(propertyName)) {
            this.updateSettings();
        }
    }

    public void windowSelected(DocumentWindowManager.Event<Object, ProductSceneView> e) {
        ProductSceneView view = (ProductSceneView)e.getWindow().getView();
        view.addPixelPositionListener((PixelPositionListener)this);
        this.computeResolution();
    }

    public void windowDeselected(DocumentWindowManager.Event<Object, ProductSceneView> e) {
        ProductSceneView view = (ProductSceneView)e.getWindow().getView();
        view.removePixelPositionListener((PixelPositionListener)this);
        this.longitudeResolutionInMeter = Double.NaN;
        this.latitudeResolutionInMeter = Double.NaN;
    }

    private void updateSettings() {
        Preferences preferences = SnapApp.getDefault().getPreferences();
        this.showPixelOffsetDecimals = preferences.getBoolean("pixelview.showPixelPosDecimals", false);
        this.showGeoPosOffsetDecimals = preferences.getBoolean("pixelview.showGeoPosDecimals", false);
    }
}

