/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.core.Assert;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class XYImagePlot
extends XYPlot {
    private BufferedImage image;
    private Rectangle2D imageDataBounds;
    private final Object imageLock = new Object();

    public XYImagePlot() {
        super(null, (ValueAxis)new NumberAxis("X"), (ValueAxis)new NumberAxis("Y"), (XYItemRenderer)new XYLineAndShapeRenderer(false, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() {
        Object object = this.imageLock;
        synchronized (object) {
            return this.image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(BufferedImage image) {
        Object object = this.imageLock;
        synchronized (object) {
            this.image = image;
            if (image != null && this.imageDataBounds == null) {
                this.setImageDataBounds(new Rectangle(0, 0, image.getWidth(), image.getHeight()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle2D getImageDataBounds() {
        Object object = this.imageLock;
        synchronized (object) {
            return this.imageDataBounds != null ? (Rectangle2D)this.imageDataBounds.clone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageDataBounds(Rectangle2D imageDataBounds) {
        Object object = this.imageLock;
        synchronized (object) {
            this.imageDataBounds = (Rectangle2D)imageDataBounds.clone();
            DefaultXYDataset xyDataset = new DefaultXYDataset();
            xyDataset.addSeries((Comparable)((Object)"Image Data Bounds"), (double[][])new double[][]{{imageDataBounds.getMinX(), imageDataBounds.getMaxX()}, {imageDataBounds.getMinY(), imageDataBounds.getMaxY()}});
            this.setDataset((XYDataset)xyDataset);
            this.getDomainAxis().setRange(imageDataBounds.getMinX(), imageDataBounds.getMaxX());
            this.getRangeAxis().setRange(imageDataBounds.getMinY(), imageDataBounds.getMaxY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(Graphics2D g2, Rectangle2D dataArea, int index, PlotRenderingInfo info, CrosshairState crosshairState) {
        boolean foundData = super.render(g2, dataArea, index, info, crosshairState);
        if (this.image != null) {
            int dx1 = (int)dataArea.getMinX();
            int dy1 = (int)dataArea.getMinY();
            int dx2 = (int)dataArea.getMaxX();
            int dy2 = (int)dataArea.getMaxY();
            Object object = this.imageLock;
            synchronized (object) {
                Rectangle rectangle = this.getImageSourceArea();
                int sx1 = rectangle.x;
                int sy1 = rectangle.y;
                int sx2 = sx1 + rectangle.width - 1;
                int sy2 = sy1 + rectangle.height - 1;
                g2.drawImage(this.image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
            }
        }
        return foundData;
    }

    final Rectangle getImageSourceArea() {
        Assert.notNull((Object)this.image);
        Assert.notNull((Object)this.imageDataBounds);
        ValueAxis xAxis = this.getDomainAxis();
        ValueAxis yAxis = this.getRangeAxis();
        double scaleX = (double)this.image.getWidth() / this.imageDataBounds.getWidth();
        double scaleY = (double)this.image.getHeight() / this.imageDataBounds.getHeight();
        int x = XYImagePlot.crop(scaleX * (xAxis.getLowerBound() - this.imageDataBounds.getMinX()), 0, this.image.getWidth() - 1);
        int y = XYImagePlot.crop(scaleY * (this.imageDataBounds.getMaxY() - yAxis.getUpperBound()), 0, this.image.getHeight() - 1);
        int w = XYImagePlot.crop(scaleX * (xAxis.getUpperBound() - xAxis.getLowerBound()), 1, this.image.getWidth());
        int h = XYImagePlot.crop(scaleY * (yAxis.getUpperBound() - yAxis.getLowerBound()), 1, this.image.getHeight());
        return new Rectangle(x, y, w, h);
    }

    private static int crop(double v, int i1, int i2) {
        int i = (int)Math.round(v);
        if (i < i1) {
            return i1;
        }
        if (i > i2) {
            return i2;
        }
        return i;
    }
}

