/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.statistics.PagePanel;
import org.openide.windows.TopComponent;

abstract class TablePagePanel
extends PagePanel {
    private final TableModel emptyTableModel = new DefaultTableModel(1, 1);
    private JTable table;

    TablePagePanel(TopComponent parentDialog, String helpId, String titlePrefix, String defaultInformationText) {
        super(parentDialog, helpId, titlePrefix);
        this.emptyTableModel.setValueAt(defaultInformationText, 0, 0);
        this.table = new JTable(this.emptyTableModel);
    }

    @Override
    public void nodeChanged(ProductNodeEvent event) {
        if (event.getSourceNode() == this.getRaster() || event.getSourceNode() == this.getProduct()) {
            this.updateComponents();
        }
    }

    protected JTable getTable() {
        return this.table;
    }

    protected void showNoInformationAvailableMessage() {
        this.table.setModel(this.emptyTableModel);
    }

    protected void setColumnRenderer(int column, TableCellRenderer renderer) {
        this.getTable().getColumnModel().getColumn(column).setCellRenderer(renderer);
    }

    protected static abstract class TablePagePanelModel
    implements TableModel {
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
        protected List<TableRow> rows = new ArrayList<TableRow>();

        protected TablePagePanelModel() {
        }

        public void addRow(TableRow row) {
            this.rows.add(row);
            this.notifyListeners();
        }

        public void clear() {
            this.rows.clear();
            this.notifyListeners();
        }

        private void notifyListeners() {
            for (TableModelListener listener : this.listeners) {
                listener.tableChanged(new TableModelEvent(this));
            }
        }

        @Override
        public void addTableModelListener(TableModelListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeTableModelListener(TableModelListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void setValueAt(Object invalid1, int invalid2, int invalid3) {
            throw new IllegalStateException("Table must be non-editable!");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }
    }

    static interface TableRow {
    }

    private static class WrapTextRenderer
    implements RendererStrategy {
        List<Integer> wrappingRows;

        private WrapTextRenderer(ArrayList<Integer> wrappingRows) {
            this.wrappingRows = wrappingRows;
        }

        @Override
        public void customise(JTable table, JTextArea component, String value, int rowIndex, int colIndex) {
            if (!this.wrappingRows.contains(rowIndex)) {
                return;
            }
            component.setLineWrap(true);
            component.setWrapStyleWord(true);
            int max = 230;
            int numRows = WrapTextRenderer.countLines(component, value, max);
            if (numRows > 1) {
                int rowHeight = table.getRowHeight() * numRows;
                table.setRowHeight(rowIndex, Math.max(table.getRowHeight(rowIndex), rowHeight));
            }
        }

        private static int countLines(JTextArea component, String value, int max) {
            int lineCount = 0;
            FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
            for (String s : value.split("\n")) {
                lineCount += 1 + fontMetrics.stringWidth(s) / max;
            }
            return lineCount;
        }
    }

    private static class TooltipAwareRenderer
    implements RendererStrategy {
        private TooltipAwareRenderer() {
        }

        @Override
        public void customise(JTable table, JTextArea component, String value, int rowIndex, int colIndex) {
            component.setToolTipText(value);
        }
    }

    private static class AlternatingRowsRenderer
    implements RendererStrategy {
        private Color brightBackground = Color.white;
        private Color mediumBackground = new Color(14 * this.brightBackground.getRed() / 15, 14 * this.brightBackground.getGreen() / 15, 14 * this.brightBackground.getBlue() / 15);

        protected Color getBackground(int row) {
            if (row % 2 == 0) {
                return this.mediumBackground;
            }
            return this.brightBackground;
        }

        @Override
        public void customise(JTable table, JTextArea component, String value, int rowIndex, int colIndex) {
            component.setBorder(new EmptyBorder(0, 0, 0, 0));
            component.setBackground(this.getBackground(rowIndex));
        }
    }

    private static interface RendererStrategy {
        public void customise(JTable var1, JTextArea var2, String var3, int var4, int var5);
    }

    static class RendererFactory {
        static final int ALTERNATING_ROWS = 1;
        static final int TOOLTIP_AWARE = 2;
        static final int WRAP_TEXT = 4;

        RendererFactory() {
        }

        static TableCellRenderer createRenderer(int spec) {
            return RendererFactory.createRenderer(spec, null);
        }

        static TableCellRenderer createRenderer(int spec, Object configurator) {
            final ArrayList<RendererStrategy> strategies = new ArrayList<RendererStrategy>();
            if ((spec & 4) == 4) {
                strategies.add(new WrapTextRenderer((ArrayList)configurator));
            }
            if ((spec & 1) == 1) {
                strategies.add(new AlternatingRowsRenderer());
            }
            if ((spec & 2) == 2) {
                strategies.add(new TooltipAwareRenderer());
            }
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JTextArea textArea = new JTextArea(value.toString());
                    for (RendererStrategy strategy : strategies) {
                        strategy.customise(table, textArea, value.toString(), row, column);
                    }
                    this.careForEmptyLines(value, textArea);
                    return textArea;
                }

                public void careForEmptyLines(Object value, JTextArea textArea) {
                    if (StringUtils.isNullOrEmpty((String)value.toString())) {
                        textArea.setText("____");
                        textArea.setForeground(textArea.getBackground());
                    }
                }
            };
        }
    }
}

