/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.ShapeFigure;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TransectProfileData;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.product.ProductSceneView;

public class StatisticsUtils {
    public static float round(float x) {
        return StatisticsUtils.round(x, 100.0f);
    }

    public static float round(float x, float v) {
        return MathUtils.round((float)x, (float)v);
    }

    public static double round(double x) {
        return StatisticsUtils.round(x, 100.0);
    }

    public static double round(double x, double v) {
        return MathUtils.round((double)x, (double)v);
    }

    public static String getDiagramLabel(RasterDataNode raster) {
        StringBuilder sb = new StringBuilder();
        sb.append(raster.getName());
        if (StringUtils.isNotNullAndNotEmpty((String)raster.getUnit())) {
            sb.append(" [");
            sb.append(raster.getUnit());
            sb.append("]");
        } else {
            sb.append(" [-]");
        }
        return sb.toString();
    }

    public static class TransectProfile {
        @Deprecated
        public static TransectProfileData getTransectProfileData(RasterDataNode raster) throws IOException {
            Shape transectShape = null;
            if (raster != null) {
                transectShape = TransectProfile.getTransectShape(raster.getProduct());
            }
            if (transectShape == null) {
                return null;
            }
            return raster.createTransectProfileData(transectShape);
        }

        public static Shape getTransectShape(Product product) {
            ShapeFigure currentShapeFigure;
            ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
            if (sceneView != null && sceneView.getProduct() == product && (currentShapeFigure = sceneView.getCurrentShapeFigure()) != null && currentShapeFigure.getRank() != Figure.Rank.POINT) {
                return currentShapeFigure.getShape();
            }
            return null;
        }

        @Deprecated
        public static String createTransectProfileText(RasterDataNode raster) throws IOException {
            TransectProfileData data = TransectProfile.getTransectProfileData(raster);
            if (data == null) {
                return null;
            }
            return TransectProfile.createTransectProfileText(raster, data);
        }

        static String createTransectProfileText(RasterDataNode raster, TransectProfileData data) {
            Point2D[] pixelPositions = data.getPixelPositions();
            GeoPos[] geoPositions = data.getGeoPositions();
            float[] sampleValues = data.getSampleValues();
            StringBuilder sb = new StringBuilder(1024);
            String formatString = "%1$-10s\t";
            sb.append(String.format("%1$-10s\t", "Index"));
            sb.append(String.format("%1$-10s\t", "Pixel-X"));
            sb.append(String.format("%1$-10s\t", "Pixel-Y"));
            if (geoPositions.length > 0) {
                sb.append(String.format("%1$-10s\t", "Lat"));
                sb.append(String.format("%1$-10s\t", "Lon"));
            }
            sb.append(String.format("%1$-10s\t", StatisticsUtils.getDiagramLabel(raster)));
            sb.append("\n");
            for (int i = 0; i < pixelPositions.length; ++i) {
                Point2D pixelPos = pixelPositions[i];
                sb.append(String.format("%1$-10s\t", String.valueOf(i)));
                sb.append(String.format("%1$-10s\t", String.valueOf(pixelPos.getX())));
                sb.append(String.format("%1$-10s\t", String.valueOf(pixelPos.getY())));
                if (geoPositions.length > 0) {
                    GeoPos geoPos = geoPositions[i];
                    sb.append(String.format("%1$-10s\t", String.valueOf(geoPos.lat)));
                    sb.append(String.format("%1$-10s\t", String.valueOf(geoPos.lon)));
                }
                sb.append(String.format("%1$-10s\t", String.valueOf(sampleValues[i])));
                sb.append(" \n");
            }
            return sb.toString();
        }
    }
}

