/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.statistics.AxisRangeControl;
import org.esa.snap.rcp.statistics.ChartPagePanel;
import org.esa.snap.rcp.statistics.CorrelativeFieldSelector;
import org.esa.snap.rcp.statistics.MaskSelectionToolSupport;
import org.esa.snap.rcp.statistics.PlotAreaSelectionTool;
import org.esa.snap.rcp.statistics.ScatterPlotTableModel;
import org.esa.snap.rcp.statistics.StatisticChartStyling;
import org.esa.snap.rcp.statistics.TableViewPagePanel;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.GridBagUtils;
import org.geotools.feature.DefaultFeatureCollection;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTitleAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYErrorRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.HorizontalAlignment;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.Range;
import org.jfree.data.function.Function2D;
import org.jfree.data.function.LineFunction2D;
import org.jfree.data.general.DatasetUtils;
import org.jfree.data.statistics.Regression;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.jfree.data.xy.XYSeries;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.openide.windows.TopComponent;

class ScatterPlotPanel
extends ChartPagePanel {
    public static final String CHART_TITLE = "Correlative Plot";
    private static final String NO_DATA_MESSAGE = "No correlative plot computed yet.\nTo create a correlative plot\n   -Select a band\n   -Select vector data (e.g., a SeaDAS 6.x track)\n   -Select the data as point data source\n   -Select a data field\nFor more information about this plot\nhit the help button at the bottom right.\nTIP: To zoom within the chart, draw a rectangle\nwith the mouse or use the context menu.";
    private final String PROPERTY_NAME_X_AXIS_LOG_SCALED = "xAxisLogScaled";
    private final String PROPERTY_NAME_Y_AXIS_LOG_SCALED = "yAxisLogScaled";
    private final String PROPERTY_NAME_DATA_FIELD = "dataField";
    private final String PROPERTY_NAME_POINT_DATA_SOURCE = "pointDataSource";
    private final String PROPERTY_NAME_BOX_SIZE = "boxSize";
    private final String PROPERTY_NAME_SHOW_ACCEPTABLE_DEVIATION = "showAcceptableDeviation";
    private final String PROPERTY_NAME_ACCEPTABLE_DEVIATION = "acceptableDeviationInterval";
    private final String PROPERTY_NAME_SHOW_REGRESSION_LINE = "showRegressionLine";
    private final ScatterPlotModel scatterPlotModel;
    private final BindingContext bindingContext;
    private final AxisRangeControl xAxisRangeControl;
    private final AxisRangeControl yAxisRangeControl;
    private final XYIntervalSeriesCollection scatterpointsDataset;
    private final XYIntervalSeriesCollection acceptableDeviationDataset;
    private final XYIntervalSeriesCollection regressionDataset;
    private final JFreeChart chart;
    private final ProductManager.Listener productRemovedListener;
    private final Map<Product, UserSettings> userSettingsMap = new HashMap<Product, UserSettings>();
    private ChartPanel scatterPlotDisplay;
    private ComputedData[] computedDatas;
    private CorrelativeFieldSelector correlativeFieldSelector;
    private Range xAutoRangeAxisRange;
    private Range yAutoRangeAxisRange;
    private AxisChangeListener domainAxisChangeListener;
    private boolean computingData;
    private XYTitleAnnotation r2Annotation;

    ScatterPlotPanel(TopComponent parentDialog, String helpId) {
        super(parentDialog, helpId, CHART_TITLE, false);
        this.productRemovedListener = new ProductManager.Listener(){

            public void productAdded(ProductManager.Event event) {
            }

            public void productRemoved(ProductManager.Event event) {
                UserSettings userSettings = ScatterPlotPanel.this.userSettingsMap.remove(event.getProduct());
                if (userSettings != null) {
                    userSettings.dispose();
                }
            }
        };
        this.xAxisRangeControl = new AxisRangeControl("X-Axis");
        this.yAxisRangeControl = new AxisRangeControl("Y-Axis");
        this.scatterPlotModel = new ScatterPlotModel();
        this.bindingContext = new BindingContext((PropertySet)PropertyContainer.createObjectBacked((Object)this.scatterPlotModel));
        this.scatterpointsDataset = new XYIntervalSeriesCollection();
        this.acceptableDeviationDataset = new XYIntervalSeriesCollection();
        this.regressionDataset = new XYIntervalSeriesCollection();
        this.r2Annotation = new XYTitleAnnotation(0.0, 0.0, (Title)new TextTitle(""));
        this.chart = ChartFactory.createScatterPlot((String)CHART_TITLE, (String)"", (String)"", (XYDataset)this.scatterpointsDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.getXYPlot().setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        this.createDomainAxisChangeListener();
        PropertyChangeListener userSettingsUpdateListener = evt -> {
            if (this.getRaster() != null) {
                VectorDataNode pointDataSourceValue = this.scatterPlotModel.pointDataSource;
                AttributeDescriptor dataFieldValue = this.scatterPlotModel.dataField;
                UserSettings userSettings = this.getUserSettings(this.getRaster().getProduct());
                userSettings.set(this.getRaster().getName(), pointDataSourceValue, dataFieldValue);
            }
        };
        this.bindingContext.addPropertyChangeListener("dataField", userSettingsUpdateListener);
        this.bindingContext.addPropertyChangeListener("pointDataSource", userSettingsUpdateListener);
    }

    @Override
    protected void handleLayerContentChanged() {
        this.computeChartDataIfPossible();
    }

    @Override
    protected String getDataAsText() {
        if (this.scatterpointsDataset.getItemCount(0) > 0) {
            ScatterPlotTableModel scatterPlotTableModel = new ScatterPlotTableModel(this.getRasterName(), this.getCorrelativeDataName(), this.computedDatas);
            return scatterPlotTableModel.toCVS();
        }
        return "";
    }

    @Override
    protected void initComponents() {
        this.getAlternativeView().initComponents();
        this.initParameters();
        this.createUI();
        SnapApp.getDefault().getProductManager().addListener(this.productRemovedListener);
    }

    @Override
    protected void updateComponents() {
        super.updateComponents();
        if (!this.isVisible()) {
            return;
        }
        AttributeDescriptor dataField = this.scatterPlotModel.dataField;
        this.xAxisRangeControl.setTitleSuffix(dataField != null ? dataField.getLocalName() : null);
        RasterDataNode raster = this.getRaster();
        this.yAxisRangeControl.setTitleSuffix(raster != null ? raster.getName() : null);
        if (raster != null) {
            Product product = this.getProduct();
            String rasterName = raster.getName();
            UserSettings userSettings = this.getUserSettings(product);
            VectorDataNode userSelectedPointDataSource = userSettings.getPointDataSource(rasterName);
            AttributeDescriptor userSelectedDataField = userSettings.getDataField(rasterName);
            this.correlativeFieldSelector.updatePointDataSource(product);
            this.correlativeFieldSelector.updateDataField();
            if (userSelectedPointDataSource != null) {
                this.correlativeFieldSelector.tryToSelectPointDataSource(userSelectedPointDataSource);
            }
            if (userSelectedDataField != null) {
                this.correlativeFieldSelector.tryToSelectDataField(userSelectedDataField);
            }
        }
        if (this.isRasterChanged()) {
            this.getPlot().getRangeAxis().setLabel(StatisticChartStyling.getAxisLabel(raster, "X", false));
            this.computeChartDataIfPossible();
        }
    }

    private String getCorrelativeDataName() {
        return this.scatterPlotModel.dataField.getLocalName();
    }

    @Override
    protected void updateChartData() {
    }

    @Override
    public void nodeAdded(ProductNodeEvent event) {
        if (event.getSourceNode() instanceof Placemark) {
            this.updateComponents();
        }
    }

    @Override
    public void nodeRemoved(ProductNodeEvent event) {
        if (event.getSourceNode() instanceof VectorDataNode) {
            this.updateComponents();
            this.computeChartDataIfPossible();
        }
    }

    @Override
    protected void showAlternativeView() {
        AbstractTableModel model = this.computedDatas != null && this.computedDatas.length > 0 ? new ScatterPlotTableModel(this.getRasterName(), this.getCorrelativeDataName(), this.computedDatas) : new DefaultTableModel();
        TableViewPagePanel alternativPanel = (TableViewPagePanel)this.getAlternativeView();
        alternativPanel.setModel(model);
        super.showAlternativeView();
    }

    private String getRasterName() {
        return this.getRaster() != null ? this.getRaster().getName() : "";
    }

    private void initParameters() {
        PropertyChangeListener recomputeListener = evt -> this.computeChartDataIfPossible();
        this.bindingContext.addPropertyChangeListener("useRoiMask", recomputeListener);
        this.bindingContext.addPropertyChangeListener("roiMask", recomputeListener);
        this.bindingContext.addPropertyChangeListener("boxSize", recomputeListener);
        this.bindingContext.addPropertyChangeListener("dataField", recomputeListener);
        PropertyChangeListener computeLineDataListener = evt -> this.computeRegressionAndAcceptableDeviationData();
        this.bindingContext.addPropertyChangeListener("showAcceptableDeviation", computeLineDataListener);
        this.bindingContext.addPropertyChangeListener("acceptableDeviationInterval", computeLineDataListener);
        this.bindingContext.addPropertyChangeListener("showRegressionLine", computeLineDataListener);
        PropertyChangeListener rangeLabelUpdateListener = evt -> {
            VectorDataNode pointDataSource = this.scatterPlotModel.pointDataSource;
            AttributeDescriptor dataField = this.scatterPlotModel.dataField;
            if (dataField != null && pointDataSource != null) {
                String dataFieldName = dataField.getLocalName();
                this.getPlot().getDomainAxis().setLabel(dataFieldName);
                this.xAxisRangeControl.setTitleSuffix(dataFieldName);
            } else {
                this.getPlot().getDomainAxis().setLabel("");
                this.xAxisRangeControl.setTitleSuffix("");
            }
        };
        this.bindingContext.addPropertyChangeListener("dataField", rangeLabelUpdateListener);
        this.bindingContext.addPropertyChangeListener("pointDataSource", rangeLabelUpdateListener);
        this.bindingContext.addPropertyChangeListener("xAxisLogScaled", evt -> this.updateScalingOfXAxis());
        this.bindingContext.addPropertyChangeListener("yAxisLogScaled", evt -> this.updateScalingOfYAxis());
        this.xAxisRangeControl.getBindingContext().addPropertyChangeListener(evt -> this.handleAxisRangeControlChanges(evt, this.xAxisRangeControl, this.getPlot().getDomainAxis(), this.xAutoRangeAxisRange));
        this.yAxisRangeControl.getBindingContext().addPropertyChangeListener(evt -> this.handleAxisRangeControlChanges(evt, this.yAxisRangeControl, this.getPlot().getRangeAxis(), this.yAutoRangeAxisRange));
    }

    private void handleAxisRangeControlChanges(PropertyChangeEvent evt, AxisRangeControl axisRangeControl, ValueAxis valueAxis, Range computedAutoRange) {
        String propertyName;
        switch (propertyName = evt.getPropertyName()) {
            case "autoMinMax": {
                if (!axisRangeControl.isAutoMinMax()) break;
                double min = computedAutoRange.getLowerBound();
                double max = computedAutoRange.getUpperBound();
                axisRangeControl.adjustComponents(min, max, 3);
                break;
            }
            case "min": {
                valueAxis.setLowerBound(axisRangeControl.getMin().doubleValue());
                break;
            }
            case "max": {
                valueAxis.setUpperBound(axisRangeControl.getMax().doubleValue());
            }
        }
    }

    private void createUI() {
        XYPlot plot = this.getPlot();
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setNoDataMessage(NO_DATA_MESSAGE);
        int confidenceDSIndex = 0;
        int regressionDSIndex = 1;
        int scatterpointsDSIndex = 2;
        plot.setDataset(confidenceDSIndex, (XYDataset)this.acceptableDeviationDataset);
        plot.setDataset(regressionDSIndex, (XYDataset)this.regressionDataset);
        plot.setDataset(scatterpointsDSIndex, (XYDataset)this.scatterpointsDataset);
        plot.addAnnotation((XYAnnotation)this.r2Annotation);
        DeviationRenderer identityRenderer = new DeviationRenderer(true, false);
        identityRenderer.setSeriesPaint(0, StatisticChartStyling.SAMPLE_DATA_PAINT);
        identityRenderer.setSeriesFillPaint(0, StatisticChartStyling.SAMPLE_DATA_FILL_PAINT);
        plot.setRenderer(confidenceDSIndex, (XYItemRenderer)identityRenderer);
        DeviationRenderer regressionRenderer = new DeviationRenderer(true, false);
        regressionRenderer.setSeriesPaint(0, StatisticChartStyling.REGRESSION_DATA_PAINT);
        regressionRenderer.setSeriesFillPaint(0, StatisticChartStyling.REGRESSION_DATA_FILL_PAINT);
        plot.setRenderer(regressionDSIndex, (XYItemRenderer)regressionRenderer);
        XYErrorRenderer scatterPointsRenderer = new XYErrorRenderer();
        scatterPointsRenderer.setDrawXError(true);
        scatterPointsRenderer.setErrorStroke((Stroke)new BasicStroke(1.0f));
        scatterPointsRenderer.setErrorPaint(StatisticChartStyling.CORRELATIVE_POINT_OUTLINE_PAINT);
        scatterPointsRenderer.setSeriesShape(0, StatisticChartStyling.CORRELATIVE_POINT_SHAPE);
        scatterPointsRenderer.setSeriesOutlinePaint(0, StatisticChartStyling.CORRELATIVE_POINT_OUTLINE_PAINT);
        scatterPointsRenderer.setSeriesFillPaint(0, StatisticChartStyling.CORRELATIVE_POINT_FILL_PAINT);
        scatterPointsRenderer.setSeriesLinesVisible(0, false);
        scatterPointsRenderer.setSeriesShapesVisible(0, true);
        scatterPointsRenderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(1.0f));
        scatterPointsRenderer.setSeriesToolTipGenerator(0, (dataset, series, item) -> {
            XYIntervalSeriesCollection collection = (XYIntervalSeriesCollection)dataset;
            Comparable key = collection.getSeriesKey(series);
            double xValue = collection.getXValue(series, item);
            double endYValue = collection.getEndYValue(series, item);
            double yValue = collection.getYValue(series, item);
            return String.format("%s: mean = %6.2f, sigma = %6.2f | %s: value = %6.2f", this.getRasterName(), yValue, endYValue - yValue, key, xValue);
        });
        plot.setRenderer(scatterpointsDSIndex, (XYItemRenderer)scatterPointsRenderer);
        boolean autoRangeIncludesZero = false;
        boolean xLog = this.scatterPlotModel.xAxisLogScaled;
        boolean yLog = this.scatterPlotModel.yAxisLogScaled;
        plot.setDomainAxis(StatisticChartStyling.updateScalingOfAxis(xLog, plot.getDomainAxis(), false));
        plot.setRangeAxis(StatisticChartStyling.updateScalingOfAxis(yLog, plot.getRangeAxis(), false));
        this.createUI(this.createChartPanel(this.chart), this.createInputParameterPanel(), this.bindingContext);
        plot.getDomainAxis().addChangeListener(this.domainAxisChangeListener);
        this.scatterPlotDisplay.setMouseWheelEnabled(true);
        this.scatterPlotDisplay.setMouseZoomable(true);
    }

    private void createDomainAxisChangeListener() {
        this.domainAxisChangeListener = event -> {
            if (!this.computingData) {
                this.computeRegressionAndAcceptableDeviationData();
            }
        };
    }

    private ChartPanel createChartPanel(final JFreeChart chart) {
        this.scatterPlotDisplay = new ChartPanel(chart){

            public void restoreAutoBounds() {
                XYPlot plot = chart.getXYPlot();
                boolean savedNotify = plot.isNotify();
                plot.setNotify(false);
                ScatterPlotPanel.this.xAxisRangeControl.adjustAxis(plot.getDomainAxis(), 3);
                ScatterPlotPanel.this.yAxisRangeControl.adjustAxis(plot.getRangeAxis(), 3);
                plot.setNotify(savedNotify);
            }
        };
        MaskSelectionToolSupport maskSelectionToolSupport = new MaskSelectionToolSupport(this, this.scatterPlotDisplay, "correlative_plot_area", "Mask generated from selected correlative plot area", Color.RED, PlotAreaSelectionTool.AreaType.Y_RANGE){

            @Override
            protected String createMaskExpression(PlotAreaSelectionTool.AreaType areaType, Shape shape) {
                Rectangle2D bounds = shape.getBounds2D();
                return this.createMaskExpression(bounds.getMinY(), bounds.getMaxY());
            }

            protected String createMaskExpression(double x1, double x2) {
                String bandName = BandArithmetic.createExternalName((String)ScatterPlotPanel.this.getRaster().getName());
                return String.format("%s >= %s && %s <= %s", bandName, x1, bandName, x2);
            }
        };
        this.scatterPlotDisplay.getPopupMenu().addSeparator();
        this.scatterPlotDisplay.getPopupMenu().add(maskSelectionToolSupport.createMaskSelectionModeMenuItem());
        this.scatterPlotDisplay.getPopupMenu().add(maskSelectionToolSupport.createDeleteMaskMenuItem());
        this.scatterPlotDisplay.getPopupMenu().addSeparator();
        this.scatterPlotDisplay.getPopupMenu().add(this.createCopyDataToClipboardMenuItem());
        return this.scatterPlotDisplay;
    }

    private JPanel createInputParameterPanel() {
        PropertyDescriptor boxSizeDescriptor = this.bindingContext.getPropertySet().getDescriptor("boxSize");
        boxSizeDescriptor.setValueRange(new ValueRange(1.0, 101.0));
        boxSizeDescriptor.setAttribute("stepSize", (Object)2);
        boxSizeDescriptor.setValidator((property, value) -> {
            if (((Number)value).intValue() % 2 == 0) {
                throw new ValidationException("Only odd values allowed as box size.");
            }
        });
        JSpinner boxSizeSpinner = new JSpinner();
        this.bindingContext.bind("boxSize", boxSizeSpinner);
        JPanel boxSizePanel = new JPanel(new BorderLayout(5, 3));
        boxSizePanel.add((Component)new JLabel("Box size:"), "West");
        boxSizePanel.add(boxSizeSpinner);
        this.correlativeFieldSelector = new CorrelativeFieldSelector(this.bindingContext);
        JPanel pointDataSourcePanel = new JPanel(new BorderLayout(5, 3));
        pointDataSourcePanel.add((Component)this.correlativeFieldSelector.pointDataSourceLabel, "North");
        pointDataSourcePanel.add(this.correlativeFieldSelector.pointDataSourceList);
        JPanel pointDataFieldPanel = new JPanel(new BorderLayout(5, 3));
        pointDataFieldPanel.add((Component)this.correlativeFieldSelector.dataFieldLabel, "North");
        pointDataFieldPanel.add(this.correlativeFieldSelector.dataFieldList);
        JCheckBox xLogCheck = new JCheckBox("Log10 scaled");
        this.bindingContext.bind("xAxisLogScaled", xLogCheck);
        JPanel xAxisOptionPanel = new JPanel(new BorderLayout());
        xAxisOptionPanel.add(this.xAxisRangeControl.getPanel());
        xAxisOptionPanel.add((Component)xLogCheck, "South");
        JCheckBox yLogCheck = new JCheckBox("Log10 scaled");
        this.bindingContext.bind("yAxisLogScaled", yLogCheck);
        JPanel yAxisOptionPanel = new JPanel(new BorderLayout());
        yAxisOptionPanel.add(this.yAxisRangeControl.getPanel());
        yAxisOptionPanel.add((Component)yLogCheck, "South");
        JCheckBox acceptableCheck = new JCheckBox("Show tolerance range");
        JLabel fieldPrefix = new JLabel("+/-");
        JTextField acceptableField = new JTextField();
        acceptableField.setPreferredSize(new Dimension(40, acceptableField.getPreferredSize().height));
        acceptableField.setHorizontalAlignment(4);
        JLabel percentLabel = new JLabel(" %");
        this.bindingContext.bind("showAcceptableDeviation", acceptableCheck);
        this.bindingContext.bind("acceptableDeviationInterval", acceptableField);
        this.bindingContext.getBinding("acceptableDeviationInterval").addComponent((JComponent)percentLabel);
        this.bindingContext.getBinding("acceptableDeviationInterval").addComponent((JComponent)fieldPrefix);
        this.bindingContext.bindEnabledState("acceptableDeviationInterval", true, "showAcceptableDeviation", (Object)true);
        JPanel confidencePanel = GridBagUtils.createPanel();
        GridBagConstraints confidencePanelConstraints = GridBagUtils.createConstraints((String)"anchor=NORTHWEST,fill=HORIZONTAL,insets.top=5,weighty=0,weightx=1");
        GridBagUtils.addToPanel((JPanel)confidencePanel, (Component)acceptableCheck, (GridBagConstraints)confidencePanelConstraints, (String)"gridy=0,gridwidth=3");
        GridBagUtils.addToPanel((JPanel)confidencePanel, (Component)fieldPrefix, (GridBagConstraints)confidencePanelConstraints, (String)"weightx=0,insets.left=22,gridy=1,gridx=0,insets.top=4,gridwidth=1");
        GridBagUtils.addToPanel((JPanel)confidencePanel, (Component)acceptableField, (GridBagConstraints)confidencePanelConstraints, (String)"weightx=1,gridx=1,insets.left=2,insets.top=2");
        GridBagUtils.addToPanel((JPanel)confidencePanel, (Component)percentLabel, (GridBagConstraints)confidencePanelConstraints, (String)"weightx=0,gridx=2,insets.left=0,insets.top=4");
        JCheckBox regressionCheck = new JCheckBox("Show regression line");
        this.bindingContext.bind("showRegressionLine", regressionCheck);
        JPanel middlePanel = GridBagUtils.createPanel();
        GridBagConstraints middlePanelConstraints = GridBagUtils.createConstraints((String)"anchor=NORTHWEST,fill=HORIZONTAL,insets.top=6,weighty=0,weightx=1");
        GridBagUtils.addToPanel((JPanel)middlePanel, (Component)boxSizePanel, (GridBagConstraints)middlePanelConstraints, (String)"gridy=0,insets.left=6");
        GridBagUtils.addToPanel((JPanel)middlePanel, (Component)pointDataSourcePanel, (GridBagConstraints)middlePanelConstraints, (String)"gridy=1");
        GridBagUtils.addToPanel((JPanel)middlePanel, (Component)pointDataFieldPanel, (GridBagConstraints)middlePanelConstraints, (String)"gridy=2");
        GridBagUtils.addToPanel((JPanel)middlePanel, (Component)xAxisOptionPanel, (GridBagConstraints)middlePanelConstraints, (String)"gridy=3,insets.left=0");
        GridBagUtils.addToPanel((JPanel)middlePanel, (Component)yAxisOptionPanel, (GridBagConstraints)middlePanelConstraints, (String)"gridy=4");
        GridBagUtils.addToPanel((JPanel)middlePanel, (Component)new JSeparator(), (GridBagConstraints)middlePanelConstraints, (String)"gridy=5,insets.left=4");
        GridBagUtils.addToPanel((JPanel)middlePanel, (Component)confidencePanel, (GridBagConstraints)middlePanelConstraints, (String)"gridy=6,fill=HORIZONTAL,insets.left=-4");
        GridBagUtils.addToPanel((JPanel)middlePanel, (Component)regressionCheck, (GridBagConstraints)middlePanelConstraints, (String)"gridy=7,insets.left=-4,insets.top=8");
        return middlePanel;
    }

    private void updateScalingOfXAxis() {
        boolean logScaled = this.scatterPlotModel.xAxisLogScaled;
        ValueAxis oldAxis = this.getPlot().getDomainAxis();
        ValueAxis newAxis = StatisticChartStyling.updateScalingOfAxis(logScaled, oldAxis, false);
        oldAxis.removeChangeListener(this.domainAxisChangeListener);
        newAxis.addChangeListener(this.domainAxisChangeListener);
        this.getPlot().setDomainAxis(newAxis);
        this.finishScalingUpdate(this.xAxisRangeControl, newAxis, oldAxis);
    }

    private void updateScalingOfYAxis() {
        boolean logScaled = this.scatterPlotModel.yAxisLogScaled;
        ValueAxis oldAxis = this.getPlot().getRangeAxis();
        ValueAxis newAxis = StatisticChartStyling.updateScalingOfAxis(logScaled, oldAxis, false);
        this.getPlot().setRangeAxis(newAxis);
        this.finishScalingUpdate(this.yAxisRangeControl, newAxis, oldAxis);
    }

    private void finishScalingUpdate(AxisRangeControl axisRangeControl, ValueAxis newAxis, ValueAxis oldAxis) {
        if (axisRangeControl.isAutoMinMax()) {
            newAxis.setAutoRange(false);
            this.acceptableDeviationDataset.removeAllSeries();
            this.regressionDataset.removeAllSeries();
            this.getPlot().removeAnnotation((XYAnnotation)this.r2Annotation);
            newAxis.setAutoRange(true);
            axisRangeControl.adjustComponents(newAxis, 3);
            newAxis.setAutoRange(false);
            this.computeRegressionAndAcceptableDeviationData();
        } else {
            newAxis.setAutoRange(false);
            newAxis.setRange(oldAxis.getRange());
        }
    }

    private XYPlot getPlot() {
        return this.chart.getXYPlot();
    }

    private void computeChartDataIfPossible() {
        SwingUtilities.invokeLater(() -> {
            if (this.scatterPlotModel.pointDataSource != null && this.scatterPlotModel.dataField != null && this.scatterPlotModel.pointDataSource.getFeatureCollection() != null && this.scatterPlotModel.pointDataSource.getFeatureCollection().features() != null && this.scatterPlotModel.pointDataSource.getFeatureCollection().features().hasNext() && this.scatterPlotModel.pointDataSource.getFeatureCollection().features().next() != null && ((SimpleFeature)this.scatterPlotModel.pointDataSource.getFeatureCollection().features().next()).getAttribute(this.scatterPlotModel.dataField.getLocalName()) != null && this.getRaster() != null) {
                this.compute(this.scatterPlotModel.useRoiMask ? this.scatterPlotModel.roiMask : null);
            } else {
                this.scatterpointsDataset.removeAllSeries();
                this.acceptableDeviationDataset.removeAllSeries();
                this.regressionDataset.removeAllSeries();
                this.getPlot().removeAnnotation((XYAnnotation)this.r2Annotation);
                this.computedDatas = null;
            }
        });
    }

    private void compute(final Mask selectedMask) {
        final RasterDataNode raster = this.getRaster();
        final AttributeDescriptor dataField = this.scatterPlotModel.dataField;
        if (raster == null || dataField == null) {
            return;
        }
        SwingWorker<ComputedData[], Object> swingWorker = new SwingWorker<ComputedData[], Object>(){

            @Override
            protected ComputedData[] doInBackground() throws Exception {
                SystemUtils.LOG.finest("start computing scatter plot data");
                ArrayList<ComputedData> computedDataList = new ArrayList<ComputedData>();
                DefaultFeatureCollection collection = ScatterPlotPanel.this.scatterPlotModel.pointDataSource.getFeatureCollection();
                SimpleFeature[] features = (SimpleFeature[])collection.toArray((Object[])new SimpleFeature[collection.size()]);
                int boxSize = ScatterPlotPanel.this.scatterPlotModel.boxSize;
                Rectangle sceneRect = new Rectangle(raster.getRasterWidth(), raster.getRasterHeight());
                GeoCoding geoCoding = raster.getGeoCoding();
                AffineTransform imageToModelTransform = Product.findImageToModelTransform((GeoCoding)geoCoding);
                for (SimpleFeature feature : features) {
                    int centerIndex;
                    float imagePosY;
                    float imagePosX;
                    Rectangle imageRect;
                    Point point = (Point)feature.getDefaultGeometryProperty().getValue();
                    Point2D.Float modelPos = new Point2D.Float((float)point.getX(), (float)point.getY());
                    Point2D imagePos = imageToModelTransform.inverseTransform(modelPos, null);
                    if (!sceneRect.contains(imagePos) || (imageRect = sceneRect.intersection(new Rectangle((int)(imagePosX = (float)imagePos.getX()) - boxSize / 2, (int)(imagePosY = (float)imagePos.getY()) - boxSize / 2, boxSize, boxSize))).isEmpty()) continue;
                    double[] rasterValues = new double[imageRect.width * imageRect.height];
                    raster.readPixels(imageRect.x, imageRect.y, imageRect.width, imageRect.height, rasterValues);
                    int[] maskBuffer = new int[imageRect.width * imageRect.height];
                    Arrays.fill(maskBuffer, 1);
                    if (selectedMask != null) {
                        selectedMask.readPixels(imageRect.x, imageRect.y, imageRect.width, imageRect.height, maskBuffer);
                    }
                    if (maskBuffer[centerIndex = imageRect.width * (imageRect.height / 2) + imageRect.width / 2] == 0) continue;
                    double sum = 0.0;
                    double sumSqr = 0.0;
                    int n = 0;
                    boolean valid = false;
                    for (int y = 0; y < imageRect.height; ++y) {
                        for (int x = 0; x < imageRect.width; ++x) {
                            int index = y * imageRect.height + x;
                            if (!raster.isPixelValid(x + imageRect.x, y + imageRect.y) || maskBuffer[index] == 0) continue;
                            double rasterValue = rasterValues[index];
                            sum += rasterValue;
                            sumSqr += rasterValue * rasterValue;
                            ++n;
                            valid = true;
                        }
                    }
                    if (!valid) continue;
                    double rasterMean = sum / (double)n;
                    double rasterSigma = n > 1 ? Math.sqrt((sumSqr - sum * sum / (double)n) / (double)(n - 1)) : 0.0;
                    String localName = dataField.getLocalName();
                    Number attribute = (Number)feature.getAttribute(localName);
                    Collection featureProperties = feature.getProperties();
                    float correlativeData = attribute.floatValue();
                    GeoPos geoPos = new GeoPos();
                    if (geoCoding.canGetGeoPos()) {
                        PixelPos pixelPos = new PixelPos((double)imagePosX, (double)imagePosY);
                        geoCoding.getGeoPos(pixelPos, geoPos);
                    } else {
                        geoPos.setInvalid();
                    }
                    computedDataList.add(new ComputedData(imagePosX, imagePosY, (float)geoPos.getLat(), (float)geoPos.getLon(), (float)rasterMean, (float)rasterSigma, correlativeData, featureProperties));
                }
                return computedDataList.toArray(new ComputedData[computedDataList.size()]);
            }

            @Override
            public void done() {
                try {
                    ValueAxis xAxis = ScatterPlotPanel.this.getPlot().getDomainAxis();
                    ValueAxis yAxis = ScatterPlotPanel.this.getPlot().getRangeAxis();
                    xAxis.setAutoRange(false);
                    yAxis.setAutoRange(false);
                    ScatterPlotPanel.this.scatterpointsDataset.removeAllSeries();
                    ScatterPlotPanel.this.acceptableDeviationDataset.removeAllSeries();
                    ScatterPlotPanel.this.regressionDataset.removeAllSeries();
                    ScatterPlotPanel.this.getPlot().removeAnnotation((XYAnnotation)ScatterPlotPanel.this.r2Annotation);
                    ScatterPlotPanel.this.computedDatas = null;
                    ComputedData[] data = (ComputedData[])this.get();
                    if (data.length == 0) {
                        return;
                    }
                    ScatterPlotPanel.this.computedDatas = data;
                    XYIntervalSeries scatterValues = new XYIntervalSeries((Comparable)((Object)ScatterPlotPanel.this.getCorrelativeDataName()));
                    for (ComputedData computedData : ScatterPlotPanel.this.computedDatas) {
                        float rasterMean = computedData.rasterMean;
                        float rasterSigma = computedData.rasterSigma;
                        float correlativeData = computedData.correlativeData;
                        scatterValues.add((double)correlativeData, (double)correlativeData, (double)correlativeData, (double)rasterMean, (double)(rasterMean - rasterSigma), (double)(rasterMean + rasterSigma));
                    }
                    ScatterPlotPanel.this.computingData = true;
                    ScatterPlotPanel.this.scatterpointsDataset.addSeries(scatterValues);
                    xAxis.setAutoRange(true);
                    yAxis.setAutoRange(true);
                    xAxis.setAutoRange(false);
                    yAxis.setAutoRange(false);
                    ScatterPlotPanel.this.xAutoRangeAxisRange = new Range(xAxis.getLowerBound(), xAxis.getUpperBound());
                    ScatterPlotPanel.this.yAutoRangeAxisRange = new Range(yAxis.getLowerBound(), yAxis.getUpperBound());
                    if (ScatterPlotPanel.this.xAxisRangeControl.isAutoMinMax()) {
                        ScatterPlotPanel.this.xAxisRangeControl.adjustComponents(xAxis, 3);
                    } else {
                        ScatterPlotPanel.this.xAxisRangeControl.adjustAxis(xAxis, 3);
                    }
                    if (ScatterPlotPanel.this.yAxisRangeControl.isAutoMinMax()) {
                        ScatterPlotPanel.this.yAxisRangeControl.adjustComponents(yAxis, 3);
                    } else {
                        ScatterPlotPanel.this.yAxisRangeControl.adjustAxis(yAxis, 3);
                    }
                    ScatterPlotPanel.this.computeRegressionAndAcceptableDeviationData();
                    ScatterPlotPanel.this.computingData = false;
                }
                catch (InterruptedException | CancellationException e) {
                    SystemUtils.LOG.log(Level.WARNING, "Failed to compute correlative plot.", e);
                    Dialogs.showMessage(ScatterPlotPanel.CHART_TITLE, "Failed to compute correlative plot.\nCalculation canceled.", 0, null);
                }
                catch (ExecutionException e) {
                    SystemUtils.LOG.log(Level.WARNING, "Failed to compute correlative plot.", e);
                    Dialogs.showMessage(ScatterPlotPanel.CHART_TITLE, "Failed to compute correlative plot.\nAn error occurred:\n" + e.getCause().getMessage(), 0, null);
                }
            }
        };
        swingWorker.execute();
    }

    private void computeRegressionAndAcceptableDeviationData() {
        this.acceptableDeviationDataset.removeAllSeries();
        this.regressionDataset.removeAllSeries();
        this.getPlot().removeAnnotation((XYAnnotation)this.r2Annotation);
        if (this.computedDatas != null) {
            XYIntervalSeries series;
            ValueAxis domainAxis = this.getPlot().getDomainAxis();
            double min = domainAxis.getLowerBound();
            double max = domainAxis.getUpperBound();
            this.acceptableDeviationDataset.addSeries(this.computeAcceptableDeviationData(min, max));
            if (this.scatterPlotModel.showRegressionLine && (series = this.computeRegressionData(min, max)) != null) {
                this.regressionDataset.addSeries(series);
                this.computeCoefficientOfDetermination();
            }
        }
    }

    private XYIntervalSeries computeRegressionData(double xStart, double xEnd) {
        if (this.scatterpointsDataset.getItemCount(0) > 1) {
            double[] coefficients = Regression.getOLSRegression((XYDataset)this.scatterpointsDataset, (int)0);
            LineFunction2D curve = new LineFunction2D(coefficients[0], coefficients[1]);
            XYSeries regressionData = DatasetUtils.sampleFunction2DToSeries((Function2D)curve, (double)xStart, (double)xEnd, (int)100, (Comparable)((Object)"regression line"));
            XYIntervalSeries xyIntervalRegression = new XYIntervalSeries(regressionData.getKey());
            for (int i = 0; i < regressionData.getItemCount(); ++i) {
                XYDataItem item = regressionData.getDataItem(i);
                double x = item.getXValue();
                double y = item.getYValue();
                xyIntervalRegression.add(x, x, x, y, y, y);
            }
            return xyIntervalRegression;
        }
        Dialogs.showInformation("Unable to compute regression line.\nAt least 2 values are needed to compute regression coefficients.");
        return null;
    }

    private void computeCoefficientOfDetermination() {
        int i;
        int numberOfItems = this.scatterpointsDataset.getSeries(0).getItemCount();
        double arithmeticMeanOfX = 0.0;
        double arithmeticMeanOfY = 0.0;
        double varX = 0.0;
        double varY = 0.0;
        double coVarXY = 0.0;
        for (i = 0; i < numberOfItems; ++i) {
            arithmeticMeanOfX += this.scatterpointsDataset.getXValue(0, i);
            arithmeticMeanOfY += this.scatterpointsDataset.getYValue(0, i);
        }
        arithmeticMeanOfX /= (double)numberOfItems;
        arithmeticMeanOfY /= (double)numberOfItems;
        for (i = 0; i < numberOfItems; ++i) {
            varX += Math.pow(this.scatterpointsDataset.getXValue(0, i) - arithmeticMeanOfX, 2.0);
            varY += Math.pow(this.scatterpointsDataset.getYValue(0, i) - arithmeticMeanOfY, 2.0);
            coVarXY += (this.scatterpointsDataset.getXValue(0, i) - arithmeticMeanOfX) * (this.scatterpointsDataset.getYValue(0, i) - arithmeticMeanOfY);
        }
        double r2 = Math.pow(coVarXY, 2.0) / (varX * varY);
        r2 = MathUtils.round((double)r2, (double)Math.pow(10.0, 5.0));
        double[] coefficients = Regression.getOLSRegression((XYDataset)this.scatterpointsDataset, (int)0);
        double intercept = coefficients[0];
        double slope = coefficients[1];
        String linearEquation = intercept >= 0.0 ? "y = " + (float)slope + "x + " + (float)intercept : "y = " + (float)slope + "x - " + Math.abs((float)intercept);
        TextTitle tt = new TextTitle(linearEquation + "\nR\u00b2 = " + r2);
        tt.setTextAlignment(HorizontalAlignment.RIGHT);
        tt.setFont(this.chart.getLegend().getItemFont());
        tt.setBackgroundPaint((Paint)new Color(200, 200, 255, 100));
        tt.setFrame((BlockFrame)new BlockBorder((Paint)Color.white));
        tt.setPosition(RectangleEdge.BOTTOM);
        this.r2Annotation = new XYTitleAnnotation(0.98, 0.02, (Title)tt, RectangleAnchor.BOTTOM_RIGHT);
        this.r2Annotation.setMaxWidth(0.48);
        this.getPlot().addAnnotation((XYAnnotation)this.r2Annotation);
    }

    private XYIntervalSeries computeAcceptableDeviationData(double lowerBound, double upperBound) {
        XYSeries identity = DatasetUtils.sampleFunction2DToSeries(x -> x, (double)lowerBound, (double)upperBound, (int)100, (Comparable)((Object)"1:1 line"));
        XYIntervalSeries xyIntervalSeries = new XYIntervalSeries(identity.getKey());
        for (int i = 0; i < identity.getItemCount(); ++i) {
            XYDataItem item = identity.getDataItem(i);
            double x2 = item.getXValue();
            double y = item.getYValue();
            if (this.scatterPlotModel.showAcceptableDeviation) {
                double acceptableDeviation = this.scatterPlotModel.acceptableDeviationInterval;
                double xOff = acceptableDeviation * x2 / 100.0;
                double yOff = acceptableDeviation * y / 100.0;
                xyIntervalSeries.add(x2, x2 - xOff, x2 + xOff, y, y - yOff, y + yOff);
                continue;
            }
            xyIntervalSeries.add(x2, x2, x2, y, y, y);
        }
        return xyIntervalSeries;
    }

    private UserSettings getUserSettings(Product product) {
        if (product == null) {
            return null;
        }
        if (this.userSettingsMap.get(product) == null) {
            this.userSettingsMap.put(product, new UserSettings());
        }
        return this.userSettingsMap.get(product);
    }

    private static class UserSettings {
        Map<String, VectorDataNode> pointDataSource = new HashMap<String, VectorDataNode>();
        Map<String, AttributeDescriptor> dataField = new HashMap<String, AttributeDescriptor>();

        private UserSettings() {
        }

        public void set(String rasterName, VectorDataNode pointDataSourceValue, AttributeDescriptor dataFieldValue) {
            if (pointDataSourceValue != null && dataFieldValue != null) {
                this.pointDataSource.put(rasterName, pointDataSourceValue);
                this.dataField.put(rasterName, dataFieldValue);
            }
        }

        public VectorDataNode getPointDataSource(String rasterName) {
            return this.pointDataSource.get(rasterName);
        }

        public AttributeDescriptor getDataField(String rasterName) {
            return this.dataField.get(rasterName);
        }

        public void dispose() {
            this.pointDataSource.clear();
            this.pointDataSource = null;
            this.dataField.clear();
            this.dataField = null;
        }
    }

    static class ComputedData {
        final float x;
        final float y;
        final float lat;
        final float lon;
        final float rasterMean;
        final float rasterSigma;
        final float correlativeData;
        final Collection<Property> featureProperties;

        ComputedData(float x, float y, float lat, float lon, float rasterMean, float rasterSigma, float correlativeData, Collection<Property> featureProperties) {
            this.x = x;
            this.y = y;
            this.lat = lat;
            this.lon = lon;
            this.rasterMean = rasterMean;
            this.rasterSigma = rasterSigma;
            this.correlativeData = correlativeData;
            this.featureProperties = featureProperties;
        }
    }

    static class ScatterPlotModel {
        public boolean showRegressionLine;
        private int boxSize = 1;
        private boolean useRoiMask;
        private Mask roiMask;
        private VectorDataNode pointDataSource;
        private AttributeDescriptor dataField;
        private boolean xAxisLogScaled;
        private boolean yAxisLogScaled;
        private boolean showAcceptableDeviation;
        private double acceptableDeviationInterval = 15.0;

        ScatterPlotModel() {
        }
    }
}

