/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.binding.PropertyContainer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;

public class RefreshActionEnabler
implements PropertyChangeListener {
    private static final String PROPERTY_NAME_AUTO_MIN_MAX = "autoMinMax";
    private static final String PROPERTY_NAME_MIN = "min";
    private static final String PROPERTY_NAME_MAX = "max";
    private static final String PROPERTY_NAME_USE_ROI_MASK = "useRoiMask";
    private static final String PROPERTY_NAME_ROI_MASK = "roiMask";
    private HashSet<String> names = new HashSet();
    private List<ProductBandEnablement> productBandEnablements = new ArrayList<ProductBandEnablement>();
    private AbstractButton refreshButton;

    public RefreshActionEnabler(AbstractButton rb, String ... componentNames) {
        this.names.addAll(Arrays.asList(componentNames));
        this.refreshButton = rb;
    }

    public void addProductBandEnablement(String productPropertyName, String bandPropertyName) {
        this.addProductBandEnablement(productPropertyName, bandPropertyName, false);
    }

    public void addProductBandEnablement(String productPropertyName, String bandPropertyName, boolean isOptional) {
        this.productBandEnablements.add(new ProductBandEnablement(productPropertyName, bandPropertyName, isOptional));
        this.names.add(productPropertyName);
        this.names.add(bandPropertyName);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.names.contains(evt.getPropertyName())) {
            PropertyContainer container = (PropertyContainer)evt.getSource();
            boolean enableRefreshButton = true;
            if (evt.getPropertyName().equals(PROPERTY_NAME_USE_ROI_MASK) && evt.getNewValue().equals(true) && container.getProperty(PROPERTY_NAME_ROI_MASK).getValue() == null) {
                return;
            }
            if (evt.getPropertyName().equals(PROPERTY_NAME_AUTO_MIN_MAX) && evt.getNewValue().equals(false)) {
                return;
            }
            if (evt.getPropertyName().equals(PROPERTY_NAME_MIN) && (evt.getOldValue().equals(evt.getNewValue()) || container.getProperty(PROPERTY_NAME_AUTO_MIN_MAX).getValue().equals(true))) {
                return;
            }
            if (evt.getPropertyName().equals(PROPERTY_NAME_MAX) && (evt.getOldValue().equals(evt.getNewValue()) || container.getProperty(PROPERTY_NAME_AUTO_MIN_MAX).getValue().equals(true))) {
                return;
            }
            if (this.isFromMandatoryProduct(evt.getPropertyName()) && (evt.getOldValue() == null && evt.getNewValue() != null || evt.getOldValue() != null && evt.getNewValue() == null || !evt.getOldValue().equals(evt.getNewValue()))) {
                enableRefreshButton = false;
            } else if (this.isFromOptionalProduct(evt.getPropertyName()) && (evt.getOldValue() == null && evt.getNewValue() != null || evt.getOldValue() != null && evt.getNewValue() == null || !evt.getOldValue().equals(evt.getNewValue()))) {
                enableRefreshButton = true;
            } else if (this.isFromBand(evt.getPropertyName())) {
                if (this.notAllMandatoryBandsAreValid(container)) {
                    enableRefreshButton = false;
                } else if (evt.getOldValue() == null && evt.getNewValue() != null || evt.getOldValue() != null && evt.getNewValue() == null || !evt.getOldValue().equals(evt.getNewValue())) {
                    enableRefreshButton = true;
                }
            } else if (evt.getOldValue() == null && evt.getNewValue() == null || evt.getOldValue() != null && evt.getNewValue() != null && evt.getOldValue().equals(evt.getNewValue())) {
                return;
            }
            this.refreshButton.setEnabled(enableRefreshButton);
        }
    }

    private boolean notAllMandatoryBandsAreValid(PropertyContainer container) {
        for (ProductBandEnablement enablement : this.productBandEnablements) {
            if (container.getProperty(enablement.bandName).getValue() != null || enablement.isOptional) continue;
            return true;
        }
        return false;
    }

    private boolean isFromBand(String propertyName) {
        for (ProductBandEnablement enablement : this.productBandEnablements) {
            if (!propertyName.equals(enablement.bandName)) continue;
            return true;
        }
        return false;
    }

    private boolean isFromMandatoryProduct(String propertyName) {
        for (ProductBandEnablement enablement : this.productBandEnablements) {
            if (!propertyName.equals(enablement.productName) || enablement.isOptional) continue;
            return true;
        }
        return false;
    }

    private boolean isFromOptionalProduct(String propertyName) {
        for (ProductBandEnablement enablement : this.productBandEnablements) {
            if (!propertyName.equals(enablement.productName) || !enablement.isOptional) continue;
            return true;
        }
        return false;
    }

    private static class ProductBandEnablement {
        String productName;
        String bandName;
        boolean isOptional;

        ProductBandEnablement(String productName, String bandName, boolean isOptional) {
            this.productName = productName;
            this.bandName = bandName;
            this.isOptional = isOptional;
        }
    }
}

