/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.TransectProfileData;
import org.esa.snap.rcp.statistics.ProfilePlotPanel;
import org.esa.snap.ui.io.CsvEncoder;
import org.esa.snap.ui.io.TableModelCsvEncoder;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;

class ProfileDataTableModel
extends AbstractTableModel
implements CsvEncoder {
    private static final String REF_SUFFIX = "_ref";
    private final TransectProfileData profileData;
    private final List<String> columnNames;
    private final Map<Integer, Integer> propertyIndices;
    private final int[] pointDataIndexes;
    private final int dataFieldIndex;
    private final SimpleFeature[] features;
    private final boolean computeInBetweenPoints;

    public ProfileDataTableModel(String sampleName, TransectProfileData profileData, ProfilePlotPanel.DataSourceConfig dataSourceConfig) {
        String corrDataName;
        this.profileData = profileData;
        this.pointDataIndexes = new int[profileData.getNumPixels()];
        Arrays.fill(this.pointDataIndexes, -1);
        int[] shapeVertexIndexes = profileData.getShapeVertexIndexes();
        int i = 0;
        while (i < shapeVertexIndexes.length) {
            int shapeVertexIndex = shapeVertexIndexes[i];
            this.pointDataIndexes[shapeVertexIndex] = i++;
        }
        this.computeInBetweenPoints = dataSourceConfig.computeInBetweenPoints;
        if (dataSourceConfig.pointDataSource != null && dataSourceConfig.dataField != null) {
            corrDataName = dataSourceConfig.dataField.getLocalName();
            this.features = (SimpleFeature[])dataSourceConfig.pointDataSource.getFeatureCollection().toArray((Object[])new SimpleFeature[0]);
            this.dataFieldIndex = dataSourceConfig.pointDataSource.getFeatureType().indexOf(corrDataName);
        } else {
            corrDataName = "";
            this.features = null;
            this.dataFieldIndex = -1;
        }
        this.columnNames = new ArrayList<String>();
        this.columnNames.add("pixel_no");
        this.columnNames.add("pixel_x");
        this.columnNames.add("pixel_y");
        this.columnNames.add("latitude");
        this.columnNames.add("longitude");
        this.columnNames.add(sampleName + "_mean");
        this.columnNames.add(sampleName + "_sigma");
        this.columnNames.add((String)(corrDataName.trim().length() == 0 ? "" : corrDataName + REF_SUFFIX));
        this.propertyIndices = new HashMap<Integer, Integer>();
        if (this.features != null && this.features.length > 0) {
            int colStart = 8;
            int validPropertyCount = 0;
            Collection props = this.features[0].getProperties();
            Property[] properties = props.toArray(new Property[props.size()]);
            for (int i2 = 0; i2 < properties.length; ++i2) {
                Property property = properties[i2];
                String name = property.getName().toString();
                if (corrDataName.equals(name)) continue;
                this.columnNames.add(name + REF_SUFFIX);
                this.propertyIndices.put(8 + validPropertyCount, i2);
                ++validPropertyCount;
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    @Override
    public int getRowCount() {
        return this.computeInBetweenPoints ? this.profileData.getNumPixels() : this.profileData.getNumShapeVertices();
    }

    @Override
    public Object getValueAt(int row, int column) {
        int pixelIndex;
        int n = pixelIndex = this.computeInBetweenPoints ? row : this.profileData.getShapeVertexIndexes()[row];
        if (column == 0) {
            return pixelIndex + 1;
        }
        if (column == 1) {
            return this.profileData.getPixelPositions()[pixelIndex].getX();
        }
        if (column == 2) {
            return this.profileData.getPixelPositions()[pixelIndex].getY();
        }
        if (column == 3) {
            GeoPos[] geoPositions = this.profileData.getGeoPositions();
            return geoPositions.length > 0 ? Double.valueOf(geoPositions[pixelIndex].getLat()) : null;
        }
        if (column == 4) {
            GeoPos[] geoPositions = this.profileData.getGeoPositions();
            return geoPositions.length > 0 ? Double.valueOf(geoPositions[pixelIndex].getLon()) : null;
        }
        if (column == 5) {
            return Float.valueOf(this.profileData.getSampleValues()[pixelIndex]);
        }
        if (column == 6) {
            return Float.valueOf(this.profileData.getSampleSigmas()[pixelIndex]);
        }
        if (column == 7) {
            if (this.dataFieldIndex == -1) {
                return null;
            }
            int pointDataIndex = this.pointDataIndexes[pixelIndex];
            if (pointDataIndex == -1) {
                return null;
            }
            return this.features[pointDataIndex].getAttribute(this.dataFieldIndex);
        }
        if (column < this.getColumnCount()) {
            int pointDataIndex = this.pointDataIndexes[pixelIndex];
            if (pointDataIndex == -1) {
                return null;
            }
            Collection propColl = this.features[pointDataIndex].getProperties();
            Property[] properties = propColl.toArray(new Property[propColl.size()]);
            Integer propertyIndex = this.propertyIndices.get(column);
            return properties[propertyIndex].getValue();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public String toCsv() {
        StringWriter sw = new StringWriter();
        try {
            this.encodeCsv(sw);
            sw.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return sw.toString();
    }

    public void encodeCsv(Writer writer) throws IOException {
        new TableModelCsvEncoder((TableModel)this).encodeCsv(writer);
    }
}

