/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.core.Assert;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYShapeAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleEdge;

public class PlotAreaSelectionTool
extends MouseAdapter {
    private final ChartPanel chartPanel;
    private final Action action;
    private Point point1;
    private Point point2;
    private SelectedArea selectedArea;
    private double triggerDistance;
    private Color fillPaint;
    private AreaType areaType;

    public PlotAreaSelectionTool(ChartPanel chartPanel, Action action) {
        this.chartPanel = chartPanel;
        this.action = action;
        this.triggerDistance = 4.0;
        this.fillPaint = new Color(0, 0, 255, 50);
        this.areaType = AreaType.ELLIPSE;
    }

    public void install() {
        this.chartPanel.addMouseListener((MouseListener)this);
        this.chartPanel.addMouseMotionListener((MouseMotionListener)this);
        this.chartPanel.setMouseZoomable(false);
    }

    public void uninstall() {
        this.chartPanel.removeMouseListener((MouseListener)this);
        this.chartPanel.removeMouseMotionListener((MouseMotionListener)this);
        this.chartPanel.setMouseZoomable(true);
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public void setAreaType(AreaType areaType) {
        Assert.notNull((Object)((Object)areaType), (String)"areaType");
        this.areaType = areaType;
    }

    public double getTriggerDistance() {
        return this.triggerDistance;
    }

    public void setTriggerDistance(double triggerDistance) {
        this.triggerDistance = triggerDistance;
    }

    public Color getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Color fillPaint) {
        Assert.notNull((Object)fillPaint, (String)"fillPaint");
        this.fillPaint = fillPaint;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (!this.isButton1(event)) {
            return;
        }
        this.point1 = event.getPoint();
        this.point2 = null;
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (!this.isButton1(event)) {
            return;
        }
        if (this.selectedArea == null) {
            return;
        }
        if (this.point1 == null || this.point2 == null) {
            return;
        }
        this.action.areaSelected(this.areaType, this.selectedArea.getShape());
        this.point1 = null;
        this.point2 = null;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.point1 == null) {
            return;
        }
        if (this.point2 == null) {
            Point p2 = event.getPoint();
            if (Point.distanceSq(this.point1.getX(), this.point1.getY(), p2.getX(), p2.getY()) >= this.triggerDistance * this.triggerDistance) {
                this.point2 = p2;
                this.updateAnnotation();
            }
        } else {
            this.point2 = event.getPoint();
            this.updateAnnotation();
        }
    }

    private void updateAnnotation() {
        this.removeAnnotation();
        this.addAnnotation();
    }

    private void addAnnotation() {
        this.selectedArea = new SelectedArea(this.createShape(), this.fillPaint);
        this.chartPanel.getChart().getXYPlot().addAnnotation((XYAnnotation)this.selectedArea);
    }

    public void removeAnnotation() {
        if (this.selectedArea != null) {
            this.chartPanel.getChart().getXYPlot().removeAnnotation((XYAnnotation)this.selectedArea);
            this.selectedArea = null;
        }
    }

    private boolean isButton1(MouseEvent event) {
        return event.getButton() == 1;
    }

    private Shape createShape() {
        RectangularShape shape;
        XYPlot plot = this.chartPanel.getChart().getXYPlot();
        Rectangle2D dataArea = this.chartPanel.getScreenDataArea();
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation((AxisLocation)plot.getDomainAxisLocation(), (PlotOrientation)orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation((AxisLocation)plot.getRangeAxisLocation(), (PlotOrientation)orientation);
        double vx1 = this.areaType == AreaType.Y_RANGE ? dataArea.getX() : (double)this.point1.x;
        double vy1 = this.areaType == AreaType.X_RANGE ? dataArea.getY() : (double)this.point1.y;
        double vx2 = this.areaType == AreaType.Y_RANGE ? dataArea.getX() + dataArea.getWidth() : (double)this.point2.x;
        double vy2 = this.areaType == AreaType.X_RANGE ? dataArea.getY() + dataArea.getHeight() : (double)this.point2.y;
        double x1 = plot.getDomainAxis().java2DToValue(vx1, dataArea, domainEdge);
        double x2 = plot.getDomainAxis().java2DToValue(vx2, dataArea, domainEdge);
        double y1 = plot.getRangeAxis().java2DToValue(vy1, dataArea, rangeEdge);
        double y2 = plot.getRangeAxis().java2DToValue(vy2, dataArea, rangeEdge);
        double dx = Math.abs(x2 - x1);
        double dy = Math.abs(y2 - y1);
        if (this.areaType == AreaType.ELLIPSE) {
            shape = new Ellipse2D.Double(x1 - dx, y1 - dy, 2.0 * dx, 2.0 * dy);
        } else if (this.areaType == AreaType.RECTANGLE) {
            shape = new Rectangle2D.Double(x1 - dx, y1 - dy, 2.0 * dx, 2.0 * dy);
        } else if (this.areaType == AreaType.X_RANGE || this.areaType == AreaType.Y_RANGE) {
            shape = new Rectangle2D.Double(Math.min(x1, x2), Math.min(y1, y2), dx, dy);
        } else {
            throw new IllegalStateException("areaType = " + this.areaType);
        }
        return shape;
    }

    private static class SelectedArea
    extends XYShapeAnnotation {
        private final Shape shape;

        private SelectedArea(Shape shape, Paint fillPaint) {
            super(shape, null, null, fillPaint);
            this.shape = shape;
        }

        public Shape getShape() {
            return this.shape;
        }
    }

    public static interface Action {
        public void areaSelected(AreaType var1, Shape var2);
    }

    public static enum AreaType {
        X_RANGE,
        Y_RANGE,
        RECTANGLE,
        ELLIPSE;

    }
}

