/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.help.HelpDisplayer;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

public abstract class PagePanel
extends JPanel
implements ProductNodeListener {
    private final TopComponent parentComponent;
    private final String helpId;
    private final String title;
    private Product product;
    private boolean productChanged;
    private RasterDataNode raster;
    private boolean rasterChanged;
    private VectorDataNode vectorData;
    private boolean vectorDataChanged;
    private PagePanel alternativeView;

    protected PagePanel(TopComponent parentComponent, String helpId, String title) {
        super(new BorderLayout(4, 4));
        this.parentComponent = parentComponent;
        this.helpId = helpId;
        this.title = title;
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setPreferredSize(new Dimension(600, 320));
    }

    public String getTitle() {
        return this.title;
    }

    public VectorDataNode getVectorDataNode() {
        return this.vectorData;
    }

    public TopComponent getParentDialog() {
        return this.parentComponent;
    }

    public void nodeAdded(ProductNodeEvent event) {
    }

    public void nodeChanged(ProductNodeEvent event) {
    }

    public void nodeDataChanged(ProductNodeEvent event) {
    }

    public void nodeRemoved(ProductNodeEvent event) {
    }

    protected Product getProduct() {
        return this.product;
    }

    protected RasterDataNode getRaster() {
        return this.raster;
    }

    protected boolean isRasterChanged() {
        return this.rasterChanged;
    }

    protected boolean isProductChanged() {
        return this.productChanged;
    }

    protected boolean isVectorDataNodeChanged() {
        return this.vectorDataChanged;
    }

    protected void setRaster(RasterDataNode raster) {
        if (this.raster != raster) {
            this.raster = raster;
            this.rasterChanged = true;
        }
    }

    protected void setVectorDataNode(VectorDataNode vectorDataNode) {
        if (this.vectorData != vectorDataNode) {
            this.vectorData = vectorDataNode;
            this.vectorDataChanged = true;
        }
    }

    protected boolean mustHandleSelectionChange() {
        return this.isRasterChanged() || this.isProductChanged();
    }

    protected void handleNodeSelectionChanged() {
        this.updateComponents();
    }

    protected void handleLayerContentChanged() {
    }

    protected abstract void initComponents();

    protected abstract void updateComponents();

    protected abstract String getDataAsText();

    protected void handlePopupCreated(JPopupMenu popupMenu) {
    }

    protected boolean checkDataToClipboardCopy() {
        return true;
    }

    protected AbstractButton getHelpButton() {
        if (this.helpId != null) {
            AbstractButton helpButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Help22.png"), (boolean)false);
            helpButton.setToolTipText("Help.");
            helpButton.setName("helpButton");
            helpButton.addActionListener(e -> HelpDisplayer.show((HelpCtx)this.parentComponent.getHelpCtx()));
            return helpButton;
        }
        return null;
    }

    protected JMenuItem createCopyDataToClipboardMenuItem() {
        JMenuItem menuItem = new JMenuItem("Copy Data to Clipboard");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PagePanel.this.checkDataToClipboardCopy()) {
                    PagePanel.this.copyTextDataToClipboard();
                }
            }
        });
        return menuItem;
    }

    protected void copyTextDataToClipboard() {
        Cursor oldCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String dataAsText = this.getDataAsText();
            if (dataAsText != null) {
                SystemUtils.copyToClipboard((String)dataAsText);
            }
        }
        finally {
            this.setCursor(oldCursor);
        }
    }

    protected boolean hasAlternativeView() {
        return this.alternativeView != null;
    }

    protected void showAlternativeView() {
        TopComponent parent = (TopComponent)this.getParent();
        parent.remove((Component)this);
        this.setVisible(false);
        parent.add((Component)this.alternativeView, (Object)"Center");
        this.alternativeView.setVisible(true);
        parent.revalidate();
    }

    protected void setAlternativeView(PagePanel alternativeView) {
        this.alternativeView = alternativeView;
    }

    protected PagePanel getAlternativeView() {
        return this.alternativeView;
    }

    void selectionChanged(Product product, RasterDataNode raster, VectorDataNode vectorDataNode) {
        if (raster != this.getRaster() || product != this.getProduct() || vectorDataNode != this.getVectorDataNode()) {
            this.setRaster(raster);
            this.setProduct(product);
            this.setVectorDataNode(vectorDataNode);
            if (this.mustHandleSelectionChange()) {
                this.handleNodeSelectionChanged();
                this.rasterChanged = false;
                this.productChanged = false;
                this.vectorDataChanged = false;
            }
        }
    }

    private void maybeOpenPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(this.createCopyDataToClipboardMenuItem());
            this.handlePopupCreated(popupMenu);
            Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this);
            popupMenu.show(this, point.x, point.y);
        }
    }

    private String getProductNodeDisplayName() {
        if (this.raster != null) {
            return this.raster.getDisplayName();
        }
        if (this.product != null) {
            return this.product.getDisplayName();
        }
        return "";
    }

    private void transferProductNodeListener(Product oldProduct, Product newProduct) {
        if (oldProduct != newProduct) {
            if (oldProduct != null) {
                oldProduct.removeProductNodeListener((ProductNodeListener)this);
            }
            if (newProduct != null) {
                newProduct.addProductNodeListener((ProductNodeListener)this);
            }
        }
    }

    private void setProduct(Product product) {
        if (this.product != product) {
            this.transferProductNodeListener(this.product, product);
            this.product = product;
            this.productChanged = true;
        }
    }

    class PopupHandler
    extends MouseAdapter {
        PopupHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PagePanel.this.maybeOpenPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            PagePanel.this.maybeOpenPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PagePanel.this.maybeOpenPopup(e);
        }
    }
}

