/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;

class MetadataPlotTableModel
extends AbstractTableModel {
    private XYPlot plot;
    private List<String> columList;

    MetadataPlotTableModel(XYPlot plot) {
        this.plot = plot;
        this.columList = new ArrayList<String>();
        this.columList.add(plot.getDomainAxis().getLabel());
        for (int i = 0; i < plot.getDatasetCount(); ++i) {
            this.columList.add(String.valueOf(plot.getDataset(i).getSeriesKey(0)));
        }
    }

    @Override
    public int getRowCount() {
        return this.plot.getDataset().getItemCount(0);
    }

    @Override
    public int getColumnCount() {
        return this.columList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.plot.getDataset(columnIndex).getXValue(0, rowIndex);
        }
        XYDataset dataset = this.plot.getDataset(columnIndex - 1);
        int itemCount = dataset.getItemCount(0);
        if (rowIndex < itemCount) {
            return dataset.getYValue(0, rowIndex);
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return this.columList.get(column);
    }
}

