/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.BindingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;

class MetadataPlotSettings {
    static final String FIELD_NAME_NONE = "None";
    static final String FIELD_NAME_RECORD_INDEX = "Record Index";
    static final String FIELD_NAME_ARRAY_FIELD_INDEX = "Array Field Index [n]";
    static final String PROP_NAME_METADATA_ELEMENT = "metadataElement";
    static final String PROP_NAME_RECORD_START_INDEX = "recordStartIndex";
    static final String PROP_NAME_RECORDS_PER_PLOT = "recordsPerPlot";
    static final String PROP_NAME_FIELD_X = "fieldX";
    static final String PROP_NAME_FIELD_Y1 = "fieldY1";
    static final String PROP_NAME_FIELD_Y2 = "fieldY2";
    private MetadataElement metadataElement;
    private double recordStartIndex = 1.0;
    private int recordsPerPlot = 1;
    private String fieldX;
    private String fieldY1;
    private String fieldY2;
    private BindingContext context;
    private AtomicBoolean isSynchronising = new AtomicBoolean(false);

    public MetadataPlotSettings() {
        this.context = new BindingContext((PropertySet)PropertyContainer.createObjectBacked((Object)this, (PropertyDescriptorFactory)new ParameterDescriptorFactory()));
        Property propertyRecordStart = this.context.getPropertySet().getProperty(PROP_NAME_RECORD_START_INDEX);
        propertyRecordStart.getDescriptor().setAttribute("stepSize", (Object)1);
        Property propertyMetaElement = this.context.getPropertySet().getProperty(PROP_NAME_METADATA_ELEMENT);
        propertyMetaElement.addPropertyChangeListener(evt -> {
            try {
                if (!this.isSynchronising.getAndSet(true)) {
                    PropertySet propertySet = this.context.getPropertySet();
                    propertySet.setValue(PROP_NAME_RECORD_START_INDEX, (Object)1.0);
                    propertySet.setValue(PROP_NAME_RECORDS_PER_PLOT, (Object)1);
                    propertySet.setValue(PROP_NAME_FIELD_X, null);
                    propertySet.setValue(PROP_NAME_FIELD_Y1, null);
                    propertySet.setValue(PROP_NAME_FIELD_Y2, null);
                    List<String> usableFieldNames = MetadataPlotSettings.retrieveUsableFieldNames(this.metadataElement);
                    ArrayList<String> usableYFieldNames = new ArrayList<String>(usableFieldNames);
                    usableYFieldNames.add(0, FIELD_NAME_NONE);
                    PropertyDescriptor propertyFieldY1 = propertySet.getProperty(PROP_NAME_FIELD_Y1).getDescriptor();
                    propertyFieldY1.setValueSet(new ValueSet((Object[])usableYFieldNames.toArray(new String[0])));
                    PropertyDescriptor propertyFieldY2 = propertySet.getProperty(PROP_NAME_FIELD_Y2).getDescriptor();
                    propertyFieldY2.setValueSet(new ValueSet((Object[])usableYFieldNames.toArray(new String[0])));
                    PropertyDescriptor propertyFieldX = propertySet.getProperty(PROP_NAME_FIELD_X).getDescriptor();
                    ArrayList<String> usableXFieldNames = new ArrayList<String>(usableFieldNames);
                    usableXFieldNames.add(0, FIELD_NAME_RECORD_INDEX);
                    usableXFieldNames.add(1, FIELD_NAME_ARRAY_FIELD_INDEX);
                    propertyFieldX.setValueSet(new ValueSet((Object[])usableXFieldNames.toArray(new String[0])));
                }
            }
            finally {
                this.isSynchronising.set(false);
            }
        });
    }

    BindingContext getContext() {
        return this.context;
    }

    MetadataElement getMetadataElement() {
        return this.metadataElement;
    }

    String getNameX() {
        return this.fieldX;
    }

    public String getNameY1() {
        return this.fieldY1;
    }

    public String getFieldY2() {
        return this.fieldY2;
    }

    void setMetadataElements(MetadataElement[] elements) {
        if (elements == null) {
            this.context.getPropertySet().setDefaultValues();
            return;
        }
        Property property = this.context.getPropertySet().getProperty(PROP_NAME_METADATA_ELEMENT);
        property.getDescriptor().setValueSet(new ValueSet((Object[])this.filterElements(elements)));
        try {
            property.setValue((Object)elements[0]);
        }
        catch (ValidationException e) {
            e.printStackTrace();
        }
    }

    int getNumRecords() {
        return MetadataPlotSettings.getNumRecords(this.metadataElement);
    }

    int getRecordStartIndex() {
        return (int)this.recordStartIndex;
    }

    public int getRecordsPerPlot() {
        return this.recordsPerPlot;
    }

    static List<String> retrieveUsableFieldNames(MetadataElement element) {
        String[] attributeNames;
        int numRecords = MetadataPlotSettings.getNumRecords(element);
        if (numRecords > 1) {
            return MetadataPlotSettings.retrieveUsableFieldNames(element.getElements()[0]);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String fullAttribName : attributeNames = element.getAttributeNames()) {
            MetadataAttribute attribute;
            String fieldName = MetadataPlotSettings.getFieldName(fullAttribName);
            if (list.contains(fieldName) || !MetadataPlotSettings.isNumericType(attribute = element.getAttribute(fullAttribName))) continue;
            list.add(fieldName);
        }
        return list;
    }

    private static String getFieldName(String fullAttribName) {
        Pattern p = Pattern.compile("(.*)\\.(\\d+)");
        Matcher m = p.matcher(fullAttribName);
        String fieldName = m.matches() ? m.group(1) : fullAttribName;
        return fieldName;
    }

    private static boolean isNumericType(MetadataAttribute attribute) {
        return ProductData.isIntType((int)attribute.getDataType()) || ProductData.isFloatingPointType((int)attribute.getDataType());
    }

    private MetadataElement[] filterElements(MetadataElement[] elements) {
        return elements;
    }

    private static int getNumRecords(MetadataElement metadataElement) {
        if (metadataElement == null) {
            return 1;
        }
        int numSubElements = metadataElement.getNumElements();
        if (numSubElements > 0) {
            MetadataElement[] subElements = metadataElement.getElements();
            int count = 0;
            for (MetadataElement subElement : subElements) {
                if (!subElement.getName().matches(metadataElement.getName() + "\\.\\d+")) continue;
                ++count;
            }
            if (count == numSubElements) {
                return count;
            }
        }
        return 1;
    }
}

