/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.awt.Color;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.rcp.statistics.PagePanel;
import org.esa.snap.rcp.statistics.PlotAreaSelectionTool;
import org.jfree.chart.ChartPanel;

public abstract class MaskSelectionToolSupport
implements PlotAreaSelectionTool.Action {
    private final PagePanel pagePanel;
    private final ChartPanel chartPanel;
    private final String maskName;
    private final String maskDescription;
    private final Color maskColor;
    private final PlotAreaSelectionTool.AreaType areaType;
    private PlotAreaSelectionTool plotAreaSelectionTool;

    protected MaskSelectionToolSupport(PagePanel pagePanel, ChartPanel chartPanel, String maskName, String maskDescription, Color maskColor, PlotAreaSelectionTool.AreaType areaType) {
        this.pagePanel = pagePanel;
        this.chartPanel = chartPanel;
        this.maskName = maskName;
        this.maskDescription = maskDescription;
        this.maskColor = maskColor;
        this.areaType = areaType;
    }

    public JCheckBoxMenuItem createMaskSelectionModeMenuItem() {
        final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(String.format("Select Mask '%s'", this.maskName));
        menuItem.setName("maskSelectionMode");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (menuItem.isSelected()) {
                    if (MaskSelectionToolSupport.this.plotAreaSelectionTool == null) {
                        MaskSelectionToolSupport.this.plotAreaSelectionTool = new PlotAreaSelectionTool(MaskSelectionToolSupport.this.chartPanel, MaskSelectionToolSupport.this);
                        MaskSelectionToolSupport.this.plotAreaSelectionTool.setAreaType(MaskSelectionToolSupport.this.areaType);
                        MaskSelectionToolSupport.this.plotAreaSelectionTool.setFillPaint(MaskSelectionToolSupport.createAlphaColor(MaskSelectionToolSupport.this.maskColor, 50));
                    }
                    MaskSelectionToolSupport.this.plotAreaSelectionTool.install();
                } else if (MaskSelectionToolSupport.this.plotAreaSelectionTool != null) {
                    MaskSelectionToolSupport.this.plotAreaSelectionTool.uninstall();
                }
            }
        });
        return menuItem;
    }

    public JMenuItem createDeleteMaskMenuItem() {
        JMenuItem menuItem = new JMenuItem(String.format("Delete Mask '%s' ", this.maskName));
        menuItem.setName("deleteMask");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mask mask;
                Product product;
                if (MaskSelectionToolSupport.this.plotAreaSelectionTool != null) {
                    MaskSelectionToolSupport.this.plotAreaSelectionTool.removeAnnotation();
                }
                if ((product = MaskSelectionToolSupport.this.pagePanel.getProduct()) != null && (mask = (Mask)product.getMaskGroup().get(MaskSelectionToolSupport.this.maskName)) != null) {
                    product.getMaskGroup().remove((ProductNode)mask);
                }
            }
        });
        return menuItem;
    }

    @Override
    public void areaSelected(PlotAreaSelectionTool.AreaType areaType, Shape shape) {
        Product product = this.pagePanel.getProduct();
        RasterDataNode raster = this.pagePanel.getRaster();
        if (product == null || raster == null) {
            return;
        }
        String expression = this.createMaskExpression(areaType, shape);
        Mask mask = (Mask)product.getMaskGroup().get(this.maskName);
        if (mask != null) {
            if (!mask.getRasterSize().equals(raster.getRasterSize())) {
                product.getMaskGroup().remove((ProductNode)mask);
                mask = this.addMask(product, raster, expression);
            } else {
                mask.getImageConfig().setValue("expression", (Object)expression);
            }
        } else {
            mask = this.addMask(product, raster, expression);
        }
        ProductNodeGroup overlayMaskGroup = raster.getOverlayMaskGroup();
        if (!overlayMaskGroup.contains((ProductNode)mask)) {
            overlayMaskGroup.add((ProductNode)mask);
        }
    }

    private Mask addMask(Product product, RasterDataNode raster, String expression) {
        Mask mask = Mask.BandMathsType.create((String)this.maskName, (String)this.maskDescription, (int)raster.getRasterWidth(), (int)raster.getRasterHeight(), (String)expression, (Color)this.maskColor, (double)0.5);
        product.addMask(mask);
        ProductUtils.copyImageGeometry((RasterDataNode)raster, (RasterDataNode)mask, (boolean)false);
        return mask;
    }

    protected abstract String createMaskExpression(PlotAreaSelectionTool.AreaType var1, Shape var2);

    private static Color createAlphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }
}

