/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;

class HistogramPanelModel {
    Map<HistogramConfig, Stx> stxMap = new HashMap<HistogramConfig, Stx>(31);

    HistogramPanelModel() {
    }

    public boolean hasStx(HistogramConfig config) {
        return config != null && this.stxMap.containsKey(config);
    }

    public Stx getStx(HistogramConfig config) {
        if (!this.stxMap.containsKey(config)) {
            throw new IllegalArgumentException("No such key: " + config);
        }
        return this.stxMap.get(config);
    }

    public void setStx(HistogramConfig config, Stx stx) {
        if (this.hasStx(config)) {
            throw new IllegalArgumentException("Trying to overwrite valid stx for config: " + config);
        }
        this.stxMap.put(config, stx);
    }

    public void removeStxFromProduct(Product product) {
        ArrayList<HistogramConfig> toRemove = new ArrayList<HistogramConfig>(7);
        for (HistogramConfig histogramConfig : this.stxMap.keySet()) {
            if (histogramConfig.raster.getProduct() != product) continue;
            toRemove.add(histogramConfig);
        }
        for (HistogramConfig histogramConfig : toRemove) {
            this.stxMap.remove(histogramConfig);
        }
    }

    public void removeStx(HistogramConfig histogramPlotConfig) {
        this.stxMap.remove(histogramPlotConfig);
    }

    static class HistogramConfig {
        RasterDataNode raster;
        String roiMask;
        int numBins;
        boolean logScaledBins;

        HistogramConfig(RasterDataNode raster, String roiMask, int numBins, boolean logScaledBins) {
            this.raster = raster;
            this.roiMask = roiMask;
            this.numBins = numBins;
            this.logScaledBins = logScaledBins;
        }

        public String toString() {
            return "HistogramConfig{raster='" + this.raster + "'roiMask='" + this.roiMask + "', numBins=" + this.numBins + ", logScaledBins=" + this.logScaledBins + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HistogramConfig that = (HistogramConfig)o;
            return this.logScaledBins == that.logScaledBins && this.numBins == that.numBins && !(this.roiMask == null ? that.roiMask != null : !this.roiMask.equals(that.roiMask)) && this.raster == that.raster;
        }

        public int hashCode() {
            int result = this.roiMask != null ? this.roiMask.hashCode() : 0;
            result = 31 * result + this.numBins;
            result = 31 * result + (this.logScaledBins ? 1 : 0);
            return result;
        }
    }
}

