/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.swing.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.esa.snap.core.dataio.geocoding.ComponentGeoCoding;
import org.esa.snap.core.dataio.geocoding.GeoRaster;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.CombinedFXYGeoCoding;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.FXYGeoCoding;
import org.esa.snap.core.datamodel.GcpGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.dataop.maptransf.MapInfo;
import org.esa.snap.core.param.Parameter;
import org.esa.snap.core.util.math.FXYSum;
import org.esa.snap.rcp.statistics.PagePanel;
import org.openide.windows.TopComponent;

class GeoCodingPanel
extends PagePanel {
    private static final String DEFAULT_INFORMATION_TEXT = "No geo-coding information available.";
    private static final String TITLE_PREFIX = "Geo-Coding";
    private GeoCoding geoCoding;
    private JPanel contentPanel;
    private TableLayout contentLayout;
    private int currentRow;
    private StringBuilder dataAsTextBuilder;

    public GeoCodingPanel(TopComponent topComponent, String helpId) {
        super(topComponent, helpId, TITLE_PREFIX);
    }

    @Override
    protected boolean mustHandleSelectionChange() {
        RasterDataNode raster = this.getRaster();
        return super.mustHandleSelectionChange() || raster != null && this.geoCoding != raster.getGeoCoding();
    }

    @Override
    public void nodeChanged(ProductNodeEvent event) {
        if ("sceneGeoCoding".equals(event.getPropertyName())) {
            this.geoCoding = event.getSourceNode() instanceof Product ? this.getProduct().getSceneGeoCoding() : this.getRaster().getGeoCoding();
            this.updateComponents();
        }
    }

    @Override
    protected void initComponents() {
        this.contentPanel = new JPanel();
        this.resetContentPanel();
        JScrollPane scrollPane = new JScrollPane(this.contentPanel);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.add((Component)scrollPane, "Center");
    }

    @Override
    protected void updateComponents() {
        if (this.isVisible()) {
            this.currentRow = 0;
            this.updateContent();
            if (this.geoCoding == null) {
                this.contentLayout.setColumnWeightX(0, Double.valueOf(1.0));
                this.showNoInformationAvailableMessage();
            }
            this.updateUI();
        }
    }

    private void resetContentPanel() {
        this.contentPanel.removeAll();
        this.contentLayout = new TableLayout(6);
        this.contentLayout.setTablePadding(2, 2);
        this.contentLayout.setTableFill(TableLayout.Fill.BOTH);
        this.contentLayout.setColumnWeightX(0, Double.valueOf(0.0));
        this.contentLayout.setTableWeightX(Double.valueOf(1.0));
        this.contentLayout.setTableWeightY(Double.valueOf(0.0));
        this.contentLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        this.contentPanel.setLayout((LayoutManager)this.contentLayout);
    }

    private void showNoInformationAvailableMessage() {
        this.contentPanel.add(new JLabel(DEFAULT_INFORMATION_TEXT));
        this.contentPanel.add(this.contentLayout.createVerticalSpacer());
        this.dataAsTextBuilder.append(DEFAULT_INFORMATION_TEXT);
    }

    @Override
    protected String getDataAsText() {
        return this.dataAsTextBuilder.toString();
    }

    private void updateContent() {
        this.resetContentPanel();
        this.dataAsTextBuilder = new StringBuilder();
        RasterDataNode raster = this.getRaster();
        Product product = this.getProduct();
        boolean usingMultiGeoCodings = false;
        GeoCoding sceneGeoCoding = null;
        if (product != null) {
            usingMultiGeoCodings = this.isUsingMultiGeoCoding(product);
            sceneGeoCoding = product.getSceneGeoCoding();
        }
        PixelPos sceneCenter = new PixelPos();
        PixelPos sceneUL = new PixelPos();
        PixelPos sceneUR = new PixelPos();
        PixelPos sceneLL = new PixelPos();
        PixelPos sceneLR = new PixelPos();
        String nodeType = "";
        if (product != null) {
            if (usingMultiGeoCodings) {
                this.addEmptyRow();
                this.addRow("Some bands come with an individual geo-coding that differs from the geo-coding of the product. Select a band to see the bands individual geo-coding.");
                this.addEmptyRow();
            }
            nodeType = "product";
            this.geoCoding = sceneGeoCoding;
            sceneCenter = new PixelPos(Math.floor((double)product.getSceneRasterWidth() / 2.0) + 0.5, Math.floor((double)product.getSceneRasterHeight() / 2.0) + 0.5);
            sceneUL = new PixelPos(0.5, 0.5);
            sceneUR = new PixelPos((double)((float)(product.getSceneRasterWidth() - 1) + 0.5f), 0.5);
            sceneLL = new PixelPos(0.5, (double)((float)(product.getSceneRasterHeight() - 1) + 0.5f));
            sceneLR = new PixelPos((double)((float)(product.getSceneRasterWidth() - 1) + 0.5f), (double)((float)(product.getSceneRasterHeight() - 1) + 0.5f));
        }
        if (raster != null && usingMultiGeoCodings) {
            nodeType = "band";
            this.geoCoding = raster.getGeoCoding();
            if (sceneGeoCoding != null && this.geoCoding == sceneGeoCoding) {
                this.addEmptyRow();
                this.addRow("This band uses the same geo-coding as the product.");
                this.addEmptyRow();
            }
            sceneCenter = new PixelPos(Math.floor((double)raster.getRasterWidth() / 2.0) + 0.5, Math.floor((double)raster.getRasterHeight() / 2.0) + 0.5);
            sceneUL = new PixelPos(0.5, 0.5);
            sceneUR = new PixelPos((double)(raster.getRasterWidth() - 1) + 0.5, 0.5);
            sceneLL = new PixelPos(0.5, (double)(raster.getRasterHeight() - 1) + 0.5);
            sceneLR = new PixelPos((double)(raster.getRasterWidth() - 1) + 0.5, (double)(raster.getRasterHeight() - 1) + 0.5);
        }
        this.writeGeoCoding(this.geoCoding, sceneCenter, sceneUL, sceneUR, sceneLL, sceneLR, nodeType);
    }

    public boolean isUsingMultiGeoCoding(Product product) {
        GeoCoding geoCoding = product.getSceneGeoCoding();
        if (geoCoding == null) {
            return false;
        }
        List rasterDataNodes = product.getRasterDataNodes();
        for (RasterDataNode rasterDataNode : rasterDataNodes) {
            if (geoCoding == rasterDataNode.getGeoCoding()) continue;
            return true;
        }
        return false;
    }

    private void writeGeoCoding(GeoCoding geoCoding, PixelPos sceneCenter, PixelPos sceneUpperLeft, PixelPos sceneUpperRight, PixelPos sceneLowerLeft, PixelPos sceneLowerRight, String nodeType) {
        if (geoCoding != null) {
            GeoPos gp = new GeoPos();
            gp = geoCoding.getGeoPos(sceneCenter, gp);
            this.addRow("Center latitude", gp.getLatString());
            this.addRow("Center longitude", gp.getLonString());
            gp = geoCoding.getGeoPos(sceneUpperLeft, gp);
            this.addRow("Upper left latitude", gp.getLatString());
            this.addRow("Upper left longitude", gp.getLonString());
            gp = geoCoding.getGeoPos(sceneUpperRight, gp);
            this.addRow("Upper right latitude", gp.getLatString());
            this.addRow("Upper right longitude", gp.getLonString());
            gp = geoCoding.getGeoPos(sceneLowerLeft, gp);
            this.addRow("Lower left latitude", gp.getLatString());
            this.addRow("Lower left longitude", gp.getLonString());
            gp = geoCoding.getGeoPos(sceneLowerRight, gp);
            this.addRow("Lower right latitude", gp.getLatString());
            this.addRow("Lower right longitude", gp.getLonString());
            this.addEmptyRow();
            this.addRowWithTextField("WKT of the image CRS", geoCoding.getImageCRS().toString());
            this.addRowWithTextField("WKT of the geographical CRS", geoCoding.getGeoCRS().toString());
            this.addEmptyRow();
        }
        if (geoCoding instanceof TiePointGeoCoding) {
            this.writeTiePointGeoCoding((TiePointGeoCoding)geoCoding, nodeType);
        } else if (geoCoding instanceof ComponentGeoCoding) {
            this.writeComponentGeoCoding((ComponentGeoCoding)geoCoding, nodeType);
        } else if (geoCoding instanceof BasicPixelGeoCoding) {
            this.writePixelGeoCoding((BasicPixelGeoCoding)geoCoding, nodeType);
        } else if (geoCoding instanceof MapGeoCoding) {
            this.writeMapGeoCoding((MapGeoCoding)geoCoding, nodeType);
        } else if (geoCoding instanceof FXYGeoCoding) {
            this.writeFXYGeoCoding((FXYGeoCoding)geoCoding, nodeType);
        } else if (geoCoding instanceof CombinedFXYGeoCoding) {
            this.writeCombinedFXYGeoCoding((CombinedFXYGeoCoding)geoCoding, nodeType);
        } else if (geoCoding instanceof GcpGeoCoding) {
            this.writeGcpGeoCoding((GcpGeoCoding)geoCoding, nodeType);
        } else if (geoCoding instanceof CrsGeoCoding) {
            this.writeCrsGeoCoding((CrsGeoCoding)geoCoding, nodeType);
        } else if (geoCoding != null) {
            this.writeUnknownGeoCoding(geoCoding, nodeType);
        } else {
            this.addRow("The " + nodeType + " has no geo-coding information.");
        }
    }

    private void addHeaderRow(String content) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            b.append('=');
        }
        this.contentLayout.setCellColspan(this.currentRow++, 0, Integer.valueOf(6));
        this.contentPanel.add(this.getCorrectlyColouredLabel(b.toString()));
        this.contentLayout.setCellColspan(this.currentRow++, 0, Integer.valueOf(6));
        this.contentPanel.add(this.getCorrectlyColouredLabel(content));
        this.contentLayout.setCellColspan(this.currentRow++, 0, Integer.valueOf(6));
        this.contentPanel.add(this.getCorrectlyColouredLabel(b.toString()));
        this.dataAsTextBuilder.append(b.toString()).append("/n").append(content).append("/n").append(b.toString()).append("/n");
    }

    private void addRow(String content) {
        this.contentLayout.setCellColspan(this.currentRow++, 0, Integer.valueOf(6));
        this.contentPanel.add(this.getCorrectlyColouredLabel(content));
        this.dataAsTextBuilder.append(content).append("/n");
    }

    private void addRow(String name, String value) {
        this.contentLayout.setCellColspan(this.currentRow++, 1, Integer.valueOf(5));
        this.contentPanel.add(this.getCorrectlyColouredLabel(name));
        this.contentPanel.add(this.getCorrectlyColouredLabel(value));
        this.dataAsTextBuilder.append(name).append("/t").append(value).append("/n");
    }

    private void addRowWithTextField(String name, String value) {
        this.contentLayout.setCellColspan(this.currentRow++, 1, Integer.valueOf(5));
        this.contentPanel.add(this.getCorrectlyColouredLabel(name));
        JTextArea textArea = new JTextArea(value);
        textArea.setBackground(this.getBackgroundColor());
        textArea.setEditable(false);
        this.contentPanel.add(textArea);
        this.dataAsTextBuilder.append(name).append("/t").append(value).append("/n");
    }

    private void addEmptyRow() {
        this.contentPanel.add(this.contentLayout.createVerticalSpacer());
        ++this.currentRow;
        this.dataAsTextBuilder.append("/n");
    }

    private void addRow(String ... values) {
        for (String value : values) {
            this.contentPanel.add(this.getCorrectlyColouredLabel(value));
            this.dataAsTextBuilder.append(value).append("/t");
        }
        ++this.currentRow;
        this.dataAsTextBuilder.append("/n");
    }

    private JLabel getCorrectlyColouredLabel(String value) {
        JLabel label = new JLabel(value);
        label.setBackground(this.getBackgroundColor());
        label.setOpaque(true);
        return label;
    }

    private Color getBackgroundColor() {
        Color white = Color.WHITE;
        if (this.currentRow % 2 == 0) {
            return new Color(14 * white.getRed() / 15, 14 * white.getGreen() / 15, 14 * white.getBlue() / 15);
        }
        return white;
    }

    private void writeGcpGeoCoding(GcpGeoCoding gcpGeoCoding, String nodeType) {
        this.addEmptyRow();
        this.addRow("The " + nodeType + " uses a geo-coding which is based on ground control points (GCPs).");
        this.addEmptyRow();
        PlacemarkGroup gcpGroup = this.getProduct().getGcpGroup();
        this.addRow("Number Of GCPs", String.valueOf(gcpGroup.getNodeCount()));
        this.addRow("Function", String.valueOf(gcpGeoCoding.getMethod()));
        this.addRow("Datum", String.valueOf(gcpGeoCoding.getDatum().getName()));
        this.addRow("Latitude RMSE", String.valueOf(gcpGeoCoding.getRmseLat()));
        this.addRow("Longitude RMSE", String.valueOf(gcpGeoCoding.getRmseLon()));
        this.addEmptyRow();
        this.addRow("Table of used GCPs");
        Placemark[] gcps = (Placemark[])gcpGroup.toArray((ProductNode[])new Placemark[0]);
        this.addRow("Number", "Label", "X", "Y", "Latitude", "Longitude");
        for (int i = 0; i < gcps.length; ++i) {
            Placemark gcp = gcps[i];
            PixelPos pixelPos = gcp.getPixelPos();
            GeoPos geoPos = gcp.getGeoPos();
            this.addRow(String.valueOf(i), gcp.getLabel(), String.valueOf(pixelPos.getX()), String.valueOf(pixelPos.getY()), geoPos.getLatString(), geoPos.getLonString());
        }
    }

    private void writeCrsGeoCoding(CrsGeoCoding geoCoding, String nodeType) {
        this.addRow("The " + nodeType + " uses a geo-coding based on a cartographic map CRS.");
        this.addEmptyRow();
        this.addRow("WKT of the map CRS", geoCoding.getMapCRS().toString());
        this.addEmptyRow();
        this.addRow("Image-to-map transformation", geoCoding.getImageToMapTransform().toString());
    }

    private void writeUnknownGeoCoding(GeoCoding geoCoding, String nodeType) {
        this.addRow("The " + nodeType + " uses an unknown geo-coding implementation.");
        this.addRow("Class", geoCoding.getClass().getName());
        this.addRow("Instance", geoCoding.toString());
    }

    private void writeCombinedFXYGeoCoding(CombinedFXYGeoCoding combinedGeoCoding, String nodeType) {
        CombinedFXYGeoCoding.CodingWrapper[] codingWrappers = combinedGeoCoding.getCodingWrappers();
        this.addEmptyRow();
        this.addRow("The " + nodeType + " uses a geo-coding which consists of multiple polynomial based geo-coding.");
        this.addEmptyRow();
        this.addRow("The geo-coding uses " + codingWrappers.length + " polynomial based geo-codings");
        for (int i = 0; i < codingWrappers.length; ++i) {
            CombinedFXYGeoCoding.CodingWrapper codingWrapper = codingWrappers[i];
            Rectangle region = codingWrapper.getRegion();
            this.addHeaderRow("Geo-coding[" + (i + 1) + "]");
            this.addRow("The region in the scene which is covered by this geo-coding is defined by:");
            this.addRow("Location: X = " + region.x + ", Y = " + region.y + "\n");
            this.addRow("Dimension: W = " + region.width + ", H = " + region.height);
            this.addEmptyRow();
            FXYGeoCoding fxyGeoCoding = codingWrapper.getGeoGoding();
            this.addRow("<html>Geographic coordinates (lat,lon) are computed from pixel coordinates (x,y)<br/>by using following polynomial equations</html>");
            this.addRow(fxyGeoCoding.getLatFunction().createCFunctionCode("latitude", "x", "y"));
            this.addRow(fxyGeoCoding.getLonFunction().createCFunctionCode("longitude", "x", "y"));
            this.addEmptyRow();
            this.addRow("<html>Pixels (x,y) are computed from geographic coordinates (lat,lon)<br/>by using the following polynomial equations</html>");
            this.addRow(fxyGeoCoding.getPixelXFunction().createCFunctionCode("x", "lat", "lon"));
            this.addRow(fxyGeoCoding.getPixelYFunction().createCFunctionCode("y", "lat", "lon"));
        }
    }

    private void writeFXYGeoCoding(FXYGeoCoding fxyGeoCoding, String nodeType) {
        this.addEmptyRow();
        this.addRow("The " + nodeType + " uses a polynomial based geo-coding.");
        this.addEmptyRow();
        this.addRow("<html>Geographic coordinates (lat,lon) are computed from pixel coordinates (x,y)<br/>by using following polynomial equations</html>");
        this.addRow(fxyGeoCoding.getLatFunction().createCFunctionCode("latitude", "x", "y"));
        this.addRow(fxyGeoCoding.getLonFunction().createCFunctionCode("longitude", "x", "y"));
        this.addEmptyRow();
        this.addRow("<html>Pixels (x,y) are computed from geographic coordinates (lat,lon)<br/>by using the following polynomial equations</html>");
        this.addRow(fxyGeoCoding.getPixelXFunction().createCFunctionCode("x", "lat", "lon"));
        this.addRow(fxyGeoCoding.getPixelYFunction().createCFunctionCode("y", "lat", "lon"));
    }

    private void writeMapGeoCoding(MapGeoCoding mgc, String nodeType) {
        MapInfo mi = mgc.getMapInfo();
        this.addEmptyRow();
        this.addRow("The " + nodeType + " uses a map-projection based geo-coding.");
        this.addEmptyRow();
        this.addRow("Projection", mi.getMapProjection().getName());
        this.addRow("Projection parameters");
        Parameter[] parameters = mi.getMapProjection().getMapTransform().getDescriptor().getParameters();
        double[] parameterValues = mi.getMapProjection().getMapTransform().getParameterValues();
        for (int i = 0; i < parameters.length; ++i) {
            this.addRow(parameters[i].getName(), String.valueOf(parameterValues[i]) + " " + parameters[i].getProperties().getPhysicalUnit());
        }
        this.addEmptyRow();
        this.addRow("Map CRS Name", mgc.getMapCRS().getName().toString());
        this.addRow("Map CRS WKT");
        this.addRow(mgc.getMapCRS().toWKT());
        this.addEmptyRow();
        this.addRow("Output parameters");
        this.addRow("Datum", mi.getDatum().getName());
        this.addRow("Reference pixel X", String.valueOf(mi.getPixelX()));
        this.addRow("Reference pixel Y", String.valueOf(mi.getPixelY()));
        this.addRow("Orientation", String.valueOf(mi.getOrientation()) + " degree");
        String mapUnit = mi.getMapProjection().getMapUnit();
        this.addRow("Northing", String.valueOf(mi.getNorthing()) + " " + mapUnit);
        this.addRow("Easting", String.valueOf(mi.getEasting()) + " " + mapUnit);
        this.addRow("Pixel size X", String.valueOf(mi.getPixelSizeX()) + " " + mapUnit);
        this.addRow("Pixel size Y", String.valueOf(mi.getPixelSizeY()) + " " + mapUnit);
    }

    private void writePixelGeoCoding(BasicPixelGeoCoding gc, String nodeType) {
        this.addEmptyRow();
        this.addRow("The " + nodeType + " uses a pixel based geo-coding.");
        this.addEmptyRow();
        this.addRow("Name of latitude band", gc.getLatBand().getName());
        this.addRow("Name of longitude band", gc.getLonBand().getName());
        this.addRow("Search radius", gc.getSearchRadius() + " pixels");
        String validMask = gc.getValidMask();
        this.addRow("Valid pixel mask", validMask != null ? validMask : "");
        this.addRow("Crossing 180 degree meridian", String.valueOf(gc.isCrossingMeridianAt180()));
        this.addEmptyRow();
        this.addRow("<html>Geographic coordinates (lat,lon) are computed from pixel coordinates (x,y)<br/>by linear interpolation between pixels.</html>");
        this.addEmptyRow();
        this.addRow("<html>Pixel coordinates (x,y) are computed from geographic coordinates (lat,lon)<br/>by a search algorithm.</html>");
        this.addEmptyRow();
    }

    private void writeComponentGeoCoding(ComponentGeoCoding gc, String nodeType) {
        this.addHeaderRow("The " + nodeType + " uses a component composed geo-coding.");
        this.addRow("Type:", gc.getClass().getSimpleName());
        this.addEmptyRow();
        this.addHeaderRow("The component geo-coding consists of:");
        this.addRow("Forward coding:", gc.getForwardCoding().getKey());
        this.addRow("Inverse coding:", gc.getInverseCoding().getKey());
        this.addRow("A configured geo raster component");
        GeoRaster geoRaster = gc.getGeoRaster();
        this.addEmptyRow();
        this.addHeaderRow("The GeoRaster consists of:");
        this.addRow("Name of latitude raster:", geoRaster.getLatVariableName());
        this.addRow("Name of longitude raster:", geoRaster.getLonVariableName());
        this.addRow("Raster resolution:", geoRaster.getRasterResolutionInKm() + " in km");
        this.addRow("Number of longitude values:", "" + geoRaster.getLongitudes().length);
        this.addRow("Number of latitude values:", "" + geoRaster.getLatitudes().length);
        this.addRow("Raster width:", "" + geoRaster.getRasterWidth());
        this.addRow("Raster height:", "" + geoRaster.getRasterHeight());
        this.addRow("Scene width:", "" + geoRaster.getSceneWidth());
        this.addRow("Scene height:", "" + geoRaster.getSceneHeight());
        this.addRow("Offset X:", "" + geoRaster.getOffsetX());
        this.addRow("Offset Y:", "" + geoRaster.getOffsetY());
        this.addRow("Subsampling X:", "" + geoRaster.getSubsamplingX());
        this.addRow("Subsampling Y:", "" + geoRaster.getSubsamplingY());
        this.addEmptyRow();
        this.addHeaderRow("Additional information:");
        this.addRow("Can get geo position:", "" + gc.canGetGeoPos());
        this.addRow("Can get pixel position:", "" + gc.canGetPixelPos());
        this.addRow("Crossing 180 degree meridian", String.valueOf(gc.isCrossingMeridianAt180()));
        this.addEmptyRow();
    }

    private void writeTiePointGeoCoding(TiePointGeoCoding tgc, String nodeType) {
        this.addRow("The " + nodeType + " uses a tie-point based geo-coding.");
        this.addEmptyRow();
        this.addRow("Name of latitude tie-point grid", tgc.getLatGrid().getName());
        this.addRow("Name of longitude tie-point grid", tgc.getLonGrid().getName());
        this.addRow("Crossing 180 degree meridian", String.valueOf(tgc.isCrossingMeridianAt180()));
        this.addEmptyRow();
        this.addRow("<html>Geographic coordinates (lat,lon) are computed from pixel coordinates (x,y)<br/>by linear interpolation between tie points.</html>");
        int numApproximations = tgc.getNumApproximations();
        if (numApproximations > 0) {
            this.addRow("<html>Pixel coordinates (x,y) are computed from geographic coordinates (lat,lon)<br/>by polynomial approximations for " + numApproximations + " tile(s).</html>");
            this.addEmptyRow();
            for (int i = 0; i < numApproximations; ++i) {
                TiePointGeoCoding.Approximation approximation = tgc.getApproximation(i);
                FXYSum fX = approximation.getFX();
                FXYSum fY = approximation.getFY();
                this.addHeaderRow("Approximation for tile " + (i + 1));
                this.addRow("Center latitude", String.valueOf(approximation.getCenterLat()) + " degree");
                this.addRow("Center longitude", String.valueOf(approximation.getCenterLon()) + " degree");
                this.addRow("RMSE for X", String.valueOf(fX.getRootMeanSquareError()) + " pixels");
                this.addRow("RMSE for Y", String.valueOf(fY.getRootMeanSquareError()) + " pixels");
                this.addRow("Max. error for X", String.valueOf(fX.getMaxError()) + " pixels");
                this.addRow("Max. error for Y", String.valueOf(fY.getMaxError()) + " pixels");
            }
        } else {
            this.addEmptyRow();
            this.addRow("<html>WARNING: Pixel coordinates (x,y) cannot be computed from geographic coordinates (lat,lon)<br/>because appropriate polynomial approximations could not be found.</html>");
        }
    }
}

