/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.TextAnchor;

public class CustomLogarithmicAxis
extends LogarithmicAxis {
    static final int VERTICAL = 0;
    static final int HORIZONTAL = 1;

    public CustomLogarithmicAxis(String label) {
        super(label);
    }

    protected List refreshTicksHorizontal(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        return this.refreshTicks(edge, 1);
    }

    protected List refreshTicksVertical(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        return this.refreshTicks(edge, 0);
    }

    List refreshTicks(RectangleEdge edge, int mode) {
        ArrayList ticks = new ArrayList();
        double upperBoundVal = 0.0;
        double lowerBoundVal = 0.0;
        boolean NEGATIVE = false;
        if (this.getRange().getLowerBound() >= 0.0 && this.getRange().getUpperBound() >= 0.0) {
            upperBoundVal = this.getRange().getUpperBound();
            lowerBoundVal = this.getRange().getLowerBound();
            if (this.getRange().getLowerBound() == 0.0) {
                lowerBoundVal = 1.0E-100;
            }
        } else if (this.getRange().getLowerBound() < 0.0 && this.getRange().getUpperBound() < 0.0) {
            upperBoundVal = -1.0 * this.getRange().getLowerBound();
            lowerBoundVal = -1.0 * this.getRange().getUpperBound();
            NEGATIVE = true;
        }
        int iEndCount = (int)Math.floor(Math.log10(upperBoundVal));
        int iBegCount = lowerBoundVal == 1.0E-100 ? iEndCount - 3 : (int)Math.floor(Math.log10(lowerBoundVal));
        for (int i = iBegCount; i <= iEndCount; ++i) {
            int jEndCount = 9;
            if (i == iEndCount) {
                jEndCount = iEndCount == 0 ? (int)Math.abs(Math.floor(upperBoundVal)) : (int)(upperBoundVal / Math.pow(10.0, iEndCount));
            }
            block5: for (int j = 0; j < jEndCount; ++j) {
                boolean displayTickLabel = j == 0 || iEndCount - iBegCount < 2;
                double tickVal = Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j;
                if (NEGATIVE) {
                    tickVal *= -1.0;
                }
                String tickLabel = displayTickLabel ? NumberFormat.getNumberInstance().format(tickVal) : "";
                if (!this.tickValInRange(lowerBoundVal, upperBoundVal, tickVal, NEGATIVE)) continue;
                switch (mode) {
                    case 0: {
                        if (NEGATIVE) {
                            this.addVerticalTicks(edge, ticks, -upperBoundVal, tickLabel, tickVal);
                            continue block5;
                        }
                        this.addVerticalTicks(edge, ticks, lowerBoundVal, tickLabel, tickVal);
                        continue block5;
                    }
                    case 1: {
                        if (NEGATIVE) {
                            this.addHorizontalTicks(edge, ticks, -upperBoundVal, tickLabel, tickVal);
                            continue block5;
                        }
                        this.addHorizontalTicks(edge, ticks, lowerBoundVal, tickLabel, tickVal);
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Illegal axis orientation - cannot add ticks");
                    }
                }
            }
        }
        return ticks;
    }

    private boolean tickValInRange(double lowerBoundVal, double upperBoundVal, double tickVal, boolean negative) {
        if (negative) {
            return -upperBoundVal <= tickVal && -lowerBoundVal >= tickVal;
        }
        return lowerBoundVal <= tickVal && upperBoundVal >= tickVal;
    }

    private void addHorizontalTicks(RectangleEdge edge, List ticks, double lowerBoundVal, String tickLabel, double tickVal) {
        if (tickVal >= lowerBoundVal - 1.0E-100) {
            TextAnchor rotationAnchor;
            TextAnchor anchor;
            double angle = 0.0;
            if (this.isVerticalTickLabels()) {
                anchor = TextAnchor.CENTER_RIGHT;
                rotationAnchor = TextAnchor.CENTER_RIGHT;
                angle = edge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
            } else if (edge == RectangleEdge.TOP) {
                anchor = TextAnchor.BOTTOM_CENTER;
                rotationAnchor = TextAnchor.BOTTOM_CENTER;
            } else {
                anchor = TextAnchor.TOP_CENTER;
                rotationAnchor = TextAnchor.TOP_CENTER;
            }
            ticks.add(new NumberTick((Number)new Double(tickVal), tickLabel, anchor, rotationAnchor, angle));
        }
    }

    private void addVerticalTicks(RectangleEdge edge, List ticks, double lowerBoundVal, String tickLabel, double tickVal) {
        if (tickVal >= lowerBoundVal - 1.0E-100) {
            TextAnchor rotationAnchor;
            TextAnchor anchor;
            double angle = 0.0;
            if (this.isVerticalTickLabels()) {
                if (edge == RectangleEdge.LEFT) {
                    anchor = TextAnchor.BOTTOM_CENTER;
                    rotationAnchor = TextAnchor.BOTTOM_CENTER;
                    angle = -1.5707963267948966;
                } else {
                    anchor = TextAnchor.BOTTOM_CENTER;
                    rotationAnchor = TextAnchor.BOTTOM_CENTER;
                    angle = 1.5707963267948966;
                }
            } else if (edge == RectangleEdge.LEFT) {
                anchor = TextAnchor.CENTER_RIGHT;
                rotationAnchor = TextAnchor.CENTER_RIGHT;
            } else {
                anchor = TextAnchor.CENTER_LEFT;
                rotationAnchor = TextAnchor.CENTER_LEFT;
            }
            ticks.add(new NumberTick((Number)new Double(tickVal), tickLabel, anchor, rotationAnchor, angle));
        }
    }
}

