/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.spectrum;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelModel;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Comparator;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.math.IndexValidator;
import org.esa.snap.core.util.math.Range;
import org.esa.snap.ui.diagram.AbstractDiagramGraph;

class SpectrumGraph
extends AbstractDiagramGraph {
    private Placemark placemark;
    private Band[] bands;
    private double[] energies;
    private double[] wavelengths;
    private final Range energyRange;
    private final Range wavelengthRange;

    SpectrumGraph(Placemark placemark, Band[] bands) {
        Debug.assertNotNull((Object)bands);
        this.placemark = placemark;
        this.bands = bands;
        this.energyRange = new Range();
        this.wavelengthRange = new Range();
        this.setBands(bands);
    }

    public Placemark getPlacemark() {
        return this.placemark;
    }

    public String getXName() {
        return "Wavelength";
    }

    public String getYName() {
        return this.placemark != null ? this.placemark.getLabel() : "Cursor";
    }

    public int getNumValues() {
        return this.bands.length;
    }

    public double getXValueAt(int index) {
        return this.wavelengths[index];
    }

    public double getYValueAt(int index) {
        if (this.energies[index] == this.bands[index].getGeophysicalNoDataValue()) {
            return Double.NaN;
        }
        return this.energies[index];
    }

    public double getXMin() {
        return this.wavelengthRange.getMin();
    }

    public double getXMax() {
        return this.wavelengthRange.getMax();
    }

    public double getYMin() {
        return this.energyRange.getMin();
    }

    public double getYMax() {
        return this.energyRange.getMax();
    }

    public Band[] getBands() {
        return this.bands;
    }

    public void setBands(Band[] bands) {
        Debug.assertNotNull((Object)bands);
        this.bands = (Band[])bands.clone();
        Arrays.sort(this.bands, new Comparator<Band>(){

            @Override
            public int compare(Band band1, Band band2) {
                float v = band1.getSpectralWavelength() - band2.getSpectralWavelength();
                return v < 0.0f ? -1 : (v > 0.0f ? 1 : 0);
            }
        });
        if (this.wavelengths == null || this.wavelengths.length != this.bands.length) {
            this.wavelengths = new double[this.bands.length];
        }
        if (this.energies == null || this.energies.length != this.bands.length) {
            this.energies = new double[this.bands.length];
        }
        for (int i = 0; i < this.wavelengths.length; ++i) {
            this.wavelengths[i] = this.bands[i].getSpectralWavelength();
            this.energies[i] = 0.0;
        }
        Range.computeRangeDouble((double[])this.wavelengths, (IndexValidator)IndexValidator.TRUE, (Range)this.wavelengthRange, (ProgressMonitor)ProgressMonitor.NULL);
        Range.computeRangeDouble((double[])this.energies, (IndexValidator)IndexValidator.TRUE, (Range)this.energyRange, (ProgressMonitor)ProgressMonitor.NULL);
    }

    public void readValues() {
        Debug.assertNotNull((Object)this.bands);
        for (int i = 0; i < this.bands.length; ++i) {
            Band band = this.bands[i];
            if (this.placemark == null) continue;
            MultiLevelModel multiLevelModel = band.getMultiLevelModel();
            AffineTransform i2mTransform = multiLevelModel.getImageToModelTransform(0);
            AffineTransform m2iTransform = multiLevelModel.getModelToImageTransform(0);
            Point2D modelPixel = i2mTransform.transform((Point2D)this.placemark.getPixelPos(), null);
            Point2D imagePixel = m2iTransform.transform(modelPixel, null);
            int pixelX = (int)Math.floor(imagePixel.getX());
            int pixelY = (int)Math.floor(imagePixel.getY());
            this.energies[i] = this.getSample(band, pixelX, pixelY, 0);
        }
        IndexValidator validator = new IndexValidator(){

            public boolean validateIndex(int index) {
                return SpectrumGraph.this.energies[index] != SpectrumGraph.this.bands[index].getGeophysicalNoDataValue();
            }
        };
        Range.computeRangeDouble((double[])this.energies, (IndexValidator)validator, (Range)this.energyRange, (ProgressMonitor)ProgressMonitor.NULL);
    }

    private double getSample(Band band, int pixelX, int pixelY, int level) {
        return ProductUtils.getGeophysicalSampleAsDouble((RasterDataNode)band, (int)pixelX, (int)pixelY, (int)level);
    }

    public void dispose() {
        this.placemark = null;
        this.bands = null;
        this.energies = null;
        this.wavelengths = null;
        super.dispose();
    }
}

