/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.session;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class ShapeConverter
implements Converter {
    private final GeometryFactory geometryFactory = new GeometryFactory();

    public Class getValueType() {
        return Shape.class;
    }

    public Object parse(String text) throws ConversionException {
        try {
            Geometry geometry = new WKTReader(this.geometryFactory).read(text);
            if (geometry instanceof LineString) {
                LineString lineString = (LineString)geometry;
                return null;
            }
            if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                return null;
            }
            throw new ConversionException("Failed to parse shape geometry WKT.");
        }
        catch (ParseException e) {
            throw new ConversionException("Failed to parse shape geometry WKT.", (Throwable)e);
        }
    }

    public String format(Object value) {
        Shape shape = (Shape)value;
        PathIterator pathIterator = shape.getPathIterator(null, 1.0);
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        double[] coord = new double[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coord);
            if (type == 0) {
                this.coordinatesToGeometry(coordinates, geometries);
                coordinates.add(new Coordinate(coord[0], coord[1]));
            } else if (type == 1) {
                coordinates.add(new Coordinate(coord[0], coord[1]));
            } else if (type == 4 && coordinates.size() > 0) {
                if (!coordinates.get(0).equals((Object)coordinates.get(coordinates.size() - 1))) {
                    coordinates.add(coordinates.get(0));
                }
                this.coordinatesToGeometry(coordinates, geometries);
            }
            pathIterator.next();
        }
        this.coordinatesToGeometry(coordinates, geometries);
        if (geometries.isEmpty()) {
            return "";
        }
        if (geometries.get(0) instanceof LinearRing) {
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            for (int i = 1; i < geometries.size(); ++i) {
                Geometry geometry = geometries.get(i);
                if (!(geometry instanceof LinearRing)) continue;
                holes.add((LinearRing)geometry);
            }
            if (holes.size() == geometries.size() - 1) {
                return this.geometryFactory.createPolygon((LinearRing)geometries.get(0), holes.toArray(new LinearRing[holes.size()])).toText();
            }
        }
        if (geometries.size() == 1) {
            return geometries.get(0).toText();
        }
        return this.geometryFactory.createGeometryCollection(geometries.toArray(new Geometry[geometries.size()])).toText();
    }

    private void coordinatesToGeometry(ArrayList<Coordinate> coordinates, ArrayList<Geometry> geometries) {
        if (coordinates.size() > 0) {
            if (coordinates.get(0).equals((Object)coordinates.get(coordinates.size() - 1))) {
                LinearRing linearRing = this.geometryFactory.createLinearRing(coordinates.toArray(new Coordinate[coordinates.size()]));
                geometries.add((Geometry)linearRing);
            } else {
                LineString lineString = this.geometryFactory.createLineString(coordinates.toArray(new Coordinate[coordinates.size()]));
                geometries.add((Geometry)lineString);
            }
            coordinates.clear();
        }
    }
}

