/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.session;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.SaveProductAction;
import org.esa.snap.rcp.session.Bundle;
import org.esa.snap.rcp.session.Session;
import org.esa.snap.rcp.session.SessionIO;
import org.esa.snap.rcp.session.SessionManager;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.product.ProductNodeView;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class SaveSessionAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    public static final String ID = "saveSession";
    private static final String TITLE = "Save Session As";
    private final Lookup.Result<ProductNode> result;
    private final Lookup lookup;
    private ProductManager productManager;

    public SaveSessionAction() {
        this(Utilities.actionsGlobalContext());
    }

    public SaveSessionAction(Lookup lookup) {
        super(Bundle.CTL_SaveSessionAction_MenuText());
        this.lookup = lookup;
        this.result = lookup.lookupResult(ProductNode.class);
        ProductManager productManager = SnapApp.getDefault().getProductManager();
        productManager.addListener((ProductManager.Listener)new SaveSessionListener());
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnabled(false);
    }

    @Override
    public final void actionPerformed(ActionEvent event) {
        this.saveSession(false);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new SaveSessionAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        ProductNode productNode = (ProductNode)this.lookup.lookup(ProductNode.class);
        this.setEnabled(productNode != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSession(boolean saveAs) {
        SessionManager app = SessionManager.getDefault();
        File sessionFile = app.getSessionFile();
        if ((sessionFile == null || saveAs) && (sessionFile = Dialogs.requestFileForSave(TITLE, false, (FileFilter)SessionManager.getDefault().getSessionFileFilter(), SessionManager.getDefault().getSessionFileFilter().getDefaultExtension(), sessionFile != null ? sessionFile.getName() : System.getProperty("user.name", "noname"), null, "beam.lastSessionDir")) == null) {
            return;
        }
        if (!this.saveProductsOrLetItBe(sessionFile)) {
            return;
        }
        app.setSessionFile(sessionFile);
        try {
            Session session = SaveSessionAction.createSession(sessionFile);
            SessionIO.getInstance().writeSession(session, sessionFile);
            Dialogs.showInformation(TITLE, "Session saved.", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Dialogs.showError(TITLE, e.getMessage());
        }
    }

    public void saveSessionAsQuitely(File newSessionFile) {
        if (!this.saveProductsOrLetItBe(newSessionFile)) {
            return;
        }
        try {
            Session session = SaveSessionAction.createSession(newSessionFile);
            SessionIO.getInstance().writeSession(session, newSessionFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            Dialogs.showError(TITLE, e.getMessage());
        }
    }

    private boolean saveProductsOrLetItBe(File sessionFile) {
        Dialogs.Answer answer;
        String message;
        Product[] products;
        for (Product product : products = SnapApp.getDefault().getProductManager().getProducts()) {
            if (product.getFileLocation() != null) continue;
            message = MessageFormat.format("The following product has not been saved yet:\n{0}.\nDo you want to save it now?\n\nNote: If you select 'No', the session cannot be saved.", product.getDisplayName());
            answer = Dialogs.requestDecision(TITLE, message, false, null);
            if (answer == Dialogs.Answer.YES) {
                File sessionDir = sessionFile.getAbsoluteFile().getParentFile();
                product.setFileLocation(new File(sessionDir, product.getName() + ".dim"));
                SaveProductAction saveProductAction = new SaveProductAction((ProductNode)product);
                saveProductAction.execute();
                continue;
            }
            return false;
        }
        for (Product product : products) {
            if (!product.isModified()) continue;
            message = MessageFormat.format("The following product has been modified:\n{0}.\nDo you want to save it now?\n\nNote: It is recommended to save the product in order to \nfully restore the session later.", product.getDisplayName());
            answer = Dialogs.requestDecision(TITLE, message, false, null);
            if (answer == Dialogs.Answer.YES) {
                SaveProductAction saveProductAction = new SaveProductAction((ProductNode)product);
                saveProductAction.execute();
                continue;
            }
            if (answer != Dialogs.Answer.YES) continue;
            return false;
        }
        return true;
    }

    private static Session createSession(File sessionFile) {
        ArrayList nodeViews = new ArrayList();
        return new Session(sessionFile.getParentFile().toURI(), SnapApp.getDefault().getProductManager().getProducts(), nodeViews.toArray(new ProductNodeView[nodeViews.size()]));
    }

    private class SaveSessionListener
    implements ProductManager.Listener {
        private SaveSessionListener() {
        }

        public void productAdded(ProductManager.Event event) {
            this.updateEnableState();
        }

        public void productRemoved(ProductManager.Event event) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            SaveSessionAction.this.setEnabled(SnapApp.getDefault().getProductManager().getProductCount() > 0);
        }
    }
}

