/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.quicklooks;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import net.coobird.thumbnailator.makers.FixedSizeThumbnailMaker;
import org.esa.snap.core.datamodel.quicklooks.Thumbnail;
import org.esa.snap.rcp.quicklooks.DragScrollListener;

public class ThumbnailPanel
extends JPanel {
    private static final int imgWidth = 200;
    private static final int imgHeight = 200;
    private static final int margin = 6;
    private static final BasicStroke thickStroke = new BasicStroke(5.0f);
    private static final String vkControl = "VK_CONTROL";
    private final boolean multiRow;
    private SelectionMode selectionMode;
    private List<ThumbnailDrawing> selection;
    private boolean ctrlPressed;

    public ThumbnailPanel(boolean multiRow) {
        super(new FlowLayout(3));
        this.multiRow = multiRow;
        this.selectionMode = SelectionMode.RECT;
        this.selection = new ArrayList<ThumbnailDrawing>();
        DragScrollListener dragScrollListener = new DragScrollListener(this);
        dragScrollListener.setDraggableElements(2);
        this.addMouseListener(dragScrollListener);
        this.addMouseMotionListener(dragScrollListener);
        this.setKeyBindings();
    }

    private void setKeyBindings() {
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(17, 128), "VK_CONTROLDOWN");
        inputMap.put(KeyStroke.getKeyStroke("released CONTROL"), "VK_CONTROLUP");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("VK_CONTROLDOWN", new KeyAction("VK_CONTROLDOWN"));
        actionMap.put("VK_CONTROLUP", new KeyAction("VK_CONTROLUP"));
    }

    public void update(Thumbnail[] imageList) {
        this.removeAll();
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        if (imageList.length == 0) {
            this.setPreferredSize(new Dimension(width, 212));
            JLabel label = new JLabel("");
            this.add(label);
        } else {
            if (this.multiRow) {
                int numImages = 1;
                int effectiveImageWidth = 200 * numImages + 6;
                int numCol = Math.max(width / effectiveImageWidth, 1);
                int numRow = (int)Math.ceil((double)imageList.length / (double)numCol);
                int preferredWidth = effectiveImageWidth * numCol + 6;
                int preferredHeight = 206 * numRow + 6;
                this.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
            }
            for (Thumbnail thumbnail : imageList) {
                this.add(new ThumbnailDrawing(this, thumbnail));
            }
        }
        this.updateUI();
    }

    private void setSelection(ThumbnailDrawing item) {
        if (this.selection.contains(item)) {
            this.selection.remove(item);
        } else if (this.ctrlPressed) {
            this.selection.add(item);
        } else {
            this.selection.clear();
            this.selection.add(item);
        }
        this.onSelectionChanged();
    }

    public void onSelectionChanged() {
    }

    public void onOpenAction() {
    }

    public void selectAll() {
        this.selection.clear();
        for (Component component : this.getComponents()) {
            this.selection.add((ThumbnailDrawing)component);
        }
        this.repaint();
    }

    public void clearSelection() {
        this.selection.clear();
        this.repaint();
    }

    public ThumbnailDrawing[] getSelection() {
        return this.selection.toArray(new ThumbnailDrawing[this.selection.size()]);
    }

    private boolean isSelected(ThumbnailDrawing item) {
        return this.selection.contains(item);
    }

    public class ThumbnailDrawing
    extends JLabel
    implements MouseListener,
    Thumbnail.ThumbnailListener {
        private final ThumbnailPanel parent;
        private final Thumbnail thumbnail;

        public ThumbnailDrawing(ThumbnailPanel parent, Thumbnail thumbnail) {
            this.parent = parent;
            this.thumbnail = thumbnail;
            this.thumbnail.addListener((Thumbnail.ThumbnailListener)this);
            this.setPreferredSize(new Dimension(200, 200));
            this.setToolTipText("");
            this.addMouseListener(this);
        }

        public Thumbnail getThumbnail() {
            return this.thumbnail;
        }

        public void notifyImageUpdated(Thumbnail thumbnail) {
            this.parent.repaint();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, 200, 200);
            if (this.thumbnail.hasImage() || this.thumbnail.hasCachedImage()) {
                this.drawIcon(g, this.thumbnail.getImage(ProgressMonitor.NULL));
            } else {
                this.drawIcon(g, null);
            }
            if (ThumbnailPanel.this.isSelected(this) && ThumbnailPanel.this.selectionMode == SelectionMode.RECT) {
                this.drawSelected(g);
            }
        }

        private void drawIcon(Graphics2D g, BufferedImage icon) {
            if (icon != null) {
                BufferedImage img = new FixedSizeThumbnailMaker().size(200, 200).keepAspectRatio(true).fitWithinDimensions(true).make(icon);
                int xOff = (200 - img.getWidth()) / 2;
                int yOff = (200 - img.getHeight()) / 2;
                g.drawImage(img, xOff, yOff, img.getWidth(), img.getHeight(), null);
            } else {
                g.setColor(Color.DARK_GRAY);
                g.setStroke(thickStroke);
                g.drawLine(0, 0, 200, 200);
                g.drawLine(200, 0, 0, 200);
                g.drawRect(0, 0, 199, 199);
            }
        }

        private void drawSelected(Graphics2D g) {
            g.setColor(new Color(0, 100, 255));
            g.setStroke(thickStroke);
            g.drawRect(0, 0, 200, 200);
            for (int i = 0; i <= 20; ++i) {
                int alpha = 40 - i * 2;
                g.setColor(new Color(0, 100, 255, alpha));
                g.drawRoundRect(i, i, 200 - i - i, 200 - i - i, 25, 25);
            }
        }

        @Override
        public Point getToolTipLocation(MouseEvent e) {
            return new Point(-700, 0);
        }

        @Override
        public JToolTip createToolTip() {
            if (!this.thumbnail.hasImage() || !this.thumbnail.hasCachedImage()) {
                return super.createToolTip();
            }
            BufferedImage thumbnailImage = this.thumbnail.getImage(ProgressMonitor.NULL);
            final BufferedImage img = new FixedSizeThumbnailMaker().size(600, 600).keepAspectRatio(true).fitWithinDimensions(true).make(thumbnailImage);
            JToolTip toolTip = new JToolTip(){
                {
                    this.setLayout(new BorderLayout());
                    this.add(new JLabel(new ImageIcon(img)));
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(img.getWidth(), img.getHeight());
                }
            };
            return toolTip;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                ThumbnailPanel.this.onOpenAction();
            } else if (e.getButton() == 1) {
                ThumbnailPanel.this.setSelection(this);
                this.parent.repaint();
            } else if (e.getButton() == 3) {
                // empty if block
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class KeyAction
    extends AbstractAction {
        public KeyAction(String actionCommand) {
            this.putValue("ActionCommandKey", actionCommand);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            ThumbnailPanel.this.ctrlPressed = cmd.equals("VK_CONTROLDOWN");
        }
    }

    private static enum SelectionMode {
        CHECK,
        RECT;

    }
}

