/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.quicklooks;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;

public class DragScrollListener
implements MouseListener,
MouseMotionListener {
    public static final int DRAGABLE_HORIZONTAL_SCROLL_BAR = 1;
    public static final int DRAGABLE_VERTICAL_SCROLL_BAR = 2;
    private int scrollingIntensity = 10;
    private double damping = 0.05;
    private int animationSpeed = 20;
    private Timer animationTimer = null;
    private long lastDragTime = 0L;
    private Point lastDragPoint = null;
    private double pixelsPerMSX;
    private double pixelsPerMSY;
    private int scrollBarMask = 3;
    private final Component draggableComponent;
    private JScrollPane scroller = null;
    private Cursor defaultCursor;
    private List<Point2D> dragSpeeds = new ArrayList<Point2D>();

    public DragScrollListener(Component c) {
        this.draggableComponent = c;
        this.defaultCursor = this.draggableComponent.getCursor();
        this.draggableComponent.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                DragScrollListener.this.setScroller();
                DragScrollListener.this.defaultCursor = DragScrollListener.this.draggableComponent.getCursor();
            }
        });
        this.setScroller();
    }

    private void setScroller() {
        Component c = this.getParentScroller(this.draggableComponent);
        this.scroller = c != null ? (JScrollPane)c : null;
    }

    public void setDraggableElements(int mask) {
        this.scrollBarMask = mask;
    }

    public void setScrollingIntensity(int intensity) {
        this.scrollingIntensity = intensity;
    }

    public void setAnimationTiming(int timing) {
        this.animationSpeed = timing;
    }

    public void setDamping(double damping) {
        this.damping = damping;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.animationTimer != null && this.animationTimer.isRunning()) {
            this.animationTimer.stop();
        }
        this.draggableComponent.setCursor(new Cursor(13));
        this.dragSpeeds.clear();
        this.lastDragPoint = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.draggableComponent.setCursor(this.defaultCursor);
        if (this.scroller == null) {
            return;
        }
        long durationSinceLastDrag = System.currentTimeMillis() - this.lastDragTime;
        if (durationSinceLastDrag > 20L) {
            return;
        }
        this.pixelsPerMSX = 0.0;
        this.pixelsPerMSY = 0.0;
        int j = 0;
        int i = this.dragSpeeds.size() - 1;
        while (i >= 0 && i > this.dragSpeeds.size() - 6) {
            this.pixelsPerMSX += this.dragSpeeds.get(i).getX();
            this.pixelsPerMSY += this.dragSpeeds.get(i).getY();
            --i;
            ++j;
        }
        this.pixelsPerMSX /= -((double)j);
        this.pixelsPerMSY /= -((double)j);
        if (Math.abs(this.pixelsPerMSX) > 0.0 || Math.abs(this.pixelsPerMSY) > 0.0) {
            this.animationTimer = new Timer(this.animationSpeed, new ScrollAnimator());
            this.animationTimer.start();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.scroller == null) {
            return;
        }
        Point p = e.getPoint();
        int diffx = p.x - this.lastDragPoint.x;
        int diffy = p.y - this.lastDragPoint.y;
        this.lastDragPoint = e.getPoint();
        if ((this.scrollBarMask & 1) != 0) {
            this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getValue() - diffx);
        }
        this.lastDragPoint.x -= diffx;
        if ((this.scrollBarMask & 2) != 0) {
            this.getVerticalScrollBar().setValue(this.getVerticalScrollBar().getValue() - diffy);
        }
        this.lastDragPoint.y -= diffy;
        this.dragSpeeds.add(new Point2D.Double(e.getPoint().x - this.lastDragPoint.x, e.getPoint().y - this.lastDragPoint.y));
        this.lastDragTime = System.currentTimeMillis();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private JScrollBar getHorizontalScrollBar() {
        return this.scroller.getHorizontalScrollBar();
    }

    private JScrollBar getVerticalScrollBar() {
        return this.scroller.getVerticalScrollBar();
    }

    private Component getParentScroller(Component c) {
        Container parent = c.getParent();
        if (parent != null && parent instanceof Component) {
            Container parentC = parent;
            if (parentC instanceof JScrollPane) {
                return parentC;
            }
            return this.getParentScroller(parentC);
        }
        return null;
    }

    private class ScrollAnimator
    implements ActionListener {
        private ScrollAnimator() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DragScrollListener.this.pixelsPerMSX -= DragScrollListener.this.pixelsPerMSX * DragScrollListener.this.damping;
            DragScrollListener.this.pixelsPerMSY -= DragScrollListener.this.pixelsPerMSY * DragScrollListener.this.damping;
            if (Math.abs(DragScrollListener.this.pixelsPerMSX) < 0.01 && Math.abs(DragScrollListener.this.pixelsPerMSY) < 0.01) {
                DragScrollListener.this.animationTimer.stop();
                return;
            }
            int nValX = DragScrollListener.this.getHorizontalScrollBar().getValue() + (int)(DragScrollListener.this.pixelsPerMSX * (double)DragScrollListener.this.scrollingIntensity);
            int nValY = DragScrollListener.this.getVerticalScrollBar().getValue() + (int)(DragScrollListener.this.pixelsPerMSY * (double)DragScrollListener.this.scrollingIntensity);
            if (nValX <= 0) {
                nValX = 0;
            } else if (nValX >= DragScrollListener.this.getHorizontalScrollBar().getMaximum()) {
                nValX = DragScrollListener.this.getHorizontalScrollBar().getMaximum();
            }
            if (nValY <= 0) {
                nValY = 0;
            } else if (nValY >= DragScrollListener.this.getVerticalScrollBar().getMaximum()) {
                nValY = DragScrollListener.this.getVerticalScrollBar().getMaximum();
            }
            if ((nValX == 0 || nValX == DragScrollListener.this.getHorizontalScrollBar().getMaximum()) && Math.abs(DragScrollListener.this.pixelsPerMSY) < 1.0) {
                DragScrollListener.this.animationTimer.stop();
                return;
            }
            if ((nValY == 0 || nValY == DragScrollListener.this.getVerticalScrollBar().getMaximum()) && Math.abs(DragScrollListener.this.pixelsPerMSX) < 1.0) {
                DragScrollListener.this.animationTimer.stop();
                return;
            }
            if ((DragScrollListener.this.scrollBarMask & 1) != 0) {
                DragScrollListener.this.getHorizontalScrollBar().setValue(nValX);
            }
            if ((DragScrollListener.this.scrollBarMask & 2) != 0) {
                DragScrollListener.this.getVerticalScrollBar().setValue(nValY);
            }
        }
    }
}

