/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.preferences.layer;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.Enablement;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import com.bc.ceres.swing.binding.PropertyPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JPanel;
import org.esa.snap.core.layer.GraticuleLayerType;
import org.esa.snap.rcp.preferences.DefaultConfigController;
import org.esa.snap.rcp.preferences.Preference;
import org.openide.util.HelpCtx;

public final class GraticuleLayerController
extends DefaultConfigController {
    Property restoreDefaults;
    Enablement enablementGridlinesWidth;
    Enablement enablementGridlinesDashedPhase;
    Enablement enablementGridlinesTransparency;
    Enablement enablementGridlinesColor;
    Enablement enablementTickmarksInside;
    Enablement enablementTickmarksLength;
    Enablement enablementTickmarksColor;
    Enablement enablementBorderWidth;
    Enablement enablementBorderColor;
    boolean propertyValueChangeEventsEnabled = true;

    @Override
    protected PropertySet createPropertySet() {
        return this.createPropertySet(new GraticuleBean());
    }

    @Override
    protected JPanel createPanel(BindingContext context) {
        this.initPropertyDefaults(context, "graticule.grid.spacing.section", true);
        this.initPropertyDefaults(context, "graticule.spacing.lat", 0.0);
        this.initPropertyDefaults(context, "graticule.spacing.lon", 0.0);
        this.initPropertyDefaults(context, "graticule.labels.section", true);
        this.initPropertyDefaults(context, "graticule.labels.north", true);
        this.initPropertyDefaults(context, "graticule.labels.south", true);
        this.initPropertyDefaults(context, "graticule.labels.west", true);
        this.initPropertyDefaults(context, "graticule.labels.east", true);
        this.initPropertyDefaults(context, "graticule.labels.suffix.nswe", true);
        this.initPropertyDefaults(context, "graticule.labels.decimal.value", false);
        this.initPropertyDefaults(context, "graticule.labels.inside", false);
        this.initPropertyDefaults(context, "graticule.labels.font.italic", false);
        this.initPropertyDefaults(context, "graticule.labels.font.bold", false);
        this.initPropertyDefaults(context, "graticule.labels.font.name", "SanSerif");
        this.initPropertyDefaults(context, "graticule.labels.rotation.lon", 45.0);
        this.initPropertyDefaults(context, "graticule.labels.rotation.lat", 0.0);
        this.initPropertyDefaults(context, "graticule.labels.size", 12);
        this.initPropertyDefaults(context, "graticule.labels.color", GraticuleLayerType.PROPERTY_LABELS_COLOR_DEFAULT);
        this.initPropertyDefaults(context, "graticule.gridlines.section", true);
        this.initPropertyDefaults(context, "graticule.gridlines.show", true);
        this.initPropertyDefaults(context, "graticule.gridlines.width", 0.8);
        this.initPropertyDefaults(context, "graticule.gridlines.dashed.phase", 3.0);
        this.initPropertyDefaults(context, "graticule.gridlines.transparency", 0.6);
        this.initPropertyDefaults(context, "graticule.gridlines.color", GraticuleLayerType.PROPERTY_GRIDLINES_COLOR_DEFAULT);
        this.initPropertyDefaults(context, "graticule.border.section", true);
        this.initPropertyDefaults(context, "graticule.border.show", true);
        this.initPropertyDefaults(context, "graticule.border.width", 1.2);
        this.initPropertyDefaults(context, "graticule.border.color", GraticuleLayerType.PROPERTY_BORDER_COLOR_DEFAULT);
        this.initPropertyDefaults(context, "graticule.tickmarks.section", true);
        this.initPropertyDefaults(context, "graticule.tickmarks.show", true);
        this.initPropertyDefaults(context, "graticule.tickmarks.inside", false);
        this.initPropertyDefaults(context, "graticule.tickmarks.length", 3.0);
        this.initPropertyDefaults(context, "graticule.tickmarks.color", GraticuleLayerType.PROPERTY_TICKMARKS_COLOR_DEFAULT);
        this.initPropertyDefaults(context, "graticule.corner.labels.section", true);
        this.initPropertyDefaults(context, "graticule.corner.labels.north", false);
        this.initPropertyDefaults(context, "graticule.corner.labels.south", false);
        this.initPropertyDefaults(context, "graticule.corner.labels.west", false);
        this.initPropertyDefaults(context, "graticule.corner.labels.east", false);
        this.initPropertyDefaults(context, "graticule.labels.backdrop.section", true);
        this.initPropertyDefaults(context, "graticule.text.bg.transparency", 0.3);
        this.initPropertyDefaults(context, "graticule.text.bg.color", GraticuleLayerType.PROPERTY_INSIDE_LABELS_BG_COLOR_DEFAULT);
        this.restoreDefaults = this.initPropertyDefaults(context, "graticule.restoreDefaults", false);
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTablePadding(new Insets(4, 10, 0, 0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setColumnWeightX(1, Double.valueOf(1.0));
        JPanel pageUI = new JPanel((LayoutManager)tableLayout);
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        PropertySet propertyContainer = context.getPropertySet();
        Property[] properties = propertyContainer.getProperties();
        int currRow = 0;
        for (Property property : properties) {
            PropertyDescriptor descriptor = property.getDescriptor();
            PropertyPane.addComponent((int)currRow, (TableLayout)tableLayout, (JPanel)pageUI, (BindingContext)context, (PropertyEditorRegistry)registry, (PropertyDescriptor)descriptor);
            ++currRow;
        }
        pageUI.add(tableLayout.createVerticalSpacer());
        JPanel parent = new JPanel(new BorderLayout());
        parent.add((Component)pageUI, "Center");
        parent.add(Box.createHorizontalStrut(50), "East");
        return parent;
    }

    @Override
    protected void configure(BindingContext context) {
        Property[] properties;
        this.configureGridlinesEnablement(context);
        this.configureTickmarksEnablement(context);
        this.configureBorderEnablement(context);
        this.restoreDefaults.addPropertyChangeListener(evt -> this.handleRestoreDefaults(context));
        PropertySet propertyContainer = context.getPropertySet();
        for (Property property : properties = propertyContainer.getProperties()) {
            if (property == this.restoreDefaults) continue;
            property.addPropertyChangeListener(evt -> this.handlePreferencesPropertyValueChange(context));
        }
    }

    private boolean isDefaults(BindingContext context) {
        Property[] properties;
        PropertySet propertyContainer = context.getPropertySet();
        for (Property property : properties = propertyContainer.getProperties()) {
            if (property == this.restoreDefaults || property.getDescriptor().getDefaultValue() == null || property.getValue().equals(property.getDescriptor().getDefaultValue())) continue;
            return false;
        }
        return true;
    }

    private void handleRestoreDefaults(BindingContext context) {
        if (this.propertyValueChangeEventsEnabled) {
            this.propertyValueChangeEventsEnabled = false;
            try {
                if (((Boolean)this.restoreDefaults.getValue()).booleanValue()) {
                    Property[] properties;
                    PropertySet propertyContainer = context.getPropertySet();
                    for (Property property : properties = propertyContainer.getProperties()) {
                        if (property == this.restoreDefaults || property.getDescriptor().getDefaultValue() == null) continue;
                        property.setValue(property.getDescriptor().getDefaultValue());
                    }
                }
            }
            catch (ValidationException e) {
                e.printStackTrace();
            }
            this.propertyValueChangeEventsEnabled = true;
            context.setComponentsEnabled("graticule.restoreDefaults", false);
        }
    }

    private void configureTickmarksEnablement(BindingContext context) {
        this.enablementTickmarksInside = context.bindEnabledState("graticule.tickmarks.inside", true, "graticule.tickmarks.show", (Object)true);
        this.enablementTickmarksLength = context.bindEnabledState("graticule.tickmarks.length", true, "graticule.tickmarks.show", (Object)true);
        this.enablementTickmarksColor = context.bindEnabledState("graticule.tickmarks.color", true, "graticule.tickmarks.show", (Object)true);
        this.handleTickmarksEnablement();
    }

    private void handleTickmarksEnablement() {
        this.enablementTickmarksInside.apply();
        this.enablementTickmarksLength.apply();
        this.enablementTickmarksColor.apply();
    }

    private void configureGridlinesEnablement(BindingContext context) {
        this.enablementGridlinesWidth = context.bindEnabledState("graticule.gridlines.width", true, "graticule.gridlines.show", (Object)true);
        this.enablementGridlinesDashedPhase = context.bindEnabledState("graticule.gridlines.dashed.phase", true, "graticule.gridlines.show", (Object)true);
        this.enablementGridlinesTransparency = context.bindEnabledState("graticule.gridlines.transparency", true, "graticule.gridlines.show", (Object)true);
        this.enablementGridlinesColor = context.bindEnabledState("graticule.gridlines.color", true, "graticule.gridlines.show", (Object)true);
        this.handleGridlinesEnablement();
    }

    private void handleGridlinesEnablement() {
        this.enablementGridlinesWidth.apply();
        this.enablementGridlinesDashedPhase.apply();
        this.enablementGridlinesTransparency.apply();
        this.enablementGridlinesColor.apply();
    }

    private void configureBorderEnablement(BindingContext context) {
        this.enablementBorderWidth = context.bindEnabledState("graticule.border.width", true, "graticule.border.show", (Object)true);
        this.enablementBorderColor = context.bindEnabledState("graticule.border.color", true, "graticule.border.show", (Object)true);
        this.handleBorderEnablement();
    }

    private void handleBorderEnablement() {
        this.enablementBorderWidth.apply();
        this.enablementBorderColor.apply();
        this.enablementGridlinesTransparency.apply();
        this.enablementGridlinesColor.apply();
    }

    private void handlePreferencesPropertyValueChange(BindingContext context) {
        if (this.propertyValueChangeEventsEnabled) {
            this.propertyValueChangeEventsEnabled = false;
            try {
                this.restoreDefaults.setValue((Object)this.isDefaults(context));
                context.setComponentsEnabled("graticule.restoreDefaults", !this.isDefaults(context));
            }
            catch (ValidationException e) {
                e.printStackTrace();
            }
            this.propertyValueChangeEventsEnabled = true;
        }
    }

    private Property initPropertyDefaults(BindingContext context, String propertyName, Object propertyDefault) {
        Property property = context.getPropertySet().getProperty(propertyName);
        property.getDescriptor().setDefaultValue(propertyDefault);
        return property;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("options-graticulelayer");
    }

    static class GraticuleBean {
        @Preference(label="Grid Spacing", key="graticule.grid.spacing.section", description="Set grid spacing in degrees (0=AUTOSPACING)")
        boolean gridSpacingSection = true;
        @Preference(label="Latitude", key="graticule.spacing.lat", description="Set latitude grid spacing in degrees (0=AUTOSPACING)", interval="[0.00,90.0]")
        double gridSpacingLat = 0.0;
        @Preference(label="Longitude", key="graticule.spacing.lon", description="Set longitude grid spacing in degrees (0=AUTOSPACING)", interval="[0.00,90.0]")
        double gridSpacingLon = 0.0;
        @Preference(label="Labels", key="graticule.labels.section", description="Configuration options for the labels")
        boolean labelsSection = true;
        @Preference(label="North", key="graticule.labels.north", description="Display north labels")
        boolean labelsNorth = true;
        @Preference(label="South", key="graticule.labels.south", description="Display south labels")
        boolean labelsSouth = true;
        @Preference(label="West", key="graticule.labels.west", description="Display west labels")
        boolean labelsWest = true;
        @Preference(label="East", key="graticule.labels.east", description="Display east labels")
        boolean labelsEast = true;
        @Preference(label="Suffix (N,S,W,E)", key="graticule.labels.suffix.nswe", description="Format label text with suffix (N,S,W,E) instead of (+/-)")
        boolean labelsSuffix = true;
        @Preference(label="Decimal Value", key="graticule.labels.decimal.value", description="Format label text with decimal value instead of degrees/minutes/seconds")
        boolean labelsDecimal = false;
        @Preference(label="Put on Inside", key="graticule.labels.inside", description="Put on labels inside of the data image (also see backdrop options below)")
        boolean labelsInside = false;
        @Preference(label="Italic", key="graticule.labels.font.italic", description="Format label text font in italic")
        boolean labelsItalic = false;
        @Preference(label="Bold", key="graticule.labels.font.bold", description="Format label text font in bold")
        boolean labelsBold = false;
        @Preference(label="Font", key="graticule.labels.font.name", description="Set the text font of the labels", valueSet={"SanSerif", "Serif", "Courier", "Monospaced"})
        String labelsFont = "SanSerif";
        @Preference(label="Rotation (Longitude)", key="graticule.labels.rotation.lon", description="Rotate longitude labels (0 degrees = perpendicular)", interval="[0.00,90.0]")
        double labelsRotationLon = 45.0;
        @Preference(label="Rotation (Latitude)", key="graticule.labels.rotation.lat", description="Rotate latitude labels (0 degrees = perpendicular)", interval="[0.00,90.0]")
        double labelsRotationLat = 0.0;
        @Preference(label="Size", key="graticule.labels.size", description="Set size of the label text", interval="[6,70]")
        int labelsSize = 12;
        @Preference(label="Color", key="graticule.labels.color", description="Set color of the label text")
        Color labelsColor = GraticuleLayerType.PROPERTY_LABELS_COLOR_DEFAULT;
        @Preference(label="Gridlines", key="graticule.gridlines.section", description="Configuration options for the gridlines")
        boolean gridlinesSection = true;
        @Preference(label="Show", key="graticule.gridlines.show", description="Display gridlines")
        boolean gridlinesShow = true;
        @Preference(label="Width", key="graticule.gridlines.width", description="Set width of gridlines")
        double gridlinesWidth = 0.8;
        @Preference(label="Dash Length", key="graticule.gridlines.dashed.phase", description="Set dash length of gridlines or solid gridlines (0=SOLID)")
        double gridlinesDashed = 3.0;
        @Preference(label="Transparency", key="graticule.gridlines.transparency", description="Set transparency of gridlines", interval="[0.0,1.0]")
        double gridlinesTransparency = 0.6;
        @Preference(label="Color", key="graticule.gridlines.color", description="Set color of gridlines")
        Color gridlinesColor = GraticuleLayerType.PROPERTY_GRIDLINES_COLOR_DEFAULT;
        @Preference(label="Border", key="graticule.border.section", description="Configuration options for adding a border around the data image")
        boolean borderSection = true;
        @Preference(label="Show", key="graticule.border.show", description="Display a border around the data image")
        boolean borderShow = true;
        @Preference(label="Width", key="graticule.border.width", description="Width of border line")
        double borderWidth = 1.2;
        @Preference(label="Color", key="graticule.border.color", description="Color of border line")
        Color borderColor = GraticuleLayerType.PROPERTY_BORDER_COLOR_DEFAULT;
        @Preference(label="Tickmarks", key="graticule.tickmarks.section", description="Configuration options for adding tickmarks around the data image")
        boolean tickmarksSection = true;
        @Preference(label="Show", key="graticule.tickmarks.show", description="Display tickmarks")
        boolean tickmarksShow = true;
        @Preference(label="Put Inside", key="graticule.tickmarks.inside", description="Put tickmarks on inside of data image")
        boolean tickmarkInside = false;
        @Preference(label="Length", key="graticule.tickmarks.length", description="Set length of tickmarks")
        double tickmarksLength = 3.0;
        @Preference(label="Color", key="graticule.tickmarks.color", description="Set color of the tickmarks")
        Color tickmarksColor = GraticuleLayerType.PROPERTY_TICKMARKS_COLOR_DEFAULT;
        @Preference(label="Corner Labels", key="graticule.corner.labels.section", description="Configuration options for labels placed at the corners of the image")
        boolean cornerLabelsSection = true;
        @Preference(label="North", key="graticule.corner.labels.north", description="Display north corner labels")
        boolean cornerLabelsNorth = false;
        @Preference(label="South", key="graticule.corner.labels.south", description="Display south corner labels")
        boolean cornerLabelsSouth = false;
        @Preference(label="West", key="graticule.corner.labels.west", description="Display west corner labels")
        boolean cornerLabelsWest = false;
        @Preference(label="East", key="graticule.corner.labels.east", description="Display east corner labels")
        boolean cornerLabelsEast = false;
        @Preference(label="Inside Labels Backdrop", key="graticule.labels.backdrop.section", description="Configuration options for backdrop of labels placed on the inside of the image")
        boolean insideLabelsSection = true;
        @Preference(label="Transparency", key="graticule.text.bg.transparency", description="Set transparency of the backdrop of the inside labels", interval="[0.0,1.0]")
        double insideLabelsBgTransparency = 0.3;
        @Preference(label="Color", key="graticule.text.bg.color", description="Set color of the backdrop of the inside labels")
        Color insideLabelsBgColor = GraticuleLayerType.PROPERTY_INSIDE_LABELS_BG_COLOR_DEFAULT;
        @Preference(label="RESTORE DEFAULTS (Map Gridline Preferences)", key="graticule.restoreDefaults", description="Restore all map gridline preferences to the default")
        boolean restoreDefaults = false;

        GraticuleBean() {
        }
    }
}

