/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.preferences.general;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.preferences.DefaultConfigController;
import org.esa.snap.rcp.preferences.Preference;
import org.esa.snap.rcp.preferences.PreferenceUtils;
import org.openide.util.HelpCtx;

public final class UiBehaviorController
extends DefaultConfigController {
    public static final String PREFERENCE_KEY_AUTO_SHOW_NAVIGATION = "autoshownavigation.enabled";
    public static final String PREFERENCE_KEY_AUTO_SHOW_NEW_BANDS = "autoshowbands.enabled";
    public static final String PREFERENCE_KEY_LIST_FILES_TO_REOPEN = "filesToReopen";
    private static final String PREFERENCE_KEY_SHOW_SUPPRESSED = "showSuppressedDialogsAgain";
    private static final String PREFERENCE_KEY_SOUND_BEEP = "playSoundBeepAfterProcess";

    @Override
    public void applyChanges() {
        BindingContext bindingContext;
        Property showSuppressedProperty;
        if (this.isInitialised() && Boolean.parseBoolean((showSuppressedProperty = (bindingContext = this.getBindingContext()).getPropertySet().getProperty(PREFERENCE_KEY_SHOW_SUPPRESSED)).getValueAsText())) {
            Preferences preferences = SnapApp.getDefault().getPreferences();
            try {
                String[] childrenNames;
                for (String childrenName : childrenNames = preferences.keys()) {
                    if (childrenName.endsWith(".dontShow")) {
                        preferences.putBoolean(childrenName, false);
                    }
                    if (!childrenName.endsWith(".decision")) continue;
                    preferences.remove(childrenName);
                }
                showSuppressedProperty.setValue((Object)Boolean.FALSE);
            }
            catch (ValidationException | BackingStoreException e) {
                SnapApp.getDefault().handleError("Failure while resetting suppressed dialogs.", e);
            }
        }
        super.applyChanges();
    }

    @Override
    public void cancel() {
        if (this.isInitialised()) {
            BindingContext bindingContext = this.getBindingContext();
            Property showSuppressedProperty = bindingContext.getPropertySet().getProperty(PREFERENCE_KEY_SHOW_SUPPRESSED);
            try {
                showSuppressedProperty.setValue((Object)Boolean.FALSE);
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
        super.cancel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("options-uibehavior");
    }

    @Override
    protected PropertySet createPropertySet() {
        return this.createPropertySet(new UiBehaviorBean());
    }

    @Override
    protected JPanel createPanel(BindingContext context) {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTablePadding(new Insets(4, 10, 0, 0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setColumnWeightX(0, Double.valueOf(1.0));
        JPanel pageUI = new JPanel((LayoutManager)tableLayout);
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        Property autoShowNavigation = context.getPropertySet().getProperty(PREFERENCE_KEY_AUTO_SHOW_NAVIGATION);
        Property showNewBands = context.getPropertySet().getProperty(PREFERENCE_KEY_AUTO_SHOW_NEW_BANDS);
        Property showOnlyDisplayed = context.getPropertySet().getProperty("pixelview.showOnlyDisplayedBands");
        Property listOfFilesToReopen = context.getPropertySet().getProperty(PREFERENCE_KEY_LIST_FILES_TO_REOPEN);
        Property showSuppressedAgain = context.getPropertySet().getProperty(PREFERENCE_KEY_SHOW_SUPPRESSED);
        JComponent[] autoShowNavigationComponents = registry.findPropertyEditor(autoShowNavigation.getDescriptor()).createComponents(autoShowNavigation.getDescriptor(), context);
        JComponent[] showNewBandsComponents = registry.findPropertyEditor(showNewBands.getDescriptor()).createComponents(showNewBands.getDescriptor(), context);
        JComponent[] showOnlyDisplayedComponents = registry.findPropertyEditor(showOnlyDisplayed.getDescriptor()).createComponents(showOnlyDisplayed.getDescriptor(), context);
        JComponent[] listOfFilesToReopenComponent = registry.findPropertyEditor(listOfFilesToReopen.getDescriptor()).createComponents(listOfFilesToReopen.getDescriptor(), context);
        JComponent[] showSuppressedAgainComponent = registry.findPropertyEditor(showSuppressedAgain.getDescriptor()).createComponents(showSuppressedAgain.getDescriptor(), context);
        pageUI.add(PreferenceUtils.createTitleLabel("Display Settings"));
        pageUI.add(autoShowNavigationComponents[0]);
        pageUI.add(showNewBandsComponents[0]);
        pageUI.add(showOnlyDisplayedComponents[0]);
        pageUI.add(tableLayout.createHorizontalSpacer());
        pageUI.add(PreferenceUtils.createTitleLabel("Other Settings"));
        pageUI.add(showSuppressedAgainComponent[0]);
        TableLayout layout = new TableLayout(2);
        JPanel panel = new JPanel((LayoutManager)layout);
        layout.setTablePadding(new Insets(1, 10, 0, 0));
        panel.add(listOfFilesToReopenComponent[1]);
        panel.add(listOfFilesToReopenComponent[0]);
        tableLayout.setTableFill(TableLayout.Fill.VERTICAL);
        pageUI.add(panel);
        pageUI.add(tableLayout.createVerticalSpacer());
        JPanel parent = new JPanel(new BorderLayout());
        parent.add((Component)pageUI, "Center");
        parent.add(Box.createHorizontalStrut(100), "East");
        return parent;
    }

    static class UiBehaviorBean {
        @Preference(label="Show navigation window when image views are opened", key="autoshownavigation.enabled")
        boolean autoShowNavigation = true;
        @Preference(label="Open image view for new (virtual) bands", key="autoshowbands.enabled")
        boolean autoShowNewBands = true;
        @Preference(label="Show only pixel values of loaded or displayed bands", key="pixelview.showOnlyDisplayedBands")
        boolean showOnlyLoadedOrDisplayedBandPixels = true;
        @Preference(label="Maximum recent file list", key="filesToReopen", interval="[1,20]")
        int fileReopen = 10;
        @Preference(label="Show suppressed message dialogs again", key="showSuppressedDialogsAgain")
        boolean showSuppressedDialogsAgain = false;

        UiBehaviorBean() {
        }
    }
}

