/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.preferences.general;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.esa.snap.rcp.preferences.DefaultConfigController;
import org.esa.snap.rcp.preferences.Preference;
import org.openide.util.HelpCtx;

public final class ImageViewController
extends DefaultConfigController {
    @Override
    protected PropertySet createPropertySet() {
        return this.createPropertySet(new GeneralLayerBean());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("options-imageview");
    }

    @Override
    protected JPanel createPanel(BindingContext context) {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTablePadding(4, 10);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setRowWeightY(4, Double.valueOf(1.0));
        JPanel pageUI = new JPanel((LayoutManager)tableLayout);
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        Property showNavigationControl = context.getPropertySet().getProperty("image.navControlShown");
        Property showScrollBars = context.getPropertySet().getProperty("image.scrollBarsShown");
        Property reverseZoom = context.getPropertySet().getProperty("image.reverseZooming");
        JComponent[] showNavigationControlComponents = registry.findPropertyEditor(showNavigationControl.getDescriptor()).createComponents(showNavigationControl.getDescriptor(), context);
        JComponent[] showScrollBarsComponents = registry.findPropertyEditor(showScrollBars.getDescriptor()).createComponents(showScrollBars.getDescriptor(), context);
        JComponent[] reverseZoomComponents = registry.findPropertyEditor(showScrollBars.getDescriptor()).createComponents(reverseZoom.getDescriptor(), context);
        tableLayout.setRowPadding(0, new Insets(10, 80, 10, 4));
        pageUI.add(showNavigationControlComponents[0]);
        pageUI.add(showScrollBarsComponents[0]);
        pageUI.add(reverseZoomComponents[0]);
        pageUI.add(tableLayout.createVerticalSpacer());
        return pageUI;
    }

    static class GeneralLayerBean {
        @Preference(label="Show a navigation control widget in image views", key="image.navControlShown")
        boolean showNavigationControl = true;
        @Preference(label="Show scroll bars in image views", key="image.scrollBarsShown")
        boolean showScrollBars = false;
        @Preference(label="Invert mouse wheel scrolling (zoom-in/out)", key="image.reverseZooming")
        boolean reverseZom = false;

        GeneralLayerBean() {
        }
    }
}

