/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.preferences.general;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.esa.snap.core.dataio.geocoding.util.XYInterpolator;
import org.esa.snap.rcp.preferences.DefaultConfigController;
import org.esa.snap.rcp.preferences.Preference;
import org.esa.snap.rcp.preferences.PreferenceUtils;
import org.esa.snap.ui.GridBagUtils;
import org.openide.util.HelpCtx;

public final class GeoLocationController
extends DefaultConfigController {
    private static final String PREFERENCE_KEY_ADJUST_PIN_GEO_POS = "snap.adjustPinGeoPos";
    private static final String PREFERENCE_KEY_PIXEL_GEO_CODING_FRACTION_ACCURACY = "snap.pixelGeoCoding.fractionAccuracy";
    private static final String PREFERENCE_KEY_TIE_POINT_INVERSE_HIGH_PRECISION = "snap.tiePointGeoCoding.maxPrecision";

    @Override
    protected PropertySet createPropertySet() {
        return this.createPropertySet(new GeoLocationBean());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("options-geolocation");
    }

    @Override
    protected JPanel createPanel(BindingContext context) {
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        PropertySet propertySet = context.getPropertySet();
        Property snapToExactGeolocationProperty = propertySet.getProperty(PREFERENCE_KEY_ADJUST_PIN_GEO_POS);
        Property pixelGeocodingFractionAccuracyProperty = propertySet.getProperty(PREFERENCE_KEY_PIXEL_GEO_CODING_FRACTION_ACCURACY);
        Property pixelGeoCodingFractionInterpolatorProperty = propertySet.getProperty("snap.core.geocoding.interpolator");
        Property tiePointInverseHighPrecisionProperty = propertySet.getProperty(PREFERENCE_KEY_TIE_POINT_INVERSE_HIGH_PRECISION);
        Property showGeoPosAsDecimals = propertySet.getProperty("pixelview.showGeoPosDecimals");
        Property showPixelPosAsDecimals = propertySet.getProperty("pixelview.showPixelPosDecimals");
        Property showPixelPosOffset = propertySet.getProperty("pixelview.showPixelPosOffsetOne");
        PropertyDescriptor descriptor = snapToExactGeolocationProperty.getDescriptor();
        JComponent[] snapToExactGeolocationComponents = registry.findPropertyEditor(descriptor).createComponents(descriptor, context);
        descriptor = pixelGeocodingFractionAccuracyProperty.getDescriptor();
        JComponent[] pixelGeocodingfractionAccuracyComponents = registry.findPropertyEditor(descriptor).createComponents(descriptor, context);
        descriptor = pixelGeoCodingFractionInterpolatorProperty.getDescriptor();
        JComponent[] pixelGeocodingFractionInterpolatorComponents = registry.findPropertyEditor(descriptor).createComponents(descriptor, context);
        descriptor = tiePointInverseHighPrecisionProperty.getDescriptor();
        JComponent[] tiePointInverseHighPrecisionComponents = registry.findPropertyEditor(descriptor).createComponents(descriptor, context);
        descriptor = showGeoPosAsDecimals.getDescriptor();
        JComponent[] showGeoPosAsDecimalsComponents = registry.findPropertyEditor(descriptor).createComponents(descriptor, context);
        descriptor = showPixelPosAsDecimals.getDescriptor();
        JComponent[] showPixelPosAsDecimalsComponents = registry.findPropertyEditor(descriptor).createComponents(descriptor, context);
        descriptor = showPixelPosOffset.getDescriptor();
        JComponent[] showPixelPosOffsetComponents = registry.findPropertyEditor(descriptor).createComponents(descriptor, context);
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTablePadding(new Insets(4, 10, 0, 0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        tableLayout.setRowWeightY(8, Double.valueOf(1.0));
        JPanel pageUI = new JPanel((LayoutManager)tableLayout);
        pageUI.add(PreferenceUtils.createTitleLabel("General Settings"));
        pageUI.add(snapToExactGeolocationComponents[0]);
        pageUI.add(pixelGeocodingfractionAccuracyComponents[0]);
        pageUI.add(pixelGeocodingFractionInterpolatorComponents[1]);
        pageUI.add(pixelGeocodingFractionInterpolatorComponents[0]);
        pageUI.add(tiePointInverseHighPrecisionComponents[0]);
        tableLayout.createHorizontalSpacer();
        pageUI.add(PreferenceUtils.createTitleLabel("Display Settings"));
        pageUI.add(showGeoPosAsDecimalsComponents[0]);
        pageUI.add(showPixelPosAsDecimalsComponents[0]);
        pageUI.add(showPixelPosOffsetComponents[0]);
        pageUI.add(tableLayout.createVerticalSpacer());
        return GeoLocationController.createPageUIContentPane(pageUI);
    }

    private static JPanel createPageUIContentPane(JPanel pane) {
        JPanel contentPane = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createConstraints((String)"fill=HORIZONTAL,anchor=NORTHWEST");
        gbc.insets.top = 15;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contentPane.add((Component)pane, gbc);
        GridBagUtils.addVerticalFiller((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    static class GeoLocationBean {
        @Preference(label="Use sub-pixel fraction accuracy for pixel-based geo-coding", key="snap.pixelGeoCoding.fractionAccuracy", config="snap")
        boolean getPixelPosWithFractionAccuracy = false;
        @Preference(label="Select interpolation method for sub-pixel fraction accuracy for pixel-based geo-coding", key="snap.core.geocoding.interpolator", config="snap")
        XYInterpolator.Type geodeticInterpolator = XYInterpolator.Type.EUCLIDIAN;
        @Preference(label="Use high precision approximations for inverse tie point geo-coding", key="snap.tiePointGeoCoding.maxPrecision", config="snap")
        boolean getTiePointInverseHighPrecision = false;
        @Preference(label="Snap pins to exact geo-location after import, transfer to another product, or geo-coding change", key="snap.adjustPinGeoPos", config="snap")
        boolean snapToExactGeoLocation = true;
        @Preference(label="Show geographical coordinates in decimal degrees", key="pixelview.showGeoPosDecimals")
        boolean showGeoPosAsDecimals = false;
        @Preference(label="Show pixel coordinates with fractional part", key="pixelview.showPixelPosDecimals")
        boolean showPixelPosAsDecimals = false;
        @Preference(label="Show pixel coordinates starting at (1,1)", key="pixelview.showPixelPosOffsetOne", description="Show pixel coordinates so that the upper left image corner is (1,1), instead of (0,0).")
        boolean showPixelPosWithOffset1 = false;

        GeoLocationBean() {
        }
    }
}

