/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.preferences.general;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.Enablement;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import com.bc.ceres.swing.binding.PropertyPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JPanel;
import org.esa.snap.rcp.preferences.DefaultConfigController;
import org.esa.snap.rcp.preferences.Preference;
import org.openide.util.HelpCtx;

public final class ColorManipulationController
extends DefaultConfigController {
    Property restoreDefaults;
    boolean propertyValueChangeEventsEnabled = true;
    Enablement enablementGeneralPalette;
    Enablement enablementGeneralRange;
    Enablement enablementGeneralLog;

    @Override
    protected PropertySet createPropertySet() {
        return this.createPropertySet(new GeneralLayerBean());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("colorManipulationPreferences");
    }

    @Override
    protected JPanel createPanel(BindingContext context) {
        this.initPropertyDefaults(context, "color.manipulation.default.palette.section", true);
        this.initPropertyDefaults(context, "color.manipulation.default.palette.standard", "oceancolor_standard.cpd");
        this.initPropertyDefaults(context, "color.manipulation.default.palette.universal", "universal_bluered.cpd");
        this.initPropertyDefaults(context, "color.manipulation.default.palette.gray.scale", "gray_scale.cpd");
        this.initPropertyDefaults(context, "color.manipulation.default.palette.anomalies", "gradient_red_white_blue.cpd");
        this.initPropertyDefaults(context, "color.manipulation.general.section", true);
        this.initPropertyDefaults(context, "color.manipulation.general.custom", false);
        this.initPropertyDefaults(context, "color.manipulation.general.palette", "GRAY SCALE");
        this.initPropertyDefaults(context, "color.manipulation.general.range", "From Data");
        this.initPropertyDefaults(context, "color.manipulation.general.log", "FALSE");
        this.initPropertyDefaults(context, "color.manipulation.restore.defaults.section", true);
        this.initPropertyDefaults(context, "color.manipulation.scheme.section", true);
        this.initPropertyDefaults(context, "color.manipulation.scheme.auto.apply", false);
        this.initPropertyDefaults(context, "color.manipulation.scheme.palette", "From Scheme STANDARD");
        this.initPropertyDefaults(context, "color.manipulation.scheme.range", "From Scheme");
        this.initPropertyDefaults(context, "color.manipulation.scheme.log", "From Scheme");
        this.initPropertyDefaults(context, "color.manipulation.range.percentile.section", true);
        this.initPropertyDefaults(context, "color.manipulation.range.percentile.value", 92.0);
        this.initPropertyDefaults(context, "color.manipulation.button.enablement.1.sigma.button", false);
        this.initPropertyDefaults(context, "color.manipulation.button.enablement.2.sigma.button", true);
        this.initPropertyDefaults(context, "color.manipulation.button.enablement.3.sigma.button", true);
        this.initPropertyDefaults(context, "color.manipulation.button.enablement.95.button", false);
        this.initPropertyDefaults(context, "color.manipulation.button.enablement.100.button", true);
        this.initPropertyDefaults(context, "color.manipulation.scheme.selector.section", true);
        this.initPropertyDefaults(context, "color.manipulation.scheme.selector.verbose", false);
        this.initPropertyDefaults(context, "color.manipulation.scheme.selector.sort", true);
        this.initPropertyDefaults(context, "color.manipulation.scheme.selector.split", true);
        this.initPropertyDefaults(context, "color.manipulation.scheme.selector.show.disabled", false);
        this.initPropertyDefaults(context, "color.manipulation.slider.options.section", true);
        this.initPropertyDefaults(context, "color.manipulation.slider.options.zoom.in", true);
        this.initPropertyDefaults(context, "color.manipulation.slider.options.extra.info", true);
        this.initPropertyDefaults(context, "color.manipulation.button.enablement.zoom.vertical.buttons", true);
        this.initPropertyDefaults(context, "color.manipulation.button.enablement.extra.info.button", true);
        this.initPropertyDefaults(context, "color.manipulation.rgb.options.section", true);
        this.initPropertyDefaults(context, "color.manipulation.rgb.options.button.min", 0.0);
        this.initPropertyDefaults(context, "color.manipulation.rgb.optionsbutton.min", 1.0);
        this.restoreDefaults = this.initPropertyDefaults(context, "color.manipulation.restore.defaults.apply", false);
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTablePadding(new Insets(4, 10, 0, 0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setColumnWeightX(1, Double.valueOf(1.0));
        JPanel pageUI = new JPanel((LayoutManager)tableLayout);
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        PropertySet propertyContainer = context.getPropertySet();
        Property[] properties = propertyContainer.getProperties();
        int currRow = 0;
        for (Property property : properties) {
            PropertyDescriptor descriptor = property.getDescriptor();
            PropertyPane.addComponent((int)currRow, (TableLayout)tableLayout, (JPanel)pageUI, (BindingContext)context, (PropertyEditorRegistry)registry, (PropertyDescriptor)descriptor);
            ++currRow;
        }
        pageUI.add(tableLayout.createVerticalSpacer());
        JPanel parent = new JPanel(new BorderLayout());
        parent.add((Component)pageUI, "Center");
        parent.add(Box.createHorizontalStrut(50), "East");
        return parent;
    }

    @Override
    protected void configure(BindingContext context) {
        Property[] properties;
        this.configureGeneralCustomEnablement(context);
        this.restoreDefaults.addPropertyChangeListener(evt -> this.handleRestoreDefaults(context));
        PropertySet propertyContainer = context.getPropertySet();
        for (Property property : properties = propertyContainer.getProperties()) {
            if (property == this.restoreDefaults) continue;
            property.addPropertyChangeListener(evt -> this.handlePreferencesPropertyValueChange(context));
        }
    }

    private boolean isDefaults(BindingContext context) {
        Property[] properties;
        PropertySet propertyContainer = context.getPropertySet();
        for (Property property : properties = propertyContainer.getProperties()) {
            if (property == this.restoreDefaults || property.getDescriptor().getDefaultValue() == null || property.getValue().equals(property.getDescriptor().getDefaultValue())) continue;
            return false;
        }
        return true;
    }

    private void handleRestoreDefaults(BindingContext context) {
        if (this.propertyValueChangeEventsEnabled) {
            this.propertyValueChangeEventsEnabled = false;
            try {
                if (((Boolean)this.restoreDefaults.getValue()).booleanValue()) {
                    Property[] properties;
                    PropertySet propertyContainer = context.getPropertySet();
                    for (Property property : properties = propertyContainer.getProperties()) {
                        if (property == this.restoreDefaults || property.getDescriptor().getDefaultValue() == null) continue;
                        property.setValue(property.getDescriptor().getDefaultValue());
                    }
                }
            }
            catch (ValidationException e) {
                e.printStackTrace();
            }
            this.propertyValueChangeEventsEnabled = true;
            context.setComponentsEnabled("color.manipulation.restore.defaults.apply", false);
        }
    }

    private void handlePreferencesPropertyValueChange(BindingContext context) {
        if (this.propertyValueChangeEventsEnabled) {
            this.propertyValueChangeEventsEnabled = false;
            try {
                this.restoreDefaults.setValue((Object)this.isDefaults(context));
                context.setComponentsEnabled("color.manipulation.restore.defaults.apply", !this.isDefaults(context));
            }
            catch (ValidationException e) {
                e.printStackTrace();
            }
            this.propertyValueChangeEventsEnabled = true;
        }
    }

    private Property initPropertyDefaults(BindingContext context, String propertyName, Object propertyDefault) {
        Property property = context.getPropertySet().getProperty(propertyName);
        property.getDescriptor().setDefaultValue(propertyDefault);
        return property;
    }

    private void configureGeneralCustomEnablement(BindingContext context) {
        this.enablementGeneralPalette = context.bindEnabledState("color.manipulation.general.palette", true, "color.manipulation.general.custom", (Object)true);
        this.enablementGeneralRange = context.bindEnabledState("color.manipulation.general.range", true, "color.manipulation.general.custom", (Object)true);
        this.enablementGeneralLog = context.bindEnabledState("color.manipulation.general.log", true, "color.manipulation.general.custom", (Object)true);
        this.enablementGeneralPalette.apply();
        this.enablementGeneralRange.apply();
        this.enablementGeneralLog.apply();
    }

    private void handleGeneralCustom() {
        this.enablementGeneralPalette.apply();
        this.enablementGeneralRange.apply();
        this.enablementGeneralLog.apply();
    }

    static class GeneralLayerBean {
        @Preference(label="Default Palettes", key="color.manipulation.default.palette.section", description="Palettes to use with associated variables name")
        boolean defaultPaletteSection = true;
        @Preference(label="GRAY SCALE", key="color.manipulation.default.palette.gray.scale", description="The palette file to use when GRAY SCALE is selected")
        String grayScaleCpd = "gray_scale.cpd";
        @Preference(label="STANDARD", key="color.manipulation.default.palette.standard", description="The palette file to use when STANDARD COLOUR is selected")
        String standardColorCpd = "oceancolor_standard.cpd";
        @Preference(label="UNIVERSAL", key="color.manipulation.default.palette.universal", description="<html>The color blind compliant palette file to use when <br>UNIVERSAL COLOUR is selected</html>")
        String colorBlindCpd = "universal_bluered.cpd";
        @Preference(label="ANOMALIES", key="color.manipulation.default.palette.anomalies", description="The palette file to use when ANOMALIES is selected")
        String otherCpd = "gradient_red_white_blue.cpd";
        @Preference(label="Standard Options", key="color.manipulation.general.section", description="General behavior when not using a colour scheme")
        boolean generalBehaviorSection = true;
        @Preference(label="Use Standard Options as Default", key="color.manipulation.general.custom", description="<html>Use Standard Options as default<br> when opening a band<br>otherwise use settings from the file reader.</html>")
        boolean generalCustomSchemes = false;
        @Preference(label="Palette", key="color.manipulation.general.palette", description="The color palette file to use when NOT using a colour scheme", valueSet={"GRAY SCALE", "STANDARD", "UNIVERSAL", "ANOMALIES"})
        String generalCpd = "GRAY SCALE";
        @Preference(label="Range", key="color.manipulation.general.range", description="Range options to use when NOT using a colourscheme", valueSet={"From Data", "From Palette File"})
        String generalRange = "From Data";
        @Preference(label="Log Scaling", key="color.manipulation.general.log", description="Log scaling options to use when NOT using a colour scheme", valueSet={"TRUE", "FALSE", "From Palette File"})
        String generalLog = "FALSE";
        @Preference(label="Scheme Options", key="color.manipulation.scheme.section", description="<html>Behavior when using a colour scheme as configured in<br> color_palette_schemes.xml and color_palette_scheme_lookup.xml</html>")
        boolean schemeOptionsSection = true;
        @Preference(label="Apply Colour Schemes Automatically", key="color.manipulation.scheme.auto.apply", description="<html>Apply colour schemes automatically<br> when opening a band based on its name</html>")
        boolean autoApplySchemes = false;
        @Preference(label="Palette", key="color.manipulation.scheme.palette", description="The color palette file to use for the scheme", valueSet={"From Scheme STANDARD", "From Scheme UNIVERSAL", "GRAY SCALE", "STANDARD", "UNIVERSAL", "ANOMALIES"})
        String schemeCpd = "From Scheme STANDARD";
        @Preference(label="Range", key="color.manipulation.scheme.range", description="Range options (min, max) to use for the scheme", valueSet={"From Scheme", "From Data", "From Palette File"})
        String schemeRange = "From Scheme";
        @Preference(label="Log Scaling", key="color.manipulation.scheme.log", description="log scaling options to use for the scheme", valueSet={"From Scheme", "From Palette File", "TRUE", "FALSE"})
        String schemeLog = "From Scheme";
        @Preference(label="Percentile Range", key="color.manipulation.range.percentile.section", description="Default range percentile in the Colour Manipulation GUI")
        boolean rangePercentileSection = true;
        @Preference(label="Percentile Range Default", key="color.manipulation.range.percentile.value", description="The percentile of the data to use for determining min, max range", interval="[0.10,100.0]")
        double rangePercentile = 92.0;
        @Preference(label="<html>1&sigma; (68.27%) Button</html>", key="color.manipulation.button.enablement.1.sigma.button", description="Enable 68.27% range button in the sliders editor")
        boolean range1Sigma = false;
        @Preference(label="<html>2&sigma; (95.45%) Button</html>", key="color.manipulation.button.enablement.2.sigma.button", description="Enable 95.45% range button in the sliders editor")
        boolean range2Sigma = true;
        @Preference(label="<html>3&sigma; (99.73%) Button</html>", key="color.manipulation.button.enablement.3.sigma.button", description="Enable 99.73% range button in the sliders editor")
        boolean range3Sigma = true;
        @Preference(label="95% Button", key="color.manipulation.button.enablement.95.button", description="Enable 95% range button in the sliders editor")
        boolean range95 = false;
        @Preference(label="100% Button", key="color.manipulation.button.enablement.100.button", description="Enable 100% range button in the sliders editor")
        boolean range100 = true;
        @Preference(label="Scheme Selector Options", key="color.manipulation.scheme.selector.section", description="<html>Format options for the color schemes listed<br> within the Scheme Selector</html>")
        boolean schemeSelectorSection = true;
        @Preference(label="Verbose", key="color.manipulation.scheme.selector.verbose", description="<html>Scheme selector will show the verbose VERBOSE_NAME field<br> from the color_palette_schemes.xml</html>")
        boolean schemeSelectorVerbose = false;
        @Preference(label="Sort", key="color.manipulation.scheme.selector.sort", description="<html>Scheme selector will display all schemes alphabetically sorted<br> as opposed to the original xml order</html>")
        boolean schemeSelectorSort = true;
        @Preference(label="Categorize", key="color.manipulation.scheme.selector.split", description="<html>Scheme selector will display all schemes categorized into<br>primary and additional categories by the PRIMARY field<br> of the color_palette_schemes.xml</html>")
        boolean schemeSelectorSplit = true;
        @Preference(label="Show Disabled", key="color.manipulation.scheme.selector.show.disabled", description="<html>Scheme selector will display all schemes <br>including schemes with missing cpd files</html>")
        boolean schemeSelectorShowDisabled = false;
        @Preference(label="Sliders Editor Options", key="color.manipulation.slider.options.section", description="Options within the \"Sliders\" Editor of the Colour Manipulation GUI")
        boolean sliderOptionsSection = true;
        @Preference(label="Histogram Zoom", key="color.manipulation.slider.options.zoom.in", description="Display histogram slider view zoomed in by default")
        boolean sliderZoom = true;
        @Preference(label="Show Information", key="color.manipulation.slider.options.extra.info", description="Display information in the histogram/slider view by default")
        boolean slidersShowExtraInfo = true;
        @Preference(label="Vertical Zoom Buttons", key="color.manipulation.button.enablement.zoom.vertical.buttons", description="Enable zoom vertical buttons in the sliders editor")
        boolean sliderZoomVertical = true;
        @Preference(label="Information Button", key="color.manipulation.button.enablement.extra.info.button", description="Enable histogram overlay information button in the sliders editor")
        boolean slidersShowExtraInfoButton = true;
        @Preference(label="RGB Options", key="color.manipulation.rgb.options.section", description="Options for the RGB Image")
        boolean rgbOptionsSection = true;
        @Preference(label="Range Button (Min)", key="color.manipulation.rgb.options.button.min", description="The min value to use in the RGB (A..B) range button")
        double rgbOptionsMin = 0.0;
        @Preference(label="Range Button (Max)", key="color.manipulation.rgb.optionsbutton.min", description="The max value to use in the RGB (A..B) range button")
        double rgbOptionsMax = 1.0;
        @Preference(label="Restore", key="color.manipulation.restore.defaults.section", description="Restores preferences to the package defaults")
        boolean restoreDefaultsSection = true;
        @Preference(label="Default (Colour Manipulation Preferences)", key="color.manipulation.restore.defaults.apply", description="Restore all colour preferences to the original default")
        boolean restoreDefaults = false;

        GeneralLayerBean() {
        }
    }
}

