/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.preferences;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.TableLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.esa.snap.core.util.SystemUtils;
import org.openide.awt.ColorComboBox;

public class PreferenceUtils {
    public static void addNote(JPanel panel, String text) {
        JLabel note = new JLabel(text);
        if (note.getFont() != null) {
            note.setFont(note.getFont().deriveFont(2));
        }
        note.setForeground(new Color(0, 0, 92));
        panel.add(note);
    }

    public static JComponent[] createColorComponents(Property colorProperty) {
        JComponent[] components = new JComponent[]{new JLabel(colorProperty.getDescriptor().getDisplayName() + ":"), PreferenceUtils.createColorCombobox(colorProperty)};
        return components;
    }

    public static JPanel createTitleLabel(String title) {
        TableLayout layout = new TableLayout(3);
        layout.setColumnWeightX(0, Double.valueOf(0.0));
        layout.setColumnWeightX(1, Double.valueOf(0.0));
        layout.setColumnWeightX(2, Double.valueOf(1.0));
        layout.setColumnFill(0, TableLayout.Fill.NONE);
        layout.setColumnFill(1, TableLayout.Fill.NONE);
        layout.setColumnFill(2, TableLayout.Fill.HORIZONTAL);
        JPanel comp = new JPanel((LayoutManager)layout);
        JLabel label = new JLabel(title);
        comp.add(label);
        comp.add(new JLabel("   "));
        comp.add(new JSeparator());
        return comp;
    }

    private static ColorComboBox createColorCombobox(final Property property) {
        final ColorComboBox colorComboBox = new ColorComboBox();
        colorComboBox.setSelectedColor((Color)property.getValue());
        colorComboBox.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                try {
                    property.setValue((Object)colorComboBox.getSelectedColor());
                }
                catch (ValidationException e1) {
                    SystemUtils.LOG.warning("Color preference conversion error: " + e1.getMessage());
                }
            }
        });
        colorComboBox.setPreferredSize(new Dimension(colorComboBox.getWidth(), 25));
        property.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                colorComboBox.setSelectedColor((Color)property.getValue());
            }
        });
        return colorComboBox;
    }
}

