/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.placemark.pin;

import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import java.awt.Color;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.rcp.placemark.PlacemarkUtils;
import org.esa.snap.ui.product.AbstractPlacemarkTableModel;

public class PinTableModel
extends AbstractPlacemarkTableModel {
    private final int xIndex = 0;
    private final int yIndex = 1;
    private final int lonIndex = 2;
    private final int latIndex = 3;
    private final int colorIndex = 4;
    private final int labelIndex = 5;

    public PinTableModel(PlacemarkDescriptor placemarkDescriptor, Product product, Band[] selectedBands, TiePointGrid[] selectedGrids) {
        super(placemarkDescriptor, product, selectedBands, selectedGrids);
    }

    public String[] getStandardColumnNames() {
        return new String[]{"X", "Y", "Lon", "Lat", "Color", "Label"};
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.getProduct().getSceneGeoCoding() == null && (columnIndex == 2 || columnIndex == 3)) {
            return false;
        }
        return columnIndex < this.getStandardColumnNames().length;
    }

    protected Object getStandardColumnValueAt(int rowIndex, int columnIndex) {
        Assert.notNull((Object)this.getProduct());
        Placemark placemark = (Placemark)this.getPlacemarkDescriptor().getPlacemarkGroup(this.getProduct()).get(rowIndex);
        double x = Double.NaN;
        double y = Double.NaN;
        PixelPos pixelPos = placemark.getPixelPos();
        if (pixelPos != null) {
            x = pixelPos.x;
            y = pixelPos.y;
        }
        double lon = Double.NaN;
        double lat = Double.NaN;
        GeoPos geoPos = placemark.getGeoPos();
        if (geoPos != null) {
            lon = geoPos.lon;
            lat = geoPos.lat;
        }
        switch (columnIndex) {
            case 0: {
                return x;
            }
            case 1: {
                return y;
            }
            case 2: {
                return lon;
            }
            case 3: {
                return lat;
            }
            case 4: {
                return PlacemarkUtils.getPlacemarkColor(placemark);
            }
            case 5: {
                return placemark.getLabel();
            }
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Double.class;
            }
            case 1: {
                return Double.class;
            }
            case 2: {
                return Double.class;
            }
            case 3: {
                return Double.class;
            }
            case 4: {
                return Color.class;
            }
            case 5: {
                return String.class;
            }
        }
        return Object.class;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 4) {
            String colorName = DefaultFigureStyle.FILL_COLOR.getName();
            Placemark pin = this.getPlacemarkAt(rowIndex);
            String styleCss = pin.getStyleCss();
            DefaultFigureStyle style = new DefaultFigureStyle();
            style.fromCssString(styleCss);
            style.setValue(colorName, value);
            pin.setStyleCss(style.toCssString());
        } else {
            super.setValueAt(value, rowIndex, columnIndex);
        }
    }
}

