/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.placemark;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.ModalDialog;

public class ProductChooser
extends ModalDialog {
    private static final Font SMALL_PLAIN_FONT = new Font("SansSerif", 0, 10);
    private static final Font SMALL_ITALIC_FONT = SMALL_PLAIN_FONT.deriveFont(2);
    private final Product[] allProducts;
    private Product[] selectedProducts;
    private int numSelected;
    private JCheckBox[] checkBoxes;
    private JCheckBox selectAllCheckBox;
    private JCheckBox selectNoneCheckBox;
    private final boolean selectAtLeastOneProduct;
    private boolean multipleProducts;

    public ProductChooser(Window parent, String title, String helpID, Product[] allProducts, Product[] selectedProducts) {
        super(parent, title, 33, helpID);
        Guardian.assertNotNull((String)"allProducts", (Object)allProducts);
        this.allProducts = allProducts;
        this.selectedProducts = selectedProducts;
        this.selectAtLeastOneProduct = true;
        if (this.selectedProducts == null) {
            this.selectedProducts = new Product[0];
        }
        this.multipleProducts = allProducts.length > 1;
        this.initUI();
    }

    public int show() {
        this.updateUI();
        return super.show();
    }

    private void initUI() {
        JPanel checkersPane = this.createCheckersPane();
        this.selectAllCheckBox = new JCheckBox("Select all");
        this.selectAllCheckBox.setMnemonic('a');
        this.selectAllCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductChooser.this.select(true);
            }
        });
        this.selectNoneCheckBox = new JCheckBox("Select none");
        this.selectNoneCheckBox.setMnemonic('n');
        this.selectNoneCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductChooser.this.select(false);
            }
        });
        JPanel checkPane = new JPanel(new BorderLayout());
        checkPane.add((Component)this.selectAllCheckBox, "West");
        checkPane.add((Component)this.selectNoneCheckBox, "Center");
        JScrollPane scrollPane = new JScrollPane(checkersPane);
        Dimension preferredSize = checkersPane.getPreferredSize();
        scrollPane.setPreferredSize(new Dimension(Math.min(preferredSize.width + 20, 400), Math.min(preferredSize.height + 40, 300)));
        JLabel label = new JLabel("Target product(s):");
        JPanel content = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createDefaultConstraints();
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 0.0;
        content.add((Component)label, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        content.add((Component)scrollPane, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        content.add((Component)checkPane, gbc);
        ++gbc.gridy;
        gbc.insets.top = 20;
        this.setContent(content);
    }

    private JPanel createCheckersPane() {
        this.checkBoxes = new JCheckBox[this.allProducts.length];
        JPanel checkersPane = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createConstraints((String)"insets.left=4,anchor=WEST,fill=HORIZONTAL");
        StringBuffer description = new StringBuffer();
        this.addProductCheckers(description, checkersPane, gbc);
        return checkersPane;
    }

    private void addProductCheckers(StringBuffer description, JPanel checkersPane, GridBagConstraints gbc) {
        ActionListener checkListener = this.createActionListener();
        for (int i = 0; i < this.allProducts.length; ++i) {
            Product product = this.allProducts[i];
            boolean checked = false;
            for (Product selectedProduct : this.selectedProducts) {
                if (product != selectedProduct) continue;
                checked = true;
                ++this.numSelected;
                break;
            }
            description.setLength(0);
            description.append(product.getDescription() == null ? "" : product.getDescription());
            JCheckBox check = new JCheckBox(this.getDisplayName(product), checked);
            check.setFont(SMALL_PLAIN_FONT);
            check.addActionListener(checkListener);
            JLabel label = new JLabel(description.toString());
            label.setFont(SMALL_ITALIC_FONT);
            ++gbc.gridy;
            GridBagUtils.addToPanel((JPanel)checkersPane, (Component)check, (GridBagConstraints)gbc, (String)"weightx=0,gridx=0");
            GridBagUtils.addToPanel((JPanel)checkersPane, (Component)label, (GridBagConstraints)gbc, (String)"weightx=1,gridx=1");
            this.checkBoxes[i] = check;
        }
    }

    private String getDisplayName(Product rasterDataNode) {
        return this.multipleProducts ? rasterDataNode.getDisplayName() : rasterDataNode.getName();
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox check = (JCheckBox)e.getSource();
                ProductChooser.this.numSelected = check.isSelected() ? ++ProductChooser.this.numSelected : --ProductChooser.this.numSelected;
                ProductChooser.this.updateUI();
            }
        };
    }

    private void select(boolean b) {
        for (JCheckBox checkBox : this.checkBoxes) {
            if (b && !checkBox.isSelected()) {
                ++this.numSelected;
            }
            if (!b && checkBox.isSelected()) {
                --this.numSelected;
            }
            checkBox.setSelected(b);
        }
        this.updateUI();
    }

    private void updateUI() {
        this.selectAllCheckBox.setSelected(this.numSelected == this.checkBoxes.length);
        this.selectAllCheckBox.setEnabled(this.numSelected < this.checkBoxes.length);
        this.selectAllCheckBox.updateUI();
        this.selectNoneCheckBox.setSelected(this.numSelected == 0);
        this.selectNoneCheckBox.setEnabled(this.numSelected > 0);
        this.selectNoneCheckBox.updateUI();
    }

    protected boolean verifyUserInput() {
        ArrayList<Product> products = new ArrayList<Product>();
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            JCheckBox checkBox = this.checkBoxes[i];
            if (!checkBox.isSelected()) continue;
            products.add(this.allProducts[i]);
        }
        this.selectedProducts = products.toArray(new Product[products.size()]);
        if (this.selectAtLeastOneProduct) {
            boolean result;
            boolean bl = result = this.selectedProducts.length > 0;
            if (!result) {
                this.showInformationDialog("No products selected.\nPlease select at least one product.");
            }
            return result;
        }
        return true;
    }

    public Product[] getSelectedProducts() {
        return this.selectedProducts;
    }
}

