/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.placemark;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.placemark.PlacemarkManagerTopComponent;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.help.HelpDisplayer;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.openide.util.HelpCtx;

public class PlacemarkManagerButtons
extends JPanel {
    private final AbstractButton newButton = PlacemarkManagerButtons.createButton("icons/New24.gif");
    private final AbstractButton copyButton;
    private final AbstractButton editButton;
    private final AbstractButton removeButton;
    private final AbstractButton importButton;
    private final AbstractButton exportButton;
    private final AbstractButton filterButton;
    private final AbstractButton exportTableButton;
    private final AbstractButton zoomToPlacemarkButton;
    private final AbstractButton transferPlacemarkButton;

    public PlacemarkManagerButtons(PlacemarkManagerTopComponent topComponent) {
        super(new GridBagLayout());
        this.newButton.setName("newButton");
        String placemarkLabel = topComponent.getPlacemarkDescriptor().getRoleLabel();
        this.newButton.setToolTipText("Create and add new " + placemarkLabel + ".");
        this.newButton.addActionListener(e -> topComponent.newPin());
        this.copyButton = PlacemarkManagerButtons.createButton("icons/Copy24.gif");
        this.copyButton.setName("copyButton");
        this.copyButton.setToolTipText("Copy an existing " + placemarkLabel + ".");
        this.copyButton.addActionListener(e -> topComponent.copyActivePlacemark());
        this.editButton = PlacemarkManagerButtons.createButton("icons/Edit24.gif");
        this.editButton.setName("editButton");
        this.editButton.setToolTipText("Edit selected " + placemarkLabel + ".");
        this.editButton.addActionListener(e -> topComponent.editActivePin());
        this.removeButton = PlacemarkManagerButtons.createButton("icons/Remove24.gif");
        this.removeButton.setName("removeButton");
        this.removeButton.setToolTipText("Remove selected " + placemarkLabel + ".");
        this.removeButton.addActionListener(e -> topComponent.removeSelectedPins());
        this.importButton = PlacemarkManagerButtons.createButton("icons/Import24.gif");
        this.importButton.setName("importButton");
        this.importButton.setToolTipText("Import all " + placemarkLabel + "s from XML or text file.");
        this.importButton.addActionListener(e -> {
            topComponent.importPlacemarks(true);
            topComponent.updateUIState();
        });
        this.exportButton = PlacemarkManagerButtons.createButton("icons/Export24.gif");
        this.exportButton.setName("exportButton");
        this.exportButton.setToolTipText("Export selected " + placemarkLabel + "s to XML file.");
        this.exportButton.addActionListener(e -> {
            topComponent.exportPlacemarks();
            topComponent.updateUIState();
        });
        this.filterButton = PlacemarkManagerButtons.createButton("icons/Filter24.gif");
        this.filterButton.setName("filterButton");
        this.filterButton.setToolTipText("Filter pixel data to be displayed in table.");
        this.filterButton.addActionListener(e -> {
            topComponent.applyFilteredGrids();
            topComponent.updateUIState();
        });
        this.exportTableButton = PlacemarkManagerButtons.createButton("icons/ExportTable.gif");
        this.exportTableButton.setName("exportTableButton");
        this.exportTableButton.setToolTipText("Export selected data to flat text file.");
        this.exportTableButton.addActionListener(e -> {
            topComponent.exportPlacemarkDataTable();
            topComponent.updateUIState();
        });
        this.zoomToPlacemarkButton = PlacemarkManagerButtons.createButton("icons/ZoomTo24.gif");
        this.zoomToPlacemarkButton.setName("zoomToButton");
        this.zoomToPlacemarkButton.setToolTipText("Zoom to selected " + placemarkLabel + ".");
        this.zoomToPlacemarkButton.addActionListener(e -> topComponent.zoomToActivePin());
        this.transferPlacemarkButton = PlacemarkManagerButtons.createButton("icons/MultiAssignProducts24.gif");
        this.transferPlacemarkButton.setName("transferButton");
        this.transferPlacemarkButton.setToolTipText("Transfer the selected " + placemarkLabel + "s to other products.");
        this.transferPlacemarkButton.addActionListener(e -> topComponent.transferPlacemarks());
        AbstractButton helpButton = PlacemarkManagerButtons.createButton("icons/Help22.png");
        helpButton.setToolTipText("Help.");
        helpButton.setName("helpButton");
        helpButton.addActionListener(e -> HelpDisplayer.show((HelpCtx)topComponent.getHelpCtx()));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 0.5;
        ++gbc.gridy;
        this.add((Component)this.newButton, gbc);
        this.add((Component)this.copyButton, gbc);
        ++gbc.gridy;
        this.add((Component)this.editButton, gbc);
        this.add((Component)this.removeButton, gbc);
        ++gbc.gridy;
        this.add((Component)this.importButton, gbc);
        this.add((Component)this.exportButton, gbc);
        ++gbc.gridy;
        this.add((Component)this.filterButton, gbc);
        this.add((Component)this.exportTableButton, gbc);
        ++gbc.gridy;
        this.add((Component)this.zoomToPlacemarkButton, gbc);
        this.add((Component)this.transferPlacemarkButton, gbc);
        ++gbc.gridy;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        this.add((Component)new JLabel(" "), gbc);
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)helpButton, gbc);
    }

    void updateUIState(boolean productSelected, int numPins, int numSelectedPins) {
        boolean pinsAvailable = numPins > 0;
        boolean hasSelectedPins = numSelectedPins > 0;
        boolean hasActivePin = numSelectedPins == 1;
        this.newButton.setEnabled(productSelected);
        this.copyButton.setEnabled(hasActivePin);
        this.editButton.setEnabled(hasActivePin);
        this.removeButton.setEnabled(hasSelectedPins);
        this.zoomToPlacemarkButton.setEnabled(hasActivePin);
        this.transferPlacemarkButton.setEnabled(pinsAvailable && SnapApp.getDefault().getProductManager().getProductCount() > 1);
        this.importButton.setEnabled(productSelected);
        this.exportButton.setEnabled(pinsAvailable);
        this.exportTableButton.setEnabled(pinsAvailable);
        this.filterButton.setEnabled(productSelected);
    }

    private static AbstractButton createButton(String path) {
        return ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)path), (boolean)false);
    }
}

