/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.placemark;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PinDescriptor;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.ui.ModalDialog;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class PlacemarkDialog
extends ModalDialog {
    private static final String PROPERTY_NAME_NAME = "name";
    private static final String PROPERTY_NAME_LABEL = "label";
    private static final String PROPERTY_NAME_DESCRIPTION = "description";
    private static final String PROPERTY_NAME_STYLE_CSS = "styleCss";
    private static final String PROPERTY_NAME_LAT = "lat";
    private static final String PROPERTY_NAME_LON = "lon";
    private static final String PROPERTY_NAME_PIXEL_X = "pixelX";
    private static final String PROPERTY_NAME_PIXEL_Y = "pixelY";
    private static final String PROPERTY_NAME_USE_PIXEL_POS = "usePixelPos";
    private final Product product;
    private final boolean canGetPixelPos;
    private final boolean canGetGeoPos;
    private final PlacemarkDescriptor placemarkDescriptor;
    private final BindingContext bindingContext;
    private boolean adjusting;

    public PlacemarkDialog(Window parent, Product product, PlacemarkDescriptor placemarkDescriptor, boolean switchGeoAndPixelPositionsEditable) {
        super(parent, "New " + placemarkDescriptor.getRoleLabel(), 33, null);
        Guardian.assertNotNull((String)"product", (Object)product);
        this.product = product;
        this.placemarkDescriptor = placemarkDescriptor;
        this.bindingContext = new BindingContext();
        GeoCoding geoCoding = this.product.getSceneGeoCoding();
        boolean hasGeoCoding = geoCoding != null;
        this.canGetPixelPos = hasGeoCoding && geoCoding.canGetPixelPos();
        this.canGetGeoPos = hasGeoCoding && geoCoding.canGetGeoPos();
        boolean usePixelPos = !hasGeoCoding && switchGeoAndPixelPositionsEditable;
        PropertySet propertySet = this.bindingContext.getPropertySet();
        propertySet.addProperties(new Property[]{Property.create((String)PROPERTY_NAME_NAME, (Object)""), Property.create((String)PROPERTY_NAME_LABEL, (Object)""), Property.create((String)PROPERTY_NAME_DESCRIPTION, (Object)""), Property.create((String)PROPERTY_NAME_STYLE_CSS, (Object)""), Property.create((String)PROPERTY_NAME_LAT, (Object)0.0), Property.create((String)PROPERTY_NAME_LON, (Object)0.0), Property.create((String)PROPERTY_NAME_PIXEL_X, (Object)0.0), Property.create((String)PROPERTY_NAME_PIXEL_Y, (Object)0.0), Property.create((String)PROPERTY_NAME_USE_PIXEL_POS, (Object)usePixelPos)});
        propertySet.getProperty(PROPERTY_NAME_USE_PIXEL_POS).getDescriptor().setAttribute("enabled", (Object)(hasGeoCoding && switchGeoAndPixelPositionsEditable ? 1 : 0));
        propertySet.getProperty(PROPERTY_NAME_LAT).getDescriptor().setDisplayName("Latitude");
        propertySet.getProperty(PROPERTY_NAME_LAT).getDescriptor().setUnit("deg");
        propertySet.getProperty(PROPERTY_NAME_LON).getDescriptor().setDisplayName("Longitude");
        propertySet.getProperty(PROPERTY_NAME_LON).getDescriptor().setUnit("deg");
        propertySet.getProperty(PROPERTY_NAME_PIXEL_X).getDescriptor().setDisplayName("Pixel X");
        propertySet.getProperty(PROPERTY_NAME_PIXEL_X).getDescriptor().setUnit("pixels");
        propertySet.getProperty(PROPERTY_NAME_PIXEL_Y).getDescriptor().setDisplayName("Pixel Y");
        propertySet.getProperty(PROPERTY_NAME_PIXEL_Y).getDescriptor().setUnit("pixels");
        PropertyChangeListener geoChangeListener = evt -> this.updatePixelPos();
        propertySet.getProperty(PROPERTY_NAME_LAT).addPropertyChangeListener(geoChangeListener);
        propertySet.getProperty(PROPERTY_NAME_LON).addPropertyChangeListener(geoChangeListener);
        PropertyChangeListener pixelChangeListener = evt -> this.updateGeoPos();
        propertySet.getProperty(PROPERTY_NAME_PIXEL_X).addPropertyChangeListener(pixelChangeListener);
        propertySet.getProperty(PROPERTY_NAME_PIXEL_Y).addPropertyChangeListener(pixelChangeListener);
        JPanel panel = new PropertyPane(this.bindingContext).createPanel();
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)panel, "Center");
        content.add((Component)new JLabel("Pixel position is given in product raster coordinates"), "South");
        this.setContent(content);
        if (switchGeoAndPixelPositionsEditable) {
            this.bindingContext.bindEnabledState(PROPERTY_NAME_LAT, false, PROPERTY_NAME_USE_PIXEL_POS, (Object)true);
            this.bindingContext.bindEnabledState(PROPERTY_NAME_LON, false, PROPERTY_NAME_USE_PIXEL_POS, (Object)true);
            this.bindingContext.bindEnabledState(PROPERTY_NAME_PIXEL_X, true, PROPERTY_NAME_USE_PIXEL_POS, (Object)true);
            this.bindingContext.bindEnabledState(PROPERTY_NAME_PIXEL_Y, true, PROPERTY_NAME_USE_PIXEL_POS, (Object)true);
        }
    }

    public Product getProduct() {
        return this.product;
    }

    protected void onOK() {
        if (ProductNode.isValidNodeName((String)this.getName())) {
            super.onOK();
        } else {
            this.showInformationDialog("'" + this.getName() + "' is not a valid " + this.placemarkDescriptor.getRoleLabel() + " name.");
        }
    }

    public String getName() {
        return (String)this.bindingContext.getPropertySet().getValue(PROPERTY_NAME_NAME);
    }

    public void setName(String name) {
        this.bindingContext.getPropertySet().setValue(PROPERTY_NAME_NAME, (Object)name);
    }

    public String getLabel() {
        return (String)this.bindingContext.getPropertySet().getValue(PROPERTY_NAME_LABEL);
    }

    public void setLabel(String label) {
        this.bindingContext.getPropertySet().setValue(PROPERTY_NAME_LABEL, (Object)label);
    }

    public String getDescription() {
        return (String)this.bindingContext.getPropertySet().getValue(PROPERTY_NAME_DESCRIPTION);
    }

    public void setDescription(String description) {
        this.bindingContext.getPropertySet().setValue(PROPERTY_NAME_DESCRIPTION, (Object)description);
    }

    public String getStyleCss() {
        return (String)this.bindingContext.getPropertySet().getValue(PROPERTY_NAME_STYLE_CSS);
    }

    private void setStyleCss(String styleCss) {
        this.bindingContext.getPropertySet().setValue(PROPERTY_NAME_STYLE_CSS, (Object)styleCss);
    }

    public double getPixelX() {
        return (Double)this.bindingContext.getPropertySet().getValue(PROPERTY_NAME_PIXEL_X);
    }

    public void setPixelX(double pixelX) {
        this.bindingContext.getPropertySet().setValue(PROPERTY_NAME_PIXEL_X, (Object)pixelX);
    }

    public double getPixelY() {
        return (Double)this.bindingContext.getPropertySet().getValue(PROPERTY_NAME_PIXEL_Y);
    }

    public void setPixelY(double pixelY) {
        this.bindingContext.getPropertySet().setValue(PROPERTY_NAME_PIXEL_Y, (Object)pixelY);
    }

    public double getLat() {
        return (Double)this.bindingContext.getPropertySet().getValue(PROPERTY_NAME_LAT);
    }

    public void setLat(double lat) {
        this.bindingContext.getPropertySet().setValue(PROPERTY_NAME_LAT, (Object)lat);
    }

    public double getLon() {
        return (Double)this.bindingContext.getPropertySet().getValue(PROPERTY_NAME_LON);
    }

    public void setLon(double lon) {
        this.bindingContext.getPropertySet().setValue(PROPERTY_NAME_LON, (Object)lon);
    }

    public GeoPos getGeoPos() {
        return new GeoPos(this.getLat(), this.getLon());
    }

    public void setGeoPos(GeoPos geoPos) {
        if (geoPos != null) {
            this.setLat(geoPos.lat);
            this.setLon(geoPos.lon);
        } else {
            this.setLat(0.0);
            this.setLon(0.0);
        }
    }

    public PixelPos getPixelPos() {
        return new PixelPos(this.getPixelX(), this.getPixelY());
    }

    public void setPixelPos(PixelPos pixelPos) {
        if (pixelPos != null) {
            this.setPixelX(pixelPos.x);
            this.setPixelY(pixelPos.y);
        } else {
            this.setPixelX(0.0);
            this.setPixelY(0.0);
        }
    }

    private void updatePixelPos() {
        if (this.canGetPixelPos && !this.adjusting) {
            this.adjusting = true;
            PixelPos pixelPos = this.placemarkDescriptor.updatePixelPos(this.product.getSceneGeoCoding(), this.getGeoPos(), this.getPixelPos());
            this.setPixelPos(pixelPos);
            this.adjusting = false;
        }
    }

    private void updateGeoPos() {
        if (this.canGetGeoPos && !this.adjusting) {
            this.adjusting = true;
            GeoPos geoPos = this.placemarkDescriptor.updateGeoPos(this.product.getSceneGeoCoding(), this.getPixelPos(), this.getGeoPos());
            this.setGeoPos(geoPos);
            this.adjusting = false;
        }
    }

    public static boolean showEditPlacemarkDialog(Window parent, Product product, Placemark placemark, PlacemarkDescriptor placemarkDescriptor) {
        boolean ok;
        PlacemarkDialog dialog = new PlacemarkDialog(parent, product, placemarkDescriptor, placemarkDescriptor instanceof PinDescriptor);
        boolean belongsToProduct = placemark.getProduct() != null;
        String titlePrefix = belongsToProduct ? "Edit" : "New";
        String roleLabel = StringUtils.firstLetterUp((String)placemarkDescriptor.getRoleLabel());
        dialog.getJDialog().setTitle(titlePrefix + " " + roleLabel);
        dialog.getJDialog().setName(titlePrefix + "_" + roleLabel);
        dialog.setName(placemark.getName());
        dialog.setLabel(placemark.getLabel());
        dialog.setDescription(placemark.getDescription() != null ? placemark.getDescription() : "");
        dialog.adjusting = true;
        dialog.setPixelPos(placemark.getPixelPos());
        GeoPos geoPos = placemark.getGeoPos();
        dialog.setGeoPos(geoPos != null ? geoPos : new GeoPos(Double.NaN, Double.NaN));
        dialog.adjusting = false;
        dialog.setStyleCss(placemark.getStyleCss());
        boolean bl = ok = dialog.show() == 1;
        if (ok) {
            placemark.setName(dialog.getName());
            placemark.setLabel(dialog.getLabel());
            placemark.setDescription(dialog.getDescription());
            placemark.setStyleCss(dialog.getStyleCss());
            if (!belongsToProduct) {
                placemarkDescriptor.getPlacemarkGroup(product).add(placemark);
            }
            placemark.setGeoPos(dialog.getGeoPos());
        }
        return ok;
    }

    public static void main(String[] args) throws TransformException, FactoryException {
        Product product1 = new Product("A", "B", 360, 180);
        product1.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, 360, 180, -180.0, 90.0, 1.0, 1.0, 0.0, 0.0));
        PinDescriptor descriptor = PinDescriptor.getInstance();
        Placemark pin1 = Placemark.createPointPlacemark((PlacemarkDescriptor)descriptor, (String)"pin_1", (String)"Pin 1", (String)"Schnatter!", (PixelPos)new PixelPos(0.0, 0.0), (GeoPos)new GeoPos(), (GeoCoding)product1.getSceneGeoCoding());
        product1.getPinGroup().add(pin1);
        PlacemarkDialog.showEditPlacemarkDialog(null, product1, pin1, (PlacemarkDescriptor)descriptor);
    }
}

