/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.pixelinfo;

import com.bc.ceres.glevel.MultiLevelModel;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.ui.product.ProductSceneView;
import org.opengis.referencing.operation.TransformException;

public class PixelInfoViewUtils {
    public static Point2D.Double computeScenePos(ProductSceneView view, int x, int y) {
        Point2D.Double scenePos;
        RasterDataNode viewRaster = view.getRaster();
        AffineTransform i2mTransform = view.getBaseImageLayer().getImageToModelTransform(0);
        Point2D modelP = i2mTransform.transform(new Point2D.Double((double)x + 0.5, (double)y + 0.5), null);
        try {
            Point2D sceneP = viewRaster.getModelToSceneTransform().transform(modelP, (Point2D)new Point2D.Double());
            scenePos = new Point2D.Double(sceneP.getX(), sceneP.getY());
        }
        catch (TransformException te) {
            scenePos = new Point2D.Double(Double.NaN, Double.NaN);
        }
        return scenePos;
    }

    public static String getPixelValue(Point2D.Double scenePos, RasterDataNode raster) {
        String pixelString;
        Point2D.Double modelPos = new Point2D.Double();
        try {
            int pixelYForGrid;
            MultiLevelModel multiLevelModel;
            PixelPos rasterPos;
            int pixelXForGrid;
            raster.getSceneToModelTransform().transform((Point2D)scenePos, (Point2D)modelPos);
            pixelString = !Double.isNaN(modelPos.getX()) && !Double.isNaN(modelPos.getY()) ? (PixelInfoViewUtils.coordinatesAreInRasterBounds(raster, pixelXForGrid = MathUtils.floorInt((double)(rasterPos = (PixelPos)(multiLevelModel = raster.getMultiLevelModel()).getModelToImageTransform(0).transform(modelPos, (Point2D)new PixelPos())).getX()), pixelYForGrid = MathUtils.floorInt((double)rasterPos.getY())) ? raster.getPixelString(pixelXForGrid, pixelYForGrid) : "Invalid pos.") : "Invalid pos.";
        }
        catch (TransformException e) {
            pixelString = "Invalid pos.";
        }
        return pixelString;
    }

    private static boolean coordinatesAreInRasterBounds(RasterDataNode raster, int x, int y) {
        RenderedImage levelImage = raster.getSourceImage().getImage(0);
        return x >= 0 && y >= 0 && x < levelImage.getWidth() && y < levelImage.getHeight();
    }
}

