/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.pixelinfo;

import eu.esa.snap.netbeans.docwin.WindowUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.pixelinfo.PixelInfoUpdateService;
import org.esa.snap.rcp.pixelinfo.PixelInfoViewModelUpdater;
import org.esa.snap.rcp.pixelinfo.PixelInfoViewTableModel;
import org.esa.snap.rcp.util.CollapsibleItemsPanel;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSceneView;

public class PixelInfoView
extends JPanel {
    public static final String HELP_ID = "pixelInfoView";
    public static final String PREFERENCE_KEY_SHOW_ONLY_DISPLAYED_BAND_PIXEL_VALUES = "pixelview.showOnlyDisplayedBands";
    public static final String PREFERENCE_KEY_SHOW_GEO_POS_DECIMALS = "pixelview.showGeoPosDecimals";
    public static final String PREFERENCE_KEY_SHOW_PIXEL_POS_DECIMALS = "pixelview.showPixelPosDecimals";
    public static final String PREFERENCE_KEY_SHOW_PIXEL_POS_OFFSET_ONE = "pixelview.showPixelPosOffsetOne";
    public static final boolean PREFERENCE_DEFAULT_SHOW_DISPLAYED_BAND_PIXEL_VALUES = true;
    public static final boolean PREFERENCE_DEFAULT_SHOW_GEO_POS_DECIMALS = false;
    public static final boolean PREFERENCE_DEFAULT_SHOW_PIXEL_POS_DECIMALS = false;
    public static final boolean PREFERENCE_DEFAULT_SHOW_PIXEL_POS_OFFSET_1 = false;
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private static final int UNIT_COLUMN = 2;
    private boolean showGeoPosDecimals;
    static final int POSITION_INDEX = 0;
    static final int TIME_INDEX = 1;
    static final int BANDS_INDEX = 2;
    static final int TIE_POINT_GRIDS_INDEX = 3;
    static final int FLAGS_INDEX = 4;
    private final PropertyChangeListener displayFilterListener = this.createDisplayFilterListener();
    private final ProductNodeListener productNodeListener = this.createProductNodeListener();
    private boolean showPixelPosDecimals;
    private boolean showPixelPosOffset1;
    private DisplayFilter displayFilter;
    private final PixelInfoViewTableModel positionTableModel = new PixelInfoViewTableModel(new String[]{"Position", "Value", "Unit"});
    private final PixelInfoViewTableModel timeTableModel = new PixelInfoViewTableModel(new String[]{"Time", "Value", "Unit"});
    private final PixelInfoViewTableModel bandsTableModel = new PixelInfoViewTableModel(new String[]{"Band", "Value", "Unit"});
    private final PixelInfoViewTableModel tiePointGridsTableModel = new PixelInfoViewTableModel(new String[]{"Tie-Point Grid", "Value", "Unit"});
    private final PixelInfoViewTableModel flagsTableModel = new PixelInfoViewTableModel(new String[]{"Flag", "Value"});
    private final PixelInfoViewModelUpdater modelUpdater = new PixelInfoViewModelUpdater(this, this.positionTableModel, this.timeTableModel, this.bandsTableModel, this.tiePointGridsTableModel, this.flagsTableModel);
    private final PixelInfoUpdateService updateService = new PixelInfoUpdateService(this.modelUpdater);
    private CollapsibleItemsPanel collapsibleItemsPanel;

    public PixelInfoView() {
        super(new BorderLayout());
        this.setDisplayFilter(new DisplayFilter());
        final Preferences preferences = SnapApp.getDefault().getPreferences();
        preferences.addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                String propertyName = evt.getKey();
                if (PixelInfoView.PREFERENCE_KEY_SHOW_ONLY_DISPLAYED_BAND_PIXEL_VALUES.equals(propertyName)) {
                    PixelInfoView.this.setShowOnlyLoadedBands(preferences);
                } else if (PixelInfoView.PREFERENCE_KEY_SHOW_PIXEL_POS_DECIMALS.equals(propertyName)) {
                    PixelInfoView.this.setShowPixelPosDecimals(preferences);
                } else if (PixelInfoView.PREFERENCE_KEY_SHOW_GEO_POS_DECIMALS.equals(propertyName)) {
                    PixelInfoView.this.setShowGeoPosDecimals(preferences);
                } else if (PixelInfoView.PREFERENCE_KEY_SHOW_PIXEL_POS_OFFSET_ONE.equals(propertyName)) {
                    PixelInfoView.this.setShowPixelPosOffset1(preferences);
                }
            }
        });
        this.setShowOnlyLoadedBands(preferences);
        this.setShowPixelPosDecimals(preferences);
        this.setShowGeoPosDecimals(preferences);
        this.setShowPixelPosOffset1(preferences);
        this.createUI();
    }

    public void reset() {
        this.modelUpdater.resetTableModels();
    }

    ProductNodeListener getProductNodeListener() {
        return this.productNodeListener;
    }

    private ProductNodeListener createProductNodeListener() {
        return new ProductNodeListenerAdapter(){

            public void nodeChanged(ProductNodeEvent event) {
                PixelInfoView.this.updateService.requestUpdate();
            }

            public void nodeAdded(ProductNodeEvent event) {
                PixelInfoView.this.updateService.requestUpdate();
            }

            public void nodeRemoved(ProductNodeEvent event) {
                PixelInfoView.this.updateService.requestUpdate();
            }
        };
    }

    private PropertyChangeListener createDisplayFilterListener() {
        return evt -> {
            if (this.getCurrentProduct() != null) {
                this.updateService.requestUpdate();
                this.clearSelectionInRasterTables();
            }
        };
    }

    public Product getCurrentProduct() {
        return this.modelUpdater.getCurrentProduct();
    }

    private void setDisplayFilter(DisplayFilter displayFilter) {
        if (this.displayFilter != displayFilter) {
            if (this.displayFilter != null) {
                this.displayFilter.removePropertyChangeListener(this.displayFilterListener);
            }
            this.displayFilter = displayFilter;
            this.displayFilter.addPropertyChangeListener(this.displayFilterListener);
        }
    }

    DisplayFilter getDisplayFilter() {
        return this.displayFilter;
    }

    private void setShowPixelPosDecimals(boolean showPixelPosDecimals) {
        if (this.showPixelPosDecimals != showPixelPosDecimals) {
            this.showPixelPosDecimals = showPixelPosDecimals;
            this.updateService.requestUpdate();
        }
    }

    boolean getShowPixelPosDecimal() {
        return this.showPixelPosDecimals;
    }

    private void setShowGeoPosDecimals(boolean showGeoPosDecimals) {
        if (this.showGeoPosDecimals != showGeoPosDecimals) {
            this.showGeoPosDecimals = showGeoPosDecimals;
            this.updateService.requestUpdate();
        }
    }

    boolean getShowGeoPosDecimals() {
        return this.showGeoPosDecimals;
    }

    private void setShowPixelPosOffset1(boolean showPixelPosOffset1) {
        if (this.showPixelPosOffset1 != showPixelPosOffset1) {
            this.showPixelPosOffset1 = showPixelPosOffset1;
            this.updateService.requestUpdate();
        }
    }

    boolean getShowPixelPosOffset1() {
        return this.showPixelPosOffset1;
    }

    public void updatePixelValues(ProductSceneView view, int pixelX, int pixelY, int level, boolean pixelPosValid) {
        this.updateService.updateState(view, pixelX, pixelY, level, pixelPosValid);
    }

    private void createUI() {
        ValueCellRenderer pixelValueRenderer = new ValueCellRenderer();
        FlagCellRenderer flagCellRenderer = new FlagCellRenderer();
        this.setLayout(new BorderLayout());
        CollapsibleItemsPanel.Item<JTable> positionItem = CollapsibleItemsPanel.createTableItem("Position", 6, 3);
        positionItem.getComponent().setModel(this.positionTableModel);
        positionItem.getComponent().getColumnModel().getColumn(1).setCellRenderer(pixelValueRenderer);
        CollapsibleItemsPanel.Item<JTable> timeItem = CollapsibleItemsPanel.createTableItem("Time", 2, 3);
        timeItem.getComponent().setModel(this.timeTableModel);
        timeItem.getComponent().getColumnModel().getColumn(1).setCellRenderer(pixelValueRenderer);
        CollapsibleItemsPanel.Item<JTable> tiePointGridsItem = CollapsibleItemsPanel.createTableItem("Tie-Point Grids", 0, 3);
        tiePointGridsItem.getComponent().setModel(this.tiePointGridsTableModel);
        tiePointGridsItem.getComponent().getColumnModel().getColumn(1).setCellRenderer(pixelValueRenderer);
        CollapsibleItemsPanel.Item<JTable> bandsItem = CollapsibleItemsPanel.createTableItem("Bands", 18, 3);
        bandsItem.getComponent().setModel(this.bandsTableModel);
        bandsItem.getComponent().getColumnModel().getColumn(1).setCellRenderer(pixelValueRenderer);
        CollapsibleItemsPanel.Item<JTable> flagsItem = CollapsibleItemsPanel.createTableItem("Flags", 0, 2);
        flagsItem.getComponent().setModel(this.flagsTableModel);
        flagsItem.getComponent().getColumnModel().getColumn(1).setCellRenderer(flagCellRenderer);
        this.collapsibleItemsPanel = new CollapsibleItemsPanel(positionItem, timeItem, bandsItem, tiePointGridsItem, flagsItem);
        this.collapsibleItemsPanel.setCollapsed(0, false);
        this.collapsibleItemsPanel.setCollapsed(1, true);
        this.collapsibleItemsPanel.setCollapsed(2, false);
        this.collapsibleItemsPanel.setCollapsed(3, true);
        this.collapsibleItemsPanel.setCollapsed(4, true);
        this.collapsibleItemsPanel.addCollapseListener(new CollapsibleItemsPanel.CollapseListener(){

            @Override
            public void collapse(int index) {
            }

            @Override
            public void expand(int index) {
                PixelInfoView.this.updateService.requestUpdate();
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.collapsibleItemsPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.add((Component)scrollPane, "Center");
    }

    void clearSelectionInRasterTables() {
        String rasterName;
        JTable bandsTable = (JTable)this.collapsibleItemsPanel.getItem(2).getComponent();
        JTable tiePointGridsTable = (JTable)this.collapsibleItemsPanel.getItem(3).getComponent();
        bandsTable.clearSelection();
        tiePointGridsTable.clearSelection();
        RasterDataNode raster = this.modelUpdater.getCurrentRaster();
        if (raster != null && !this.selectCurrentRaster(rasterName = raster.getName(), bandsTable)) {
            this.selectCurrentRaster(rasterName, tiePointGridsTable);
        }
    }

    public void clearProductNodeRefs() {
        this.modelUpdater.clearProductNodeRefs();
        this.updateService.clearState();
    }

    boolean isCollapsiblePaneVisible(int index) {
        return !this.collapsibleItemsPanel.isCollapsed(index);
    }

    private boolean selectCurrentRaster(String rasterName, JTable table) {
        TableModel model = table.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            String s = model.getValueAt(i, 0).toString();
            if (!rasterName.equals(s)) continue;
            table.changeSelection(i, 0, false, false);
            return true;
        }
        return false;
    }

    private void setShowOnlyLoadedBands(Preferences preferences) {
        boolean showOnlyLoadedOrDisplayedBands = preferences.getBoolean(PREFERENCE_KEY_SHOW_ONLY_DISPLAYED_BAND_PIXEL_VALUES, true);
        this.displayFilter.setShowOnlyLoadedOrDisplayedBands(showOnlyLoadedOrDisplayedBands);
    }

    private void setShowPixelPosOffset1(Preferences preferences) {
        this.setShowPixelPosOffset1(preferences.getBoolean(PREFERENCE_KEY_SHOW_PIXEL_POS_OFFSET_ONE, false));
    }

    private void setShowPixelPosDecimals(Preferences preferences) {
        this.setShowPixelPosDecimals(preferences.getBoolean(PREFERENCE_KEY_SHOW_PIXEL_POS_DECIMALS, false));
    }

    private void setShowGeoPosDecimals(Preferences preferences) {
        this.setShowGeoPosDecimals(preferences.getBoolean(PREFERENCE_KEY_SHOW_GEO_POS_DECIMALS, false));
    }

    public static class DisplayFilter {
        private final Vector<PropertyChangeListener> propertyChangeListeners = new Vector();
        private boolean showOnlyLoadedOrDisplayedBands;

        public void addPropertyChangeListener(PropertyChangeListener displayFilterListener) {
            if (displayFilterListener != null && !this.propertyChangeListeners.contains(displayFilterListener)) {
                this.propertyChangeListeners.add(displayFilterListener);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener displayFilterListener) {
            if (displayFilterListener != null) {
                this.propertyChangeListeners.remove(displayFilterListener);
            }
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            for (int i = 0; i < this.propertyChangeListeners.size(); ++i) {
                this.propertyChangeListeners.elementAt(i).propertyChange(event);
            }
        }

        void setShowOnlyLoadedOrDisplayedBands(boolean v) {
            if (this.showOnlyLoadedOrDisplayedBands != v) {
                boolean oldValue = this.showOnlyLoadedOrDisplayedBands;
                this.showOnlyLoadedOrDisplayedBands = v;
                this.firePropertyChange("showOnlyLoadedOrDisplayedBands", oldValue, v);
            }
        }

        public boolean accept(ProductNode node) {
            if (node instanceof RasterDataNode) {
                RasterDataNode rasterDataNode = (RasterDataNode)node;
                if (this.showOnlyLoadedOrDisplayedBands) {
                    return rasterDataNode.hasRasterData() || WindowUtilities.getOpened(ProductSceneViewTopComponent.class).anyMatch(topComponent -> rasterDataNode == topComponent.getView().getRaster());
                }
            }
            return true;
        }
    }

    private static class FlagCellRenderer
    extends ValueCellRenderer {
        static final Color VERY_LIGHT_BLUE = new Color(230, 230, 255);
        static final Color VERY_LIGHT_RED = new Color(255, 230, 230);

        private FlagCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setForeground(Color.black);
            this.setBackground(Color.white);
            if (column == 1 && value != null) {
                if (value.equals("true")) {
                    this.setForeground(UIUtils.COLOR_DARK_RED);
                    this.setBackground(VERY_LIGHT_BLUE);
                } else if (value.equals("false")) {
                    this.setForeground(UIUtils.COLOR_DARK_BLUE);
                    this.setBackground(VERY_LIGHT_RED);
                }
            }
            return this;
        }
    }

    private static class ValueCellRenderer
    extends DefaultTableCellRenderer {
        Font valueFont;

        private ValueCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (this.valueFont == null) {
                Font font = this.getFont();
                this.valueFont = new Font("Monospaced", 0, font != null ? font.getSize() : 12);
            }
            this.setFont(this.valueFont);
            this.setHorizontalAlignment(4);
            return this;
        }
    }
}

