/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.nodes;

import com.bc.ceres.core.Assert;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.rcp.nodes.Bundle;

public class UndoableProductNodeInsertion<T extends ProductNode>
extends AbstractUndoableEdit {
    private ProductNodeGroup<T> group;
    private T productNode;
    private final int index;

    public UndoableProductNodeInsertion(ProductNodeGroup<T> productNodeGroup, T productNode) {
        Assert.notNull(productNodeGroup, (String)"group");
        Assert.notNull(productNode, (String)"node");
        this.group = productNodeGroup;
        this.productNode = productNode;
        this.index = productNodeGroup.indexOf(productNode);
    }

    public T getProductNode() {
        return this.productNode;
    }

    @Override
    public String getPresentationName() {
        return Bundle.LBL_UndoableProductNodeInsertionName(this.productNode.getName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.group.remove(this.productNode);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.index < this.group.getNodeCount()) {
            this.group.add(this.productNode);
        } else {
            this.group.add(this.index, this.productNode);
        }
    }

    @Override
    public void die() {
        this.group = null;
        this.productNode = null;
    }
}

