/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.nodes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

class RastersPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor,
VetoableChangeListener {
    static final String SEPARATOR = ",";
    private RasterDataNode[] validNodes;
    private CustomEditor customEditor;

    public RastersPropertyEditor(RasterDataNode ... validNodes) {
        this.validNodes = validNodes;
    }

    @Override
    public String getAsText() {
        RasterDataNode[] value = (RasterDataNode[])this.getValue();
        if (value == null) {
            return "";
        }
        return Stream.of(value).map(ProductNode::getName).collect(Collectors.joining(", "));
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        String[] names;
        if (text == null || text.trim().isEmpty()) {
            this.setValue(new RasterDataNode[0]);
            return;
        }
        HashMap<String, RasterDataNode> validNames = this.getValidNodeNames();
        ArrayList<RasterDataNode> nodes = new ArrayList<RasterDataNode>();
        for (String name : names = text.split(SEPARATOR)) {
            RasterDataNode node = validNames.get(name = name.trim());
            if (node == null) {
                throw new IllegalArgumentException("Illegal entry '" + name + "'!");
            }
            nodes.add(node);
        }
        this.setValue(nodes.toArray(new RasterDataNode[nodes.size()]));
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        this.customEditor = new CustomEditor();
        this.customEditor.setSelectedNodes((RasterDataNode[])this.getValue());
        return this.customEditor;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        propertyEnv.addVetoableChangeListener((VetoableChangeListener)this);
        propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("state".equals(evt.getPropertyName()) && this.customEditor != null) {
            RasterDataNode[] selectedNodes = this.customEditor.getSelectedNodes();
            String collect = Stream.of(selectedNodes).map(n -> n.getName()).collect(Collectors.joining("; "));
            if (PropertyEnv.STATE_VALID.equals(evt.getNewValue())) {
                try {
                    this.setValue(selectedNodes);
                }
                catch (IllegalArgumentException e) {
                    throw new PropertyVetoException(e.getMessage(), evt);
                }
            }
            this.customEditor = null;
        }
    }

    private HashMap<String, RasterDataNode> getValidNodeNames() {
        HashMap<String, RasterDataNode> validNames = new HashMap<String, RasterDataNode>();
        for (RasterDataNode node : this.validNodes) {
            validNames.put(node.getName(), node);
        }
        return validNames;
    }

    private class CustomEditor
    extends JPanel {
        private final JList<String> list;
        private final DefaultListModel<String> listModel;

        public CustomEditor() {
            super(new BorderLayout(4, 4));
            this.setBorder(new EmptyBorder(8, 8, 8, 8));
            this.listModel = new DefaultListModel();
            this.list = new JList<String>(this.listModel);
            this.list.setSelectionMode(2);
            JScrollPane scrollPane = new JScrollPane(this.list);
            this.add((Component)new JLabel("Available rasters:"), "North");
            this.add((Component)scrollPane, "Center");
        }

        public RasterDataNode[] getSelectedNodes() throws PropertyVetoException {
            int[] selectedIndices;
            HashMap<String, RasterDataNode> validNodeNames = RastersPropertyEditor.this.getValidNodeNames();
            ArrayList<RasterDataNode> nodes = new ArrayList<RasterDataNode>();
            for (int index : selectedIndices = this.list.getSelectedIndices()) {
                String name = this.listModel.get(index);
                RasterDataNode node = validNodeNames.get(name);
                if (node == null) continue;
                nodes.add(node);
            }
            return nodes.toArray(new RasterDataNode[nodes.size()]);
        }

        public void setSelectedNodes(RasterDataNode[] selectedNodes) {
            HashMap<RasterDataNode[], Integer> indexMap = new HashMap<RasterDataNode[], Integer>();
            this.listModel.clear();
            for (int i = 0; i < RastersPropertyEditor.this.validNodes.length; ++i) {
                RasterDataNode[] node = RastersPropertyEditor.this.validNodes[i];
                this.listModel.addElement(node.getName());
                indexMap.put(node, i);
            }
            ArrayList<Integer> indexList = new ArrayList<Integer>();
            for (RasterDataNode selectedNode : selectedNodes) {
                Integer index = (Integer)indexMap.get(selectedNode);
                if (index == null) continue;
                indexList.add(index);
            }
            int[] indices = new int[indexList.size()];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)indexList.get(i);
            }
            this.list.setSelectedIndices(indices);
        }
    }
}

