/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.nodes;

import com.bc.ceres.core.Assert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.rcp.nodes.PNGroupBase;
import org.esa.snap.rcp.nodes.PNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ProductGroupNode
extends AbstractNode {
    private final ProductManager productManager;
    private final PGroup group;
    private final Map<Product, ProductNodeListener> productNodeListenerMap;

    public ProductGroupNode(ProductManager productManager) {
        super(Children.LEAF);
        Assert.notNull((Object)productManager, (String)"productManager");
        this.productManager = productManager;
        this.group = new PGroup();
        this.productNodeListenerMap = new HashMap<Product, ProductNodeListener>();
        this.setChildren(Children.create((ChildFactory)this.group, (boolean)false));
        this.setDisplayName("Products");
        productManager.addListener(new ProductManager.Listener(){

            public void productAdded(ProductManager.Event event) {
                ProductGroupNode.this.group.refresh();
            }

            public void productRemoved(ProductManager.Event event) {
                ProductGroupNode.this.uninstallListener(event.getProduct());
                ProductGroupNode.this.group.refresh();
            }
        });
    }

    private void installListener(PNode node) {
        Product newProduct = node.getProduct();
        newProduct.addProductNodeListener((ProductNodeListener)node);
        this.productNodeListenerMap.put(newProduct, node);
    }

    private void uninstallListener(Product oldProduct) {
        ProductNodeListener productNodeListener = this.productNodeListenerMap.remove(oldProduct);
        if (productNodeListener != null) {
            oldProduct.removeProductNodeListener(productNodeListener);
        }
    }

    class PGroup
    extends PNGroupBase<Product> {
        PGroup() {
        }

        protected boolean createKeys(List<Product> list) {
            list.addAll(Arrays.asList(ProductGroupNode.this.productManager.getProducts()));
            return true;
        }

        protected Node createNodeForKey(Product key) {
            PNode node = new PNode(key);
            ProductGroupNode.this.installListener(node);
            return node;
        }
    }
}

