/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.nodes;

import com.bc.ceres.core.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.rcp.nodes.Bundle;
import org.esa.snap.rcp.nodes.NodeExpansionManager;
import org.esa.snap.rcp.nodes.PNGGroup;
import org.esa.snap.rcp.nodes.PNGroup;
import org.esa.snap.rcp.nodes.PNGroupNode;
import org.esa.snap.rcp.nodes.PNNode;
import org.openide.nodes.Node;

abstract class PNGroupingGroup
extends PNGroup<Object> {
    private final String displayName;
    private final ProductNodeGroup group;
    List<Node> nodes;
    Map<String, Boolean> nodesAreSelected;

    protected PNGroupingGroup(String displayName, ProductNodeGroup group) {
        Assert.notNull((Object)group, (String)"group");
        this.displayName = displayName;
        this.group = group;
        this.nodes = new ArrayList<Node>();
        this.nodesAreSelected = new HashMap<String, Boolean>();
    }

    @Override
    public Product getProduct() {
        return this.group.getProduct();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    boolean isDirectChild(ProductNode productNode) {
        return this.group.contains(productNode);
    }

    @Override
    void refresh() {
        for (Node node : this.nodes) {
            this.nodesAreSelected.put(node.getDisplayName(), NodeExpansionManager.isNodeExpanded(node));
        }
        this.nodes.clear();
        super.refresh();
        for (Node node : this.nodes) {
            if (!this.nodesAreSelected.containsKey(node.getDisplayName()) || !this.nodesAreSelected.get(node.getDisplayName()).booleanValue()) continue;
            NodeExpansionManager.expandNode(node);
        }
        this.nodesAreSelected.clear();
    }

    @Override
    boolean shallReactToPropertyChange(String propertyName) {
        return propertyName.equals("autoGrouping");
    }

    static class M
    extends PNGroupingGroup {
        private final ProductNodeGroup<Mask> group;

        protected M(ProductNodeGroup<Mask> group) {
            super(Bundle.LBL_MaskGroupName(), group);
            this.group = group;
        }

        protected Node createNodeForKey(Object key) {
            if (key instanceof Mask) {
                return new PNNode.M((Mask)key);
            }
            PNGroupNode pnGroupNode = new PNGroupNode((PNGroup)((Object)key));
            this.nodes.add(pnGroupNode);
            return pnGroupNode;
        }

        protected boolean createKeys(List<Object> list) {
            int i;
            Product.AutoGrouping autoGrouping = this.getProduct().getAutoGrouping();
            if (autoGrouping == null) {
                for (int i2 = 0; i2 < this.group.getNodeCount(); ++i2) {
                    list.add(this.group.get(i2));
                }
                return true;
            }
            ProductNodeGroup[] autogroupingNodes = new ProductNodeGroup[autoGrouping.size() + 1];
            for (i = 0; i < autoGrouping.size(); ++i) {
                autogroupingNodes[i] = new ProductNodeGroup(((String[])autoGrouping.get(i))[0]);
            }
            autogroupingNodes[autoGrouping.size()] = new ProductNodeGroup(Bundle.LBL_MaskGroupName());
            for (i = 0; i < this.group.getNodeCount(); ++i) {
                Mask mask = (Mask)this.group.get(i);
                int index = autoGrouping.indexOf(mask.getName());
                if (index != -1) {
                    autogroupingNodes[index].add((ProductNode)mask);
                    continue;
                }
                autogroupingNodes[autoGrouping.size()].add((ProductNode)mask);
            }
            for (i = 0; i < autoGrouping.size(); ++i) {
                if (autogroupingNodes[i].getNodeCount() <= 0) continue;
                list.add((Object)new PNGGroup.M(((String[])autoGrouping.get(i))[0], (ProductNodeGroup<Mask>)autogroupingNodes[i], this.getProduct()));
            }
            for (i = 0; i < autogroupingNodes[autoGrouping.size()].getNodeCount(); ++i) {
                list.add(autogroupingNodes[autoGrouping.size()].get(i));
            }
            return true;
        }
    }

    static class TPG
    extends PNGroupingGroup {
        private final ProductNodeGroup<TiePointGrid> group;

        protected TPG(ProductNodeGroup<TiePointGrid> group) {
            super(Bundle.LBL_TiePointGroupName(), group);
            this.group = group;
        }

        protected Node createNodeForKey(Object key) {
            if (key instanceof TiePointGrid) {
                return new PNNode.TPG((TiePointGrid)key);
            }
            PNGroupNode pnGroupNode = new PNGroupNode((PNGroup)((Object)key));
            this.nodes.add(pnGroupNode);
            return pnGroupNode;
        }

        protected boolean createKeys(List<Object> list) {
            int i;
            Product.AutoGrouping autoGrouping = this.getProduct().getAutoGrouping();
            if (autoGrouping == null) {
                for (int i2 = 0; i2 < this.group.getNodeCount(); ++i2) {
                    list.add(this.group.get(i2));
                }
                return true;
            }
            ProductNodeGroup[] autogroupingNodes = new ProductNodeGroup[autoGrouping.size() + 1];
            for (i = 0; i < autoGrouping.size(); ++i) {
                autogroupingNodes[i] = new ProductNodeGroup(((String[])autoGrouping.get(i))[0]);
            }
            autogroupingNodes[autoGrouping.size()] = new ProductNodeGroup(Bundle.LBL_TiePointGroupName());
            for (i = 0; i < this.group.getNodeCount(); ++i) {
                TiePointGrid tiePointGrid = (TiePointGrid)this.group.get(i);
                int index = autoGrouping.indexOf(tiePointGrid.getName());
                if (index != -1) {
                    autogroupingNodes[index].add((ProductNode)tiePointGrid);
                    continue;
                }
                autogroupingNodes[autoGrouping.size()].add((ProductNode)tiePointGrid);
            }
            for (i = 0; i < autoGrouping.size(); ++i) {
                if (autogroupingNodes[i].getNodeCount() <= 0) continue;
                list.add((Object)new PNGGroup.TPG(((String[])autoGrouping.get(i))[0], (ProductNodeGroup<TiePointGrid>)autogroupingNodes[i], this.getProduct()));
            }
            for (i = 0; i < autogroupingNodes[autoGrouping.size()].getNodeCount(); ++i) {
                list.add(autogroupingNodes[autoGrouping.size()].get(i));
            }
            return true;
        }
    }

    static class B
    extends PNGroupingGroup {
        private final ProductNodeGroup<Band> group;

        protected B(ProductNodeGroup<Band> group) {
            super(Bundle.LBL_BandGroupName(), group);
            this.group = group;
        }

        protected Node createNodeForKey(Object key) {
            if (key instanceof Band) {
                return new PNNode.B((Band)key);
            }
            PNGroupNode pnGroupNode = new PNGroupNode((PNGroup)((Object)key));
            this.nodes.add(pnGroupNode);
            return pnGroupNode;
        }

        protected boolean createKeys(List<Object> list) {
            int i;
            Product.AutoGrouping autoGrouping = this.getProduct().getAutoGrouping();
            if (autoGrouping == null) {
                for (int i2 = 0; i2 < this.group.getNodeCount(); ++i2) {
                    list.add(this.group.get(i2));
                }
                return true;
            }
            ProductNodeGroup[] autogroupingNodes = new ProductNodeGroup[autoGrouping.size() + 1];
            for (i = 0; i < autoGrouping.size(); ++i) {
                autogroupingNodes[i] = new ProductNodeGroup(((String[])autoGrouping.get(i))[0]);
            }
            autogroupingNodes[autoGrouping.size()] = new ProductNodeGroup(Bundle.LBL_BandGroupName());
            for (i = 0; i < this.group.getNodeCount(); ++i) {
                Band band = (Band)this.group.get(i);
                int index = autoGrouping.indexOf(band.getName());
                if (index != -1) {
                    autogroupingNodes[index].add((ProductNode)band);
                    continue;
                }
                autogroupingNodes[autoGrouping.size()].add((ProductNode)band);
            }
            for (i = 0; i < autoGrouping.size(); ++i) {
                if (autogroupingNodes[i].getNodeCount() <= 0) continue;
                list.add((Object)new PNGGroup.B(((String[])autoGrouping.get(i))[0], (ProductNodeGroup<Band>)autogroupingNodes[i], this.getProduct()));
            }
            for (i = 0; i < autogroupingNodes[autoGrouping.size()].getNodeCount(); ++i) {
                list.add(autogroupingNodes[autoGrouping.size()].get(i));
            }
            return true;
        }
    }
}

