/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.metadata;

import eu.esa.snap.netbeans.docwin.DocumentTopComponent;
import eu.esa.snap.netbeans.docwin.WindowUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.rcp.metadata.MetadataOutlineCellRenderer;
import org.esa.snap.ui.product.metadata.MetadataTableInnerElement;
import org.netbeans.swing.outline.Outline;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.Node;

public class MetadataViewTopComponent
extends DocumentTopComponent<MetadataElement, OutlineView>
implements ExplorerManager.Provider {
    private static final String[] COLUMN_NAMES = new String[]{"Value", "Value", "Type", "Type", "Unit", "Unit", "Description", "Description"};
    private static final int[] COLUMN_WIDTHS = new int[]{180, 180, 50, 40, 200};
    private static final String nodesColumnName = "Name";
    private ExplorerManager em = new ExplorerManager();
    private OutlineView outlineView;

    public MetadataViewTopComponent(MetadataElement element) {
        super((Object)element);
        this.updateDisplayName();
        this.setName(this.getDisplayName());
        this.initView();
        MetadataTableInnerElement tableInnerElement = new MetadataTableInnerElement(element);
        this.em.setRootContext((Node)tableInnerElement.createNode());
    }

    public OutlineView getView() {
        return this.outlineView;
    }

    private void initView() {
        this.setLayout(new BorderLayout());
        this.outlineView = new OutlineView(nodesColumnName);
        this.outlineView.setPropertyColumns(COLUMN_NAMES);
        Outline outline = this.outlineView.getOutline();
        outline.setRootVisible(false);
        StringDecimalFormatRenderer decimalTableCellRenderer = new StringDecimalFormatRenderer();
        outline.setDefaultRenderer(Double.class, (TableCellRenderer)decimalTableCellRenderer);
        outline.setDefaultRenderer(Float.class, (TableCellRenderer)decimalTableCellRenderer);
        outline.setDefaultRenderer(Node.Property.class, (TableCellRenderer)((Object)new MetadataOutlineCellRenderer()));
        TableColumnModel columnModel = outline.getColumnModel();
        columnModel.getColumn(0).setCellRenderer((TableCellRenderer)((Object)new MetadataOutlineCellRenderer()));
        int[] columnWidths = COLUMN_WIDTHS;
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        this.add((Component)this.outlineView, "Center");
    }

    private void updateDisplayName() {
        this.setDisplayName(WindowUtilities.getUniqueTitle((String)((MetadataElement)this.getDocument()).getDisplayName(), MetadataViewTopComponent.class));
    }

    public ExplorerManager getExplorerManager() {
        return this.em;
    }

    public static class StringDecimalFormatRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JLabel) {
                JLabel label = (JLabel)comp;
                label.setHorizontalAlignment(2);
                if (value instanceof Float || value instanceof Double) {
                    label.setText(String.valueOf(value));
                } else {
                    label.setText("n/a");
                }
            }
            return comp;
        }
    }
}

