/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.mask;

import java.awt.BorderLayout;
import javax.swing.AbstractButton;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.mask.MaskForm;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.ui.help.HelpDisplayer;
import org.esa.snap.ui.product.ProductSceneView;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.util.HelpCtx;

public abstract class MaskToolTopComponent
extends ToolTopComponent
implements HelpCtx.Provider {
    private MaskForm maskForm;

    public void initUI() {
        this.setLayout(new BorderLayout());
        this.maskForm = this.createMaskForm(this, e -> {
            VectorDataNode vectorDataNode;
            Mask selectedMask;
            ProductSceneView sceneView = this.getSelectedProductSceneView();
            if (sceneView != null && (selectedMask = this.maskForm.getSelectedMask()) != null && (vectorDataNode = Mask.VectorDataType.getVectorData((Mask)selectedMask)) != null) {
                sceneView.selectVectorDataLayer(vectorDataNode);
            }
        });
        AbstractButton helpButton = this.maskForm.getHelpButton();
        if (helpButton != null) {
            helpButton.addActionListener(e -> HelpDisplayer.show((HelpCtx)this.getHelpCtx()));
            helpButton.setName("helpButton");
        }
        this.updateMaskForm(this.getSelectedProductSceneView());
        SnapApp.getDefault().getProductManager().addListener((ProductManager.Listener)new MaskPTL());
        SnapApp.getDefault().getSelectionSupport(Product.class).addHandler((oldValue, newValue) -> this.updateMaskForm(this.getSelectedProductSceneView()));
        this.maskForm.updateState();
        this.setDisplayName(this.getTitle());
        this.add(this.maskForm.createContentPanel(), "Center");
    }

    private void updateMaskForm(ProductSceneView view) {
        if (view == null) {
            ProductNode selectedProductNode = SnapApp.getDefault().getSelectedProductNode(SnapApp.SelectionSourceHint.EXPLORER);
            if (selectedProductNode instanceof RasterDataNode) {
                RasterDataNode rdn = (RasterDataNode)selectedProductNode;
                this.maskForm.reconfigureMaskTable(rdn.getProduct(), rdn);
            } else if (selectedProductNode instanceof Product) {
                Product product = (Product)selectedProductNode;
                this.maskForm.reconfigureMaskTable(product, null);
            } else if (selectedProductNode != null && selectedProductNode.getProduct() != null) {
                this.maskForm.reconfigureMaskTable(selectedProductNode.getProduct(), null);
            } else {
                this.maskForm.clearMaskTable();
            }
        } else {
            this.maskForm.reconfigureMaskTable(view.getProduct(), view.getRaster());
        }
    }

    @Override
    protected void productSceneViewSelected(@NonNull ProductSceneView view) {
        this.updateMaskForm(view);
    }

    @Override
    protected void productSceneViewDeselected(@NonNull ProductSceneView view) {
        this.updateMaskForm(this.getSelectedProductSceneView());
    }

    protected abstract MaskForm createMaskForm(ToolTopComponent var1, ListSelectionListener var2);

    protected abstract String getTitle();

    private class MaskPTL
    implements ProductManager.Listener {
        private MaskPTL() {
        }

        public void productAdded(ProductManager.Event event) {
        }

        public void productRemoved(ProductManager.Event event) {
            if (MaskToolTopComponent.this.maskForm.getProduct() == event.getProduct()) {
                MaskToolTopComponent.this.updateMaskForm(MaskToolTopComponent.this.getSelectedProductSceneView());
            }
        }
    }
}

